/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: errfree.c,v 6.6 1999/12/31 21:27:22 jsquyres Exp $
 *
 *	Function:	- free error handler
 *	Accepts:	- ptr error handler
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <MPISYSF.h>

/*@
  MPI_Errhandler_free - Frees an MPI-style errorhandler

Input Parameter:
. errhandler - MPI error handler (handle).  Set to 'MPI_ERRHANDLER_NULL' on 
exit.

.N fortran

.N Errors
.N MPI_SUCCESS
.N MPI_ERR_ARG

.N ACK
@*/
int MPI_Errhandler_free(MPI_Errhandler* errhdl)
{
	lam_initerr_m();
	lam_setfunc_m(BLKMPIERRFREE);
/*
 * Check the arguments.
 */
	if (errhdl == 0 || *errhdl == MPI_ERRHANDLER_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIERRFREE, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Only internal library calls can free predefined handlers.
 */
	if (lam_numfuncs() == 1 && (*errhdl == MPI_ERRORS_ARE_FATAL
			|| *errhdl == MPI_ERRORS_RETURN)) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIERRFREE, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Free the handler.
 */
	if (--((*errhdl)->eh_refcount) == 0) {

		if (*errhdl == MPI_ERRORS_ARE_FATAL
				|| *errhdl == MPI_ERRORS_RETURN) {
			return(lam_errfunc(MPI_COMM_WORLD,
				BLKMPIERRFREE, lam_mkerr(MPI_ERR_INTERN, 0)));
		}

		if ((*errhdl)->eh_f77handle >= 0) {
			lam_F_free_hdl((*errhdl)->eh_f77handle);
		}

		free((char *) *errhdl);
	}

	*errhdl = MPI_ERRHANDLER_NULL;

	lam_resetfunc_m(BLKMPIERRFREE);
	return(MPI_SUCCESS);
}
