/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: errclass.c,v 6.3 1999/12/31 21:27:21 jsquyres Exp $
 *
 *	Function:	- get error class of error code
 *	Accepts:	- error code
 *			- ptr error class (returned value)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

/*@
   MPI_Error_class - Converts an error code into an error class

Input Parameter:
. errcode - Error code returned by an MPI routine 

Output Parameter:
. class - Error class associated with 'errcode'

.N fortran

.N Errors
.N MPI_ERR_ARG

.N ACK
@*/
int MPI_Error_class(int errcode, int *class)
{
	int		func;
	int		error;

	lam_initerr();
	lam_setfunc(BLKMPIERRCLASS);
/*
 * Check the arguments.
 */
	if (class == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIERRCLASS, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	lam_bkerr(errcode, class, &func, &error);

	lam_resetfunc(BLKMPIERRCLASS);
	return(MPI_SUCCESS);
}
