/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD/NJN
 *
 *	$Id: attrput.c,v 6.4 1999/12/31 21:27:16 jsquyres Exp $
 *
 *	Function:	- put value in attribute
 *			- assign attribute to communicator
 *	Accepts:	- communicator
 *			- attribute key
 *			- attribute value
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

/*@

MPI_Attr_put - Stores a communicator attribute value associated with a key

Input Parameters:
+ comm - communicator to which attribute will be attached (handle) 
. key - key value, as returned by  'MPI_COMM_CREATE_KEYVAL' (integer) 
- value - attribute value 

.N Wrapper MPI_Comm_set_attr

.N ACK
@*/
int MPI_Attr_put(MPI_Comm comm, int key, void *value)
{
	int		err;

	lam_initerr_m();
	lam_setfunc_m(BLKMPIATTRPUT);

	err = MPI_Comm_set_attr(comm, key, value);
	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPIATTRPUT, err));
	}

	lam_resetfunc_m(BLKMPIATTRPUT);
	return(MPI_SUCCESS);
}
