/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log: proc_schema.h,v $
 *	Revision 1.1  2000/02/12 00:14:19  jsquyres
 *	Moved share/boot/proc_schema.a to share/include/proc_schema.h 'cause
 *	multiple places include it.
 *	
 *	Revision 6.2  1999/05/23 19:28:25  kmeyer1
 *	added copyrights
 *	
 *	Revision 6.1  1996/11/24 00:44:59  nevin
 *	Ohio Release
 *	
 * Revision 6.0  96/02/29  13:41:36  gdburns
 * Ohio Release
 * 
 *	Function:	- internal representation of a process schema
 */

#ifndef _PROC_SCHEMA
#define _PROC_SCHEMA

#include <portable.h>

#define PSC_MAXLINE	256
#define PSC_DELAY	1

/*
 * process schema list entry
 */
struct psc {
	char		**psc_argv;	/* argv */
	int4		psc_argc;	/* argc */
	int4		psc_delay;	/* delay (in seconds) after startup */
	int4		psc_flags;	/* info bits */
};

#endif
