/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	$Id: ndi.h,v 6.4 1999/04/01 21:38:52 kmeyer1 Exp $
 * 
 *	Function:	- node identifier parsing
 */

#ifndef _NDI_H
#define _NDI_H

#include <lam_config.h>
#include "all_list.h"
#include "lam.h"

/*
 * node identifier list entry
 */
struct ndi {
	int4		ndi_node;	/* ID itself */
	int4		ndi_flags;	/* descriptive flags */
	int4		ndi_count;	/* # IDs actually represented */
	int4		ndi_index;	/* position in list (legacy) */
};

#ifdef __cplusplus
extern "C" {
#endif

extern LIST *	ndi_parse __ARGS((int argc, char ** argv, char *** othersv));
extern LIST *	ndi_resolve __ARGS((LIST * nodelist));
extern void	ndi_fmt __ARGS((int4 node, char * fmt_str));
extern int4	ndi_parse1 __ARGS((char * s));
extern void	ndi_usage __ARGS((void));

#ifdef __cplusplus
}
#endif

#endif	/* _NDI_H */
