/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	$Id: lamthreads.h,v 6.1 1999/12/29 14:11:09 jsquyres Exp $
 *
 *	Function:	- header for LAM thread interface
 */

#ifndef _MPI_LAM_THREADS_H
#define _MPI_LAM_THREADS_H

#include <lam_config.h>


/*
 * types
 */
typedef struct {
  lam_real_mutex_t mutex;
  lam_thread_t thread;
} lam_mutex_t;

/*
 * Main LAM thread globals
 */
extern int		lam_thread_level;
extern lam_thread_t	lam_main_thread;
extern lam_mutex_t	lam_mpi_mutex;
extern lam_mutex_t	lam_updown_mutex;


/*
 * LAM thread interface
 */
void		lam_thread_init(int requested, int *pprovided);
lam_thread_t	lam_thread_self(void);
int		lam_thread_compare(lam_thread_t a, lam_thread_t b);
void		lam_thread_finalize(void);

/*
 * LAM mutex interface
 */
void		lam_mutex_init(lam_mutex_t *mutex);
void		lam_mutex_lock(lam_mutex_t *mutex);
int		lam_mutex_is_owner(lam_mutex_t *mutex);
void		lam_mutex_unlock(lam_mutex_t *mutex);
void		lam_mutex_finalize(lam_mutex_t *mutex);


#endif	/* _MPI_LAM_THREADS_H */
