/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *
 *      $Id: dl_inet.h,v 6.5 2000/08/17 20:31:05 jsquyres Exp $
 * 
 *	Function:	- dli/dlo_inet constants and templates
 */

#ifndef _DL_INET
#define _DL_INET

#include <sys/types.h>
#include <netinet/in.h>

#include <lam_config.h>
#include <portable.h>
#include <net.h>

/*
 * dli/dlo common constants
 */
#define TO_DLO_ESTIMATE	200		/* timeout estimate count trigger */

#define DLDEFPORT	5555		/* default dl_inet port */
#define DLMAXSEQ	0x40000000	/* max sequence # */
#define DLMINFRAMELEN	(sizeof(struct dlframe) - MAXNMSGLEN)
					/* header-only frame size */

/*
 * dlo constants
 */
#define DOSLOTCNT	8		/* max # window slots */
#define DOMAXPENDING	3		/* max # pending messages */
#define DOMAXSTALE	((int) (LAM_TO_DLO_IDLE / (LAM_TO_DLO_ACK / 1000000.0)))
					/* causes an alive message */
#ifndef DOMAXRESEND
#define DOMAXRESEND	300		/* max # resends per message */
#endif

/*
 * dlo slot flags
 */
#define DORESEND	1		/* resend-on-timeout flag */
#define DOPENDING	2		/* message pending */
#define DORESERVED	4		/* reserved for receive */

/*
 * sequence macros
 */
#define	seqinc(a) ((a + 1) % DLMAXSEQ)
#define	seqmin(a, b) (((b - a) > 0) ? (((b - a) > (DLMAXSEQ / 2)) ? b : a) : \
		(((a - b) > (DLMAXSEQ / 2)) ? a : b))

/*
 * dlo requests
 */
#define DOQSETLINK	0
#define DOQREMLINK	1
#define DOQGETLINKS	2
#define DOQVOPEN	3		/* open dlo valve */
#define DOQVCLOSE	4		/* close dlo valve */

/*
 * dli requests
 */
#define DIQSETLINK	0
#define DIQSANITY	1
#define DIQREMLINK	2

/*
 * dlo request template
 */
struct doreq {
	int4		doq_req;	/* request code */
	int4		doq_src_node;	/* client node */
	int4		doq_src_event;	/* client event */
	int4		doq_link;	/* output link */
};

/*
 * dlo reply
 */
struct doreply {
	int4		dor_reply;	/* reply code */
	int4		dor_nlinks;	/* # datalinks */
};

/*
 * dli request
 */
struct direq {
	int4		diq_req;	/* request code */
	int4		diq_src_node;	/* client node */
	int4		diq_src_event;	/* client event */
	int4		diq_link;
};

/*
 * dli reply
 */
struct direply {
	int4		dir_reply;	/* reply code */
};

/*
 * output datalink
 */
struct dolink {
	int4		dol_link;	/* link number */
	int4		dol_seqgive;	/* next assignable sequence # */
	int4		dol_seqsend;	/* next sendable sequence # */
	int4		dol_npending;	/* # pending seq. # */
	int4		dol_idle;	/* idle timeout periods */
	struct sockaddr_in
			dol_addr;	/* dli socket address */
};

/*
 * input datalink
 */
struct dilink {
	int4		dil_link;	/* link number */
	int4		dil_seqrecv;	/* next recvable sequence # */
	struct sockaddr_in
			dil_addr;	/* dli socket address */
};

/*
 * network portion of struct nmsg
 */
struct dlheader {
	int4		dlh_node;
	int4		dlh_event;
	int4		dlh_type;
	int4		dlh_length;
	int4		dlh_flags;
	int4		dlh_data[NHDSIZE];
};

/*
 * datalink frame
 */
struct dlframe {
	int4		dlf_src_node;	/* message source node */
	int4		dlf_seqnum;	/* message sequence # */
	struct dlheader	dlf_msghead;	/* message header */
	char		dlf_msg[MAXNMSGLEN];
					/* message body */
};

struct doslot {
	int4		dos_link;	/* outgoing link */
	int4		dos_flags;	/* slot status flags */
	int4		dos_resend;	/* # resends */
	struct dlframe	dos_frame;	/* datalink frame */
};

struct dlack {
	int4		dla_seqnum;	/* ack sequence # */
	int4		dla_destid;	/* destination node */
};

#ifdef __cplusplus
extern "C" {
#endif

extern int		ldogetlinks __ARGS((struct dolink **pdol,int4 *pndol));
extern int		ldosetlink __ARGS((struct dolink *pdol));
extern int		ldoremlink __ARGS((int4 link));

#ifdef __cplusplus
}
#endif

#endif /* _DL_INET */
