/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Id: boot.h,v 1.4 2001/02/12 21:17:12 jsquyres Exp $
 * 
 *	Function:	- constants associated with booting
 */

#ifndef _BOOT
#define _BOOT

#include <stdio.h>

#include <lamnet.h>
#include <all_list.h>


/*
 * default configuration files
 */
#define DEFFCONFIGH	"lam-conf.otb"

/*
 * default tools
 */
#define DEFTRESETH	"tkill"

/*
 * share/boot/inetexec.c
 */
int inetexec(char *host, char *username, char **argv, char *prefix,
	     int fl_fast);

/*
 * share/boot/bhostparse.c 
 */
int bhostparse(FILE *fp, struct lamnode **plamnet, int *pnlamnet);

/*
 * share/boot/lambootagent.c
 */
int lambootagent(struct lamnode *lamnet, int nlamnet, int *nboot, int *nrun);

/*
 * share/boot/psc_parse.c
 */
int psc_parse(FILE *fp, LIST **list_psc, char **argv_var);

#endif
