/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	Revision 6.2  1999/03/17 14:19:38  jsquyres
 *	
 *	Revision 6.1  1996/11/23 21:54:38  nevin
 *	Ohio Release
 *	
 * Revision 6.0  96/02/29  13:52:55  gdburns
 * Ohio Release
 * 
 *	Function:	- constants & templates for all_opt
 */

#ifndef _ALLOPT
#define _ALLOPT

#include <lam_config.h>

/*
 * constants
 */
#define AOVARNUM	-1			/* variable # arguments */

/* 
 * structures
 */
struct ao_desc {
	int		ao_ntaken;		/* # options taken */
	struct ao_opt	*ao_opttop;		/* options list top */
	struct ao_opt	*ao_optend;		/* options list end */
	struct ao_opt	*ao_optcur;		/* current option */
	int		ao_tailc;		/* tail argc */
	char		**ao_tailv;		/* tail argv */
};

typedef struct ao_desc	OPT;

struct ao_opt {
	char		*aoo_string;		/* option string */
	int		aoo_flags;		/* option flags */
#define AOINT		0x001			/* integer parameters */
#define AOMUST		0x002			/* must be taken */
#define AODOARGS	0x004			/* do_args back. comp. */
#define AOTAKEN		0x100			/* option taken */
	int		aoo_nmaxparam;		/* max. # parameters */
	int		aoo_ninst;		/* # instances taken */
	struct ao_inst	*aoo_insts;		/* instances array */
	struct ao_opt	*aoo_mutex;		/* mutex options list */
	struct ao_opt	*aoo_next;		/* next option */
};

struct ao_inst {
	int		aoi_nparam;		/* # parameters */
	void		*aoi_params;		/* parameters array */
};

#ifdef __cplusplus
extern "C" {
#endif

extern OPT		*ao_init __ARGS((void));
extern int		ao_intparam __ARGS((OPT *aod, char *opt,
					    int inst, int idx, int *iparam));
extern int		ao_ninsts __ARGS((OPT *aod, char *opt));
extern int		ao_nparams __ARGS((OPT *aod,
					   char *opt, int inst));
extern int		ao_ntaken __ARGS((OPT *aod));
extern int		ao_parse __ARGS((OPT *aod, int *argc, char **argv));
extern int		ao_setopt __ARGS((OPT *aod, char *opt,
					  char *mutex, int np, int flags));
extern int		ao_setopt1 __ARGS((OPT *aod, char *opt,
					   char *mutex, int np, int flags));
extern int		ao_tail __ARGS((OPT *aod, int *tailc, char ***tailv));
extern int		ao_taken __ARGS((OPT *aod, char *opt));
extern char		*ao_chosen __ARGS((OPT *aod, char *opt));
extern char		*ao_param __ARGS((OPT *aod, char *opt, int inst, 
					  int idx));
extern void		ao_free __ARGS((OPT *aod));

#ifdef __cplusplus
}
#endif

#endif	/* _ALLOPT */
