/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	$Id: all_list.h,v 6.4 1999/04/01 21:38:45 kmeyer1 Exp $
 * 
 *	Function:	- constants and templates associated with all_list
 */

#ifndef _ALLLIST
#define _ALLLIST

#include "lam.h"

/*
 * templates
 */
struct al_head {
	struct al_head	*al_next;		/* next list element */
	struct al_head	*al_prev;		/* previous list element */
};

struct al_desc {
	int4		al_elemsize;		/* element size */
	int4		al_nelem;		/* # of elements */
	struct al_head	*al_ltop;		/* top of list ptr */
	struct al_head	*al_lbottom;		/* bottom of list ptr */
	struct al_head	*al_ftop;		/* top of free list ptr */
	int4		(*al_comp)();		/* comparison function */
};

typedef struct al_desc	LIST;

#define al_body(x) ((x) ? (((char *) (x)) + sizeof(struct al_head)) : 0)

#define al_count(x) ((x) ? (x)->al_nelem : 0)
#define al_top(x) ((al_count(x) > 0) ? (void *) al_body((x)->al_ltop) : 0)
#define al_bottom(x) ((al_count(x) > 0) ? (void *) al_body((x)->al_lbottom) : 0)

#ifdef __cplusplus
extern "C" {
#endif

extern LIST		*al_init __ARGS((int4 elemsize, int4 (*comp)()));
extern void		*al_append __ARGS((LIST *ald, void *unew));
extern void		*al_find __ARGS((LIST *ald, void *key));
extern void		*al_insert __ARGS((LIST *ald, void *unew));
extern void		*al_next __ARGS((LIST *ald, void *old));
extern void		*al_prev __ARGS((LIST *ald, void *old));
extern int4		al_delete __ARGS((LIST *ald, void *old));
extern int4		al_free __ARGS((LIST *ald));

#ifdef __cplusplus
}
#endif

#endif
