/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	$Id: MPISYSF.h,v 6.7 2001/03/20 06:14:31 jsquyres Exp $
 *
 *	Function:	- F77 wrappers for MPI library
 */

#ifndef _MPISYS_F77_H
#define _MPISYS_F77_H

#include <lam_config.h>
#include <mpi.h>

/*
 * macros
 */
#define GETHDL(x)		(((x) >= 0) ? lam_F_handles[(x)] : 0)
#define BUF(x)			(((x) == lam_F_bottom) ? (char *) 0 : (x))


#if LAM_FORTRANNOUNDERSCORE

/*
 * single underscore convention
 */

#ifdef LAM_PROFILELIB

#define mpi_abort_			pmpi_abort
#define mpi_accumulate_			pmpi_accumulate
#define mpi_address_			pmpi_address
#define mpi_allgather_			pmpi_allgather
#define mpi_allgatherv_			pmpi_allgatherv
#define mpi_alloc_mem_			pmpi_alloc_mem
#define mpi_allreduce_			pmpi_allreduce
#define mpi_alltoall_			pmpi_alltoall
#define mpi_alltoallv_			pmpi_alltoallv
#define mpi_attr_delete_		pmpi_attr_delete
#define mpi_attr_get_			pmpi_attr_get
#define mpi_attr_put_			pmpi_attr_put
#define mpi_barrier_			pmpi_barrier
#define mpi_bcast_			pmpi_bcast
#define mpi_bsend_			pmpi_bsend
#define mpi_bsend_init_			pmpi_bsend_init
#define mpi_buffer_attach_		pmpi_buffer_attach
#define mpi_buffer_detach_		pmpi_buffer_detach
#define mpi_cancel_			pmpi_cancel
#define mpi_cart_coords_		pmpi_cart_coords
#define mpi_cart_create_		pmpi_cart_create
#define mpi_cart_get_			pmpi_cart_get
#define mpi_cart_map_			pmpi_cart_map
#define mpi_cart_rank_			pmpi_cart_rank
#define mpi_cart_shift_			pmpi_cart_shift
#define mpi_cart_sub_			pmpi_cart_sub
#define mpi_cartdim_get_		pmpi_cartdim_get
#define mpi_close_port_			pmpi_close_port
#define mpi_comm_accept_		pmpi_comm_accept
#define mpi_comm_compare_		pmpi_comm_compare
#define mpi_comm_connect_		pmpi_comm_connect
#define mpi_comm_create_		pmpi_comm_create
#define mpi_comm_create_errhandler_	pmpi_comm_create_errhandler
#define mpi_comm_create_keyval_		pmpi_comm_create_keyval
#define mpi_comm_delete_attr_		pmpi_comm_delete_attr
#define mpi_comm_disconnect_		pmpi_comm_disconnect
#define mpi_comm_dup_			pmpi_comm_dup
#define mpi_comm_free_			pmpi_comm_free
#define mpi_comm_free_keyval_		pmpi_comm_free_keyval
#define mpi_comm_get_attr_		pmpi_comm_get_attr
#define mpi_comm_get_errhandler_	pmpi_comm_get_errhandler
#define mpi_comm_get_name_		pmpi_comm_get_name
#define mpi_comm_get_parent_		pmpi_comm_get_parent
#define mpi_comm_group_			pmpi_comm_group
#define mpi_comm_join_			pmpi_comm_join
#define mpi_comm_rank_			pmpi_comm_rank
#define mpi_comm_remote_group_		pmpi_comm_remote_group
#define mpi_comm_remote_size_		pmpi_comm_remote_size
#define mpi_comm_set_attr_		pmpi_comm_set_attr
#define mpi_comm_set_errhandler_	pmpi_comm_set_errhandler
#define mpi_comm_set_name_		pmpi_comm_set_name
#define mpi_comm_size_			pmpi_comm_size
#define mpi_comm_spawn_			pmpi_comm_spawn
#define mpi_comm_spawn_multiple_	pmpi_comm_spawn_multiple
#define mpi_comm_split_			pmpi_comm_split
#define mpi_comm_test_inter_		pmpi_comm_test_inter
#define mpi_dims_create_		pmpi_dims_create
#define mpi_errhandler_f2c_             pmpi_errhandler_f2c
#define mpi_errhandler_create_		pmpi_errhandler_create
#define mpi_errhandler_c2f_             pmpi_errhandler_c2f
#define mpi_errhandler_free_		pmpi_errhandler_free
#define mpi_errhandler_get_		pmpi_errhandler_get
#define mpi_errhandler_set_		pmpi_errhandler_set
#define mpi_error_class_		pmpi_error_class
#define mpi_error_string_		pmpi_error_string
#define mpi_free_mem_			pmpi_free_mem
#define mpi_finalize_			pmpi_finalize
#define mpi_finalized_			pmpi_finalized
#define mpi_gather_			pmpi_gather
#define mpi_gatherv_			pmpi_gatherv
#define mpi_get_			pmpi_get
#define mpi_get_address_		pmpi_get_address
#define mpi_get_count_			pmpi_get_count
#define mpi_get_elements_		pmpi_get_elements
#define mpi_get_processor_name_		pmpi_get_processor_name
#define mpi_get_version_		pmpi_get_version
#define mpi_graph_create_		pmpi_graph_create
#define mpi_graph_get_			pmpi_graph_get
#define mpi_graph_map_			pmpi_graph_map
#define mpi_graph_neighbors_		pmpi_graph_neighbors
#define mpi_graph_neighbors_count_	pmpi_graph_neighbors_count
#define mpi_graphdims_get_		pmpi_graphdims_get
#define mpi_group_compare_		pmpi_group_compare
#define mpi_group_difference_		pmpi_group_difference
#define mpi_group_excl_			pmpi_group_excl
#define mpi_group_free_			pmpi_group_free
#define mpi_group_incl_			pmpi_group_incl
#define mpi_group_intersection_		pmpi_group_intersection
#define mpi_group_range_excl_		pmpi_group_range_excl
#define mpi_group_range_incl_		pmpi_group_range_incl
#define mpi_group_rank_			pmpi_group_rank
#define mpi_group_size_			pmpi_group_size
#define mpi_group_translate_ranks_	pmpi_group_translate_ranks
#define mpi_group_union_		pmpi_group_union
#define mpi_ibsend_			pmpi_ibsend
#define mpi_info_create_		pmpi_info_create
#define mpi_info_delete_		pmpi_info_delete
#define mpi_info_dup_			pmpi_info_dup
#define mpi_info_free_			pmpi_info_free
#define mpi_info_get_			pmpi_info_get
#define mpi_info_get_nkeys_		pmpi_info_get_nkeys
#define mpi_info_get_nthkey_		pmpi_info_get_nthkey
#define mpi_info_get_valuelen_		pmpi_info_get_valuelen
#define mpi_info_set_			pmpi_info_set
#define mpi_init_			pmpi_init
#define mpi_init_thread_		pmpi_init_thread
#define mpi_initialized_		pmpi_initialized
#define mpi_intercomm_create_		pmpi_intercomm_create
#define mpi_intercomm_merge_		pmpi_intercomm_merge
#define mpi_iprobe_			pmpi_iprobe
#define mpi_irecv_			pmpi_irecv
#define mpi_irsend_			pmpi_irsend
#define mpi_is_thread_main_		pmpi_is_thread_main
#define mpi_isend_			pmpi_isend
#define mpi_issend_			pmpi_issend
#define mpi_keyval_create_		pmpi_keyval_create
#define mpi_keyval_free_		pmpi_keyval_free
#define mpi_lookup_name_		pmpi_lookup_name
#define mpi_op_create_			pmpi_op_create
#define mpi_op_free_			pmpi_op_free
#define mpi_open_port_			pmpi_open_port
#define mpi_pack_			pmpi_pack
#define mpi_pack_size_			pmpi_pack_size
#define mpi_pcontrol_			pmpi_pcontrol
#define mpi_probe_			pmpi_probe
#define mpi_publish_name_		pmpi_publish_name
#define mpi_put_			pmpi_put
#define mpi_query_thread_		pmpi_query_thread
#define mpi_recv_			pmpi_recv
#define mpi_recv_init_			pmpi_recv_init
#define mpi_reduce_			pmpi_reduce
#define mpi_reduce_scatter_		pmpi_reduce_scatter
#define mpi_request_free_		pmpi_request_free
#define mpi_rsend_			pmpi_rsend
#define mpi_rsend_init_			pmpi_rsend_init
#define mpi_scan_			pmpi_scan
#define mpi_scatter_			pmpi_scatter
#define mpi_scatterv_			pmpi_scatterv
#define mpi_send_			pmpi_send
#define mpi_send_init_			pmpi_send_init
#define mpi_sendrecv_			pmpi_sendrecv
#define mpi_sendrecv_replace_		pmpi_sendrecv_replace
#define mpi_ssend_			pmpi_ssend
#define mpi_ssend_init_			pmpi_ssend_init
#define mpi_start_			pmpi_start
#define mpi_startall_			pmpi_startall
#define mpi_test_			pmpi_test
#define mpi_test_cancelled_		pmpi_test_cancelled
#define mpi_testall_			pmpi_testall
#define mpi_testany_			pmpi_testany
#define mpi_testsome_			pmpi_testsome
#define mpi_topo_test_			pmpi_topo_test
#define mpi_type_commit_		pmpi_type_commit
#define mpi_type_contiguous_		pmpi_type_contiguous
#define mpi_type_count_			pmpi_type_count
#define mpi_type_create_darray_		pmpi_type_create_darray
#define mpi_type_create_hindexed_	pmpi_type_create_hindexed
#define mpi_type_create_hvector_	pmpi_type_create_hvector
#define mpi_type_create_keyval_		pmpi_type_create_keyval
#define mpi_type_create_resized_	pmpi_type_create_resized
#define mpi_type_create_struct_		pmpi_type_create_struct
#define mpi_type_create_subarray_	pmpi_type_create_subarray
#define mpi_type_delete_attr_		pmpi_type_delete_attr
#define mpi_type_dup_			pmpi_type_dup
#define mpi_type_extent_		pmpi_type_extent
#define mpi_type_free_			pmpi_type_free
#define mpi_type_free_keyval_		pmpi_type_free_keyval
#define mpi_type_get_attr_		pmpi_type_get_attr
#define mpi_type_get_contents_		pmpi_type_get_contents
#define mpi_type_get_envelope_		pmpi_type_get_envelope
#define mpi_type_get_extent_		pmpi_type_get_extent
#define mpi_type_get_name_		pmpi_type_get_name
#define mpi_type_get_true_extent_	pmpi_type_get_true_extent
#define mpi_type_hindexed_		pmpi_type_hindexed
#define mpi_type_hvector_		pmpi_type_hvector
#define mpi_type_indexed_		pmpi_type_indexed
#define mpi_type_lb_			pmpi_type_lb
#define mpi_type_set_attr_		pmpi_type_set_attr
#define mpi_type_set_name_		pmpi_type_set_name
#define mpi_type_size_			pmpi_type_size
#define mpi_type_struct_		pmpi_type_struct
#define mpi_type_ub_			pmpi_type_ub
#define mpi_type_vector_		pmpi_type_vector
#define mpi_unpack_			pmpi_unpack
#define mpi_unpublish_name_		pmpi_unpublish_name
#define mpi_wait_			pmpi_wait
#define mpi_waitall_			pmpi_waitall
#define mpi_waitany_			pmpi_waitany
#define mpi_waitsome_			pmpi_waitsome
#define mpi_win_complete_		pmpi_win_complete
#define mpi_win_create_			pmpi_win_create
#define mpi_win_create_errhandler_	pmpi_win_create_errhandler
#define mpi_win_create_keyval_		pmpi_win_create_keyval
#define mpi_win_delete_attr_		pmpi_win_delete_attr
#define mpi_win_fence_			pmpi_win_fence
#define mpi_win_free_			pmpi_win_free
#define mpi_win_free_keyval_		pmpi_win_free_keyval
#define mpi_win_get_attr_		pmpi_win_get_attr
#define mpi_win_get_errhandler_		pmpi_win_get_errhandler
#define mpi_win_get_group_		pmpi_win_get_group
#define mpi_win_get_name_		pmpi_win_get_name
#define mpi_win_post_			pmpi_win_post
#define mpi_win_set_attr_		pmpi_win_set_attr
#define mpi_win_set_errhandler_		pmpi_win_set_errhandler
#define mpi_win_set_name_		pmpi_win_set_name
#define mpi_win_start_			pmpi_win_start
#define mpi_win_wait_			pmpi_win_wait
#define mpi_wtick_			pmpi_wtick
#define mpi_wtime_			pmpi_wtime

#define mpil_comm_gps_			pmpil_comm_gps
#define mpil_comm_id_			pmpil_comm_id
#define mpil_comm_parent_		pmpil_comm_parent
#define mpil_signal_			pmpil_signal
#define mpil_spawn_			pmpil_spawn
#define mpil_type_id_			pmpil_type_id

#else  /* not LAM_PROFILELIB */

#define mpi_abort_			mpi_abort
#define mpi_accumulate_			mpi_accumulate
#define mpi_address_			mpi_address
#define mpi_allgather_			mpi_allgather
#define mpi_allgatherv_			mpi_allgatherv
#define mpi_alloc_mem_			mpi_alloc_mem
#define mpi_allreduce_			mpi_allreduce
#define mpi_alltoall_			mpi_alltoall
#define mpi_alltoallv_			mpi_alltoallv
#define mpi_attr_delete_		mpi_attr_delete
#define mpi_attr_get_			mpi_attr_get
#define mpi_attr_put_			mpi_attr_put
#define mpi_barrier_			mpi_barrier
#define mpi_bcast_			mpi_bcast
#define mpi_bsend_			mpi_bsend
#define mpi_bsend_init_			mpi_bsend_init
#define mpi_buffer_attach_		mpi_buffer_attach
#define mpi_buffer_detach_		mpi_buffer_detach
#define mpi_cancel_			mpi_cancel
#define mpi_cart_coords_		mpi_cart_coords
#define mpi_cart_create_		mpi_cart_create
#define mpi_cart_get_			mpi_cart_get
#define mpi_cart_map_			mpi_cart_map
#define mpi_cart_rank_			mpi_cart_rank
#define mpi_cart_shift_			mpi_cart_shift
#define mpi_cart_sub_			mpi_cart_sub
#define mpi_cartdim_get_		mpi_cartdim_get
#define mpi_close_port_			mpi_close_port
#define mpi_comm_accept_		mpi_comm_accept
#define mpi_comm_compare_		mpi_comm_compare
#define mpi_comm_connect_		mpi_comm_connect
#define mpi_comm_create_		mpi_comm_create
#define mpi_comm_create_errhandler_	mpi_comm_create_errhandler
#define mpi_comm_create_keyval_		mpi_comm_create_keyval
#define mpi_comm_delete_attr_		mpi_comm_delete_attr
#define mpi_comm_disconnect_		mpi_comm_disconnect
#define mpi_comm_dup_			mpi_comm_dup
#define mpi_comm_free_			mpi_comm_free
#define mpi_comm_free_keyval_		mpi_comm_free_keyval
#define mpi_comm_get_attr_		mpi_comm_get_attr
#define mpi_comm_get_errhandler_	mpi_comm_get_errhandler
#define mpi_comm_get_name_		mpi_comm_get_name
#define mpi_comm_get_parent_		mpi_comm_get_parent
#define mpi_comm_group_			mpi_comm_group
#define mpi_comm_join_			mpi_comm_join
#define mpi_comm_rank_			mpi_comm_rank
#define mpi_comm_remote_group_		mpi_comm_remote_group
#define mpi_comm_remote_size_		mpi_comm_remote_size
#define mpi_comm_set_attr_		mpi_comm_set_attr
#define mpi_comm_set_errhandler_	mpi_comm_set_errhandler
#define mpi_comm_set_name_		mpi_comm_set_name
#define mpi_comm_size_			mpi_comm_size
#define mpi_comm_spawn_			mpi_comm_spawn
#define mpi_comm_spawn_multiple_	mpi_comm_spawn_multiple
#define mpi_comm_split_			mpi_comm_split
#define mpi_comm_test_inter_		mpi_comm_test_inter
#define mpi_dims_create_		mpi_dims_create
#define mpi_errhandler_f2c_             mpi_errhandler_f2c
#define mpi_errhandler_create_		mpi_errhandler_create
#define mpi_errhandler_c2f_             mpi_errhandler_c2f
#define mpi_errhandler_free_		mpi_errhandler_free
#define mpi_errhandler_get_		mpi_errhandler_get
#define mpi_errhandler_set_		mpi_errhandler_set
#define mpi_error_class_		mpi_error_class
#define mpi_error_string_		mpi_error_string
#define mpi_free_mem_			mpi_free_mem
#define mpi_finalize_			mpi_finalize
#define mpi_finalized_			mpi_finalized
#define mpi_gather_			mpi_gather
#define mpi_gatherv_			mpi_gatherv
#define mpi_get_			mpi_get
#define mpi_get_address_		mpi_get_address
#define mpi_get_count_			mpi_get_count
#define mpi_get_elements_		mpi_get_elements
#define mpi_get_processor_name_		mpi_get_processor_name
#define mpi_get_version_		mpi_get_version
#define mpi_graph_create_		mpi_graph_create
#define mpi_graph_get_			mpi_graph_get
#define mpi_graph_map_			mpi_graph_map
#define mpi_graph_neighbors_		mpi_graph_neighbors
#define mpi_graph_neighbors_count_	mpi_graph_neighbors_count
#define mpi_graphdims_get_		mpi_graphdims_get
#define mpi_group_compare_		mpi_group_compare
#define mpi_group_difference_		mpi_group_difference
#define mpi_group_excl_			mpi_group_excl
#define mpi_group_free_			mpi_group_free
#define mpi_group_incl_			mpi_group_incl
#define mpi_group_intersection_		mpi_group_intersection
#define mpi_group_range_excl_		mpi_group_range_excl
#define mpi_group_range_incl_		mpi_group_range_incl
#define mpi_group_rank_			mpi_group_rank
#define mpi_group_size_			mpi_group_size
#define mpi_group_translate_ranks_	mpi_group_translate_ranks
#define mpi_group_union_		mpi_group_union
#define mpi_ibsend_			mpi_ibsend
#define mpi_info_create_		mpi_info_create
#define mpi_info_delete_		mpi_info_delete
#define mpi_info_dup_			mpi_info_dup
#define mpi_info_free_			mpi_info_free
#define mpi_info_get_			mpi_info_get
#define mpi_info_get_nkeys_		mpi_info_get_nkeys
#define mpi_info_get_nthkey_		mpi_info_get_nthkey
#define mpi_info_get_valuelen_		mpi_info_get_valuelen
#define mpi_info_set_			mpi_info_set
#define mpi_init_			mpi_init
#define mpi_init_thread_		mpi_init_thread
#define mpi_initialized_		mpi_initialized
#define mpi_intercomm_create_		mpi_intercomm_create
#define mpi_intercomm_merge_		mpi_intercomm_merge
#define mpi_iprobe_			mpi_iprobe
#define mpi_irecv_			mpi_irecv
#define mpi_irsend_			mpi_irsend
#define mpi_is_thread_main_		mpi_is_thread_main
#define mpi_isend_			mpi_isend
#define mpi_issend_			mpi_issend
#define mpi_keyval_create_		mpi_keyval_create
#define mpi_keyval_free_		mpi_keyval_free
#define mpi_lookup_name_		mpi_lookup_name
#define mpi_op_create_			mpi_op_create
#define mpi_op_free_			mpi_op_free
#define mpi_open_port_			mpi_open_port
#define mpi_pack_			mpi_pack
#define mpi_pack_size_			mpi_pack_size
#define mpi_pcontrol_			mpi_pcontrol
#define mpi_probe_			mpi_probe
#define mpi_publish_name_		mpi_publish_name
#define mpi_put_			mpi_put
#define mpi_query_thread_		mpi_query_thread
#define mpi_recv_			mpi_recv
#define mpi_recv_init_			mpi_recv_init
#define mpi_reduce_			mpi_reduce
#define mpi_reduce_scatter_		mpi_reduce_scatter
#define mpi_request_free_		mpi_request_free
#define mpi_rsend_			mpi_rsend
#define mpi_rsend_init_			mpi_rsend_init
#define mpi_scan_			mpi_scan
#define mpi_scatter_			mpi_scatter
#define mpi_scatterv_			mpi_scatterv
#define mpi_send_			mpi_send
#define mpi_send_init_			mpi_send_init
#define mpi_sendrecv_			mpi_sendrecv
#define mpi_sendrecv_replace_		mpi_sendrecv_replace
#define mpi_ssend_			mpi_ssend
#define mpi_ssend_init_			mpi_ssend_init
#define mpi_start_			mpi_start
#define mpi_startall_			mpi_startall
#define mpi_test_			mpi_test
#define mpi_test_cancelled_		mpi_test_cancelled
#define mpi_testall_			mpi_testall
#define mpi_testany_			mpi_testany
#define mpi_testsome_			mpi_testsome
#define mpi_topo_test_			mpi_topo_test
#define mpi_type_commit_		mpi_type_commit
#define mpi_type_contiguous_		mpi_type_contiguous
#define mpi_type_count_			mpi_type_count
#define mpi_type_create_darray_		mpi_type_create_darray
#define mpi_type_create_hindexed_	mpi_type_create_hindexed
#define mpi_type_create_hvector_	mpi_type_create_hvector
#define mpi_type_create_keyval_		mpi_type_create_keyval
#define mpi_type_create_resized_	mpi_type_create_resized
#define mpi_type_create_struct_		mpi_type_create_struct
#define mpi_type_create_subarray_	mpi_type_create_subarray
#define mpi_type_delete_attr_		mpi_type_delete_attr
#define mpi_type_dup_			mpi_type_dup
#define mpi_type_extent_		mpi_type_extent
#define mpi_type_free_			mpi_type_free
#define mpi_type_free_keyval_		mpi_type_free_keyval
#define mpi_type_get_attr_		mpi_type_get_attr
#define mpi_type_get_contents_		mpi_type_get_contents
#define mpi_type_get_envelope_		mpi_type_get_envelope
#define mpi_type_get_extent_		mpi_type_get_extent
#define mpi_type_get_name_		mpi_type_get_name
#define mpi_type_get_true_extent_	mpi_type_get_true_extent
#define mpi_type_hindexed_		mpi_type_hindexed
#define mpi_type_hvector_		mpi_type_hvector
#define mpi_type_indexed_		mpi_type_indexed
#define mpi_type_lb_			mpi_type_lb
#define mpi_type_set_attr_		mpi_type_set_attr
#define mpi_type_set_name_		mpi_type_set_name
#define mpi_type_size_			mpi_type_size
#define mpi_type_struct_		mpi_type_struct
#define mpi_type_ub_			mpi_type_ub
#define mpi_type_vector_		mpi_type_vector
#define mpi_unpack_			mpi_unpack
#define mpi_unpublish_name_		mpi_unpublish_name
#define mpi_wait_			mpi_wait
#define mpi_waitall_			mpi_waitall
#define mpi_waitany_			mpi_waitany
#define mpi_waitsome_			mpi_waitsome
#define mpi_win_complete_		mpi_win_complete
#define mpi_win_create_			mpi_win_create
#define mpi_win_create_errhandler_	mpi_win_create_errhandler
#define mpi_win_create_keyval_		mpi_win_create_keyval
#define mpi_win_delete_attr_		mpi_win_delete_attr
#define mpi_win_fence_			mpi_win_fence
#define mpi_win_free_			mpi_win_free
#define mpi_win_free_keyval_		mpi_win_free_keyval
#define mpi_win_get_attr_		mpi_win_get_attr
#define mpi_win_get_errhandler_		mpi_win_get_errhandler
#define mpi_win_get_group_		mpi_win_get_group
#define mpi_win_get_name_		mpi_win_get_name
#define mpi_win_post_			mpi_win_post
#define mpi_win_set_attr_		mpi_win_set_attr
#define mpi_win_set_errhandler_		mpi_win_set_errhandler
#define mpi_win_set_name_		mpi_win_set_name
#define mpi_win_start_			mpi_win_start
#define mpi_win_wait_			mpi_win_wait
#define mpi_wtick_			mpi_wtick
#define mpi_wtime_			mpi_wtime

#define mpil_comm_gps_			mpil_comm_gps
#define mpil_comm_id_			mpil_comm_id
#define mpil_comm_parent_		mpil_comm_parent
#define mpil_signal_			mpil_signal
#define mpil_spawn_			mpil_spawn
#define mpil_type_id_			mpil_type_id

#endif /* not LAM_PROFILELIB */

#define mpi_dup_fn_			mpi_dup_fn
#define mpi_comm_dup_fn_		mpi_comm_dup_fn
#define mpi_type_dup_fn_		mpi_type_dup_fn
#define mpi_win_dup_fn_			mpi_win_dup_fn
#define mpi_null_copy_fn_		mpi_null_copy_fn
#define mpi_null_delete_fn_		mpi_null_delete_fn
#define mpi_comm_null_copy_fn_		mpi_comm_null_copy_fn
#define mpi_comm_null_delete_fn_	mpi_comm_null_delete_fn
#define mpi_type_null_copy_fn_		mpi_type_null_copy_fn
#define mpi_type_null_delete_fn_	mpi_type_null_delete_fn
#define mpi_win_null_copy_fn_		mpi_win_null_copy_fn
#define mpi_win_null_delete_fn_		mpi_win_null_delete_fn

#define mpi_bottom_			mpi_bottom
#define mpi_argv_null_			mpi_argv_null
#define mpi_argvs_null_			mpi_argvs_null
#define mpi_errcodes_ignore_		mpi_errcodes_ignore
#define mpi_status_ignore_		mpi_status_ignore
#define mpi_statuses_ignore_		mpi_statuses_ignore

#define xmpi_buoy_			xmpi_buoy
#define xmpi_coloron_			xmpi_coloron
#define xmpi_coloroff_			xmpi_coloroff

#elif LAM_FORTRANDOUBLEUNDERSCORE

/*
 * double underscore convention
 */

#ifdef LAM_PROFILELIB

#define mpi_abort_			pmpi_abort__
#define mpi_accumulate_			pmpi_accumulate__
#define mpi_address_			pmpi_address__
#define mpi_allgather_			pmpi_allgather__
#define mpi_allgatherv_			pmpi_allgatherv__
#define mpi_alloc_mem_			pmpi_alloc_mem__
#define mpi_allreduce_			pmpi_allreduce__
#define mpi_alltoall_			pmpi_alltoall__
#define mpi_alltoallv_			pmpi_alltoallv__
#define mpi_attr_delete_		pmpi_attr_delete__
#define mpi_attr_get_			pmpi_attr_get__
#define mpi_attr_put_			pmpi_attr_put__
#define mpi_barrier_			pmpi_barrier__
#define mpi_bcast_			pmpi_bcast__
#define mpi_bsend_			pmpi_bsend__
#define mpi_bsend_init_			pmpi_bsend_init__
#define mpi_buffer_attach_		pmpi_buffer_attach__
#define mpi_buffer_detach_		pmpi_buffer_detach__
#define mpi_cancel_			pmpi_cancel__
#define mpi_cart_coords_		pmpi_cart_coords__
#define mpi_cart_create_		pmpi_cart_create__
#define mpi_cart_get_			pmpi_cart_get__
#define mpi_cart_map_			pmpi_cart_map__
#define mpi_cart_rank_			pmpi_cart_rank__
#define mpi_cart_shift_			pmpi_cart_shift__
#define mpi_cart_sub_			pmpi_cart_sub__
#define mpi_cartdim_get_		pmpi_cartdim_get__
#define mpi_close_port_			pmpi_close_port__
#define mpi_comm_accept_		pmpi_comm_accept__
#define mpi_comm_compare_		pmpi_comm_compare__
#define mpi_comm_connect_		pmpi_comm_connect__
#define mpi_comm_create_		pmpi_comm_create__
#define mpi_comm_create_errhandler_	pmpi_comm_create_errhandler__
#define mpi_comm_create_keyval_		pmpi_comm_create_keyval__
#define mpi_comm_delete_attr_		pmpi_comm_delete_attr__
#define mpi_comm_disconnect_		pmpi_comm_disconnect__
#define mpi_comm_dup_			pmpi_comm_dup__
#define mpi_comm_free_			pmpi_comm_free__
#define mpi_comm_free_keyval_		pmpi_comm_free_keyval__
#define mpi_comm_get_attr_		pmpi_comm_get_attr__
#define mpi_comm_get_errhandler_	pmpi_comm_get_errhandler__
#define mpi_comm_get_name_		pmpi_comm_get_name__
#define mpi_comm_get_parent_		pmpi_comm_get_parent__
#define mpi_comm_group_			pmpi_comm_group__
#define mpi_comm_join_			pmpi_comm_join__
#define mpi_comm_rank_			pmpi_comm_rank__
#define mpi_comm_remote_group_		pmpi_comm_remote_group__
#define mpi_comm_remote_size_		pmpi_comm_remote_size__
#define mpi_comm_set_attr_		pmpi_comm_set_attr__
#define mpi_comm_set_errhandler_	pmpi_comm_set_errhandler__
#define mpi_comm_set_name_		pmpi_comm_set_name__
#define mpi_comm_size_			pmpi_comm_size__
#define mpi_comm_spawn_			pmpi_comm_spawn__
#define mpi_comm_spawn_multiple_	pmpi_comm_spawn_multiple__
#define mpi_comm_split_			pmpi_comm_split__
#define mpi_comm_test_inter_		pmpi_comm_test_inter__
#define mpi_dims_create_		pmpi_dims_create__
#define mpi_errhandler_f2c_             pmpi_errhandler_f2c__
#define mpi_errhandler_create_		pmpi_errhandler_create__
#define mpi_errhandler_c2f_             pmpi_errhandler_c2f__
#define mpi_errhandler_free_		pmpi_errhandler_free__
#define mpi_errhandler_get_		pmpi_errhandler_get__
#define mpi_errhandler_set_		pmpi_errhandler_set__
#define mpi_error_class_		pmpi_error_class__
#define mpi_error_string_		pmpi_error_string__
#define mpi_free_mem_			pmpi_free_mem__
#define mpi_finalize_			pmpi_finalize__
#define mpi_finalized_			pmpi_finalized__
#define mpi_gather_			pmpi_gather__
#define mpi_gatherv_			pmpi_gatherv__
#define mpi_get_			pmpi_get__
#define mpi_get_address_		pmpi_get_address__
#define mpi_get_count_			pmpi_get_count__
#define mpi_get_elements_		pmpi_get_elements__
#define mpi_get_processor_name_		pmpi_get_processor_name__
#define mpi_get_version_		pmpi_get_version__
#define mpi_graph_create_		pmpi_graph_create__
#define mpi_graph_get_			pmpi_graph_get__
#define mpi_graph_map_			pmpi_graph_map__
#define mpi_graph_neighbors_		pmpi_graph_neighbors__
#define mpi_graph_neighbors_count_	pmpi_graph_neighbors_count__
#define mpi_graphdims_get_		pmpi_graphdims_get__
#define mpi_group_compare_		pmpi_group_compare__
#define mpi_group_difference_		pmpi_group_difference__
#define mpi_group_excl_			pmpi_group_excl__
#define mpi_group_free_			pmpi_group_free__
#define mpi_group_incl_			pmpi_group_incl__
#define mpi_group_intersection_		pmpi_group_intersection__
#define mpi_group_range_excl_		pmpi_group_range_excl__
#define mpi_group_range_incl_		pmpi_group_range_incl__
#define mpi_group_rank_			pmpi_group_rank__
#define mpi_group_size_			pmpi_group_size__
#define mpi_group_translate_ranks_	pmpi_group_translate_ranks__
#define mpi_group_union_		pmpi_group_union__
#define mpi_ibsend_			pmpi_ibsend__
#define mpi_info_create_		pmpi_info_create__
#define mpi_info_delete_		pmpi_info_delete__
#define mpi_info_dup_			pmpi_info_dup__
#define mpi_info_free_			pmpi_info_free__
#define mpi_info_get_			pmpi_info_get__
#define mpi_info_get_nkeys_		pmpi_info_get_nkeys__
#define mpi_info_get_nthkey_		pmpi_info_get_nthkey__
#define mpi_info_get_valuelen_		pmpi_info_get_valuelen__
#define mpi_info_set_			pmpi_info_set__
#define mpi_init_			pmpi_init__
#define mpi_init_thread_		pmpi_init_thread__
#define mpi_initialized_		pmpi_initialized__
#define mpi_intercomm_create_		pmpi_intercomm_create__
#define mpi_intercomm_merge_		pmpi_intercomm_merge__
#define mpi_iprobe_			pmpi_iprobe__
#define mpi_irecv_			pmpi_irecv__
#define mpi_irsend_			pmpi_irsend__
#define mpi_is_thread_main_		pmpi_is_thread_main__
#define mpi_isend_			pmpi_isend__
#define mpi_issend_			pmpi_issend__
#define mpi_keyval_create_		pmpi_keyval_create__
#define mpi_keyval_free_		pmpi_keyval_free__
#define mpi_lookup_name_		pmpi_lookup_name__
#define mpi_op_create_			pmpi_op_create__
#define mpi_op_free_			pmpi_op_free__
#define mpi_open_port_			pmpi_open_port__
#define mpi_pack_			pmpi_pack__
#define mpi_pack_size_			pmpi_pack_size__
#define mpi_pcontrol_			pmpi_pcontrol__
#define mpi_probe_			pmpi_probe__
#define mpi_publish_name_		pmpi_publish_name__
#define mpi_put_			pmpi_put__
#define mpi_query_thread_		pmpi_query_thread__
#define mpi_recv_			pmpi_recv__
#define mpi_recv_init_			pmpi_recv_init__
#define mpi_reduce_			pmpi_reduce__
#define mpi_reduce_scatter_		pmpi_reduce_scatter__
#define mpi_request_free_		pmpi_request_free__
#define mpi_rsend_			pmpi_rsend__
#define mpi_rsend_init_			pmpi_rsend_init__
#define mpi_scan_			pmpi_scan__
#define mpi_scatter_			pmpi_scatter__
#define mpi_scatterv_			pmpi_scatterv__
#define mpi_send_			pmpi_send__
#define mpi_send_init_			pmpi_send_init__
#define mpi_sendrecv_			pmpi_sendrecv__
#define mpi_sendrecv_replace_		pmpi_sendrecv_replace__
#define mpi_ssend_			pmpi_ssend__
#define mpi_ssend_init_			pmpi_ssend_init__
#define mpi_start_			pmpi_start__
#define mpi_startall_			pmpi_startall__
#define mpi_test_			pmpi_test__
#define mpi_test_cancelled_		pmpi_test_cancelled__
#define mpi_testall_			pmpi_testall__
#define mpi_testany_			pmpi_testany__
#define mpi_testsome_			pmpi_testsome__
#define mpi_topo_test_			pmpi_topo_test__
#define mpi_type_commit_		pmpi_type_commit__
#define mpi_type_contiguous_		pmpi_type_contiguous__
#define mpi_type_count_			pmpi_type_count__
#define mpi_type_create_darray_		pmpi_type_create_darray__
#define mpi_type_create_hindexed_	pmpi_type_create_hindexed__
#define mpi_type_create_hvector_	pmpi_type_create_hvector__
#define mpi_type_create_keyval_		pmpi_type_create_keyval__
#define mpi_type_create_resized_	pmpi_type_create_resized__
#define mpi_type_create_struct_		pmpi_type_create_struct__
#define mpi_type_create_subarray_	pmpi_type_create_subarray__
#define mpi_type_delete_attr_		pmpi_type_delete_attr__
#define mpi_type_dup_			pmpi_type_dup__
#define mpi_type_extent_		pmpi_type_extent__
#define mpi_type_free_			pmpi_type_free__
#define mpi_type_free_keyval_		pmpi_type_free_keyval__
#define mpi_type_get_attr_		pmpi_type_get_attr__
#define mpi_type_get_contents_		pmpi_type_get_contents__
#define mpi_type_get_envelope_		pmpi_type_get_envelope__
#define mpi_type_get_extent_		pmpi_type_get_extent__
#define mpi_type_get_name_		pmpi_type_get_name__
#define mpi_type_get_true_extent_	pmpi_type_get_true_extent__
#define mpi_type_hindexed_		pmpi_type_hindexed__
#define mpi_type_hvector_		pmpi_type_hvector__
#define mpi_type_indexed_		pmpi_type_indexed__
#define mpi_type_lb_			pmpi_type_lb__
#define mpi_type_set_attr_		pmpi_type_set_attr__
#define mpi_type_set_name_		pmpi_type_set_name__
#define mpi_type_size_			pmpi_type_size__
#define mpi_type_struct_		pmpi_type_struct__
#define mpi_type_ub_			pmpi_type_ub__
#define mpi_type_vector_		pmpi_type_vector__
#define mpi_unpack_			pmpi_unpack__
#define mpi_unpublish_name_		pmpi_unpublish_name__
#define mpi_wait_			pmpi_wait__
#define mpi_waitall_			pmpi_waitall__
#define mpi_waitany_			pmpi_waitany__
#define mpi_waitsome_			pmpi_waitsome__
#define mpi_win_complete_		pmpi_win_complete__
#define mpi_win_create_			pmpi_win_create__
#define mpi_win_create_errhandler_	pmpi_win_create_errhandler__
#define mpi_win_create_keyval_		pmpi_win_create_keyval__
#define mpi_win_delete_attr_		pmpi_win_delete_attr__
#define mpi_win_fence_			pmpi_win_fence__
#define mpi_win_free_			pmpi_win_free__
#define mpi_win_free_keyval_		pmpi_win_free_keyval__
#define mpi_win_get_attr_		pmpi_win_get_attr__
#define mpi_win_get_errhandler_		pmpi_win_get_errhandler__
#define mpi_win_get_group_		pmpi_win_get_group__
#define mpi_win_get_name_		pmpi_win_get_name__
#define mpi_win_post_			pmpi_win_post__
#define mpi_win_set_attr_		pmpi_win_set_attr__
#define mpi_win_set_errhandler_		pmpi_win_set_errhandler__
#define mpi_win_set_name_		pmpi_win_set_name__
#define mpi_win_start_			pmpi_win_start__
#define mpi_win_wait_			pmpi_win_wait__
#define mpi_wtick_			pmpi_wtick__
#define mpi_wtime_			pmpi_wtime__

#define mpil_comm_gps_			pmpil_comm_gps__
#define mpil_comm_id_			pmpil_comm_id__
#define mpil_comm_parent_		pmpil_comm_parent__
#define mpil_signal_			pmpil_signal__
#define mpil_spawn_			pmpil_spawn__
#define mpil_type_id_			pmpil_type_id__

#else  /* not LAM_PROFILELIB */

#define mpi_abort_			mpi_abort__
#define mpi_accumulate_			mpi_accumulate__
#define mpi_address_			mpi_address__
#define mpi_allgather_			mpi_allgather__
#define mpi_allgatherv_			mpi_allgatherv__
#define mpi_alloc_mem_			mpi_alloc_mem__
#define mpi_allreduce_			mpi_allreduce__
#define mpi_alltoall_			mpi_alltoall__
#define mpi_alltoallv_			mpi_alltoallv__
#define mpi_attr_delete_		mpi_attr_delete__
#define mpi_attr_get_			mpi_attr_get__
#define mpi_attr_put_			mpi_attr_put__
#define mpi_barrier_			mpi_barrier__
#define mpi_bcast_			mpi_bcast__
#define mpi_bsend_			mpi_bsend__
#define mpi_bsend_init_			mpi_bsend_init__
#define mpi_buffer_attach_		mpi_buffer_attach__
#define mpi_buffer_detach_		mpi_buffer_detach__
#define mpi_cancel_			mpi_cancel__
#define mpi_cart_coords_		mpi_cart_coords__
#define mpi_cart_create_		mpi_cart_create__
#define mpi_cart_get_			mpi_cart_get__
#define mpi_cart_map_			mpi_cart_map__
#define mpi_cart_rank_			mpi_cart_rank__
#define mpi_cart_shift_			mpi_cart_shift__
#define mpi_cart_sub_			mpi_cart_sub__
#define mpi_cartdim_get_		mpi_cartdim_get__
#define mpi_close_port_			mpi_close_port__
#define mpi_comm_accept_		mpi_comm_accept__
#define mpi_comm_compare_		mpi_comm_compare__
#define mpi_comm_connect_		mpi_comm_connect__
#define mpi_comm_create_		mpi_comm_create__
#define mpi_comm_create_errhandler_	mpi_comm_create_errhandler__
#define mpi_comm_create_keyval_		mpi_comm_create_keyval__
#define mpi_comm_delete_attr_		mpi_comm_delete_attr__
#define mpi_comm_disconnect_		mpi_comm_disconnect__
#define mpi_comm_dup_			mpi_comm_dup__
#define mpi_comm_free_			mpi_comm_free__
#define mpi_comm_free_keyval_		mpi_comm_free_keyval__
#define mpi_comm_get_attr_		mpi_comm_get_attr__
#define mpi_comm_get_errhandler_	mpi_comm_get_errhandler__
#define mpi_comm_get_name_		mpi_comm_get_name__
#define mpi_comm_get_parent_		mpi_comm_get_parent__
#define mpi_comm_group_			mpi_comm_group__
#define mpi_comm_join_			mpi_comm_join__
#define mpi_comm_rank_			mpi_comm_rank__
#define mpi_comm_remote_group_		mpi_comm_remote_group__
#define mpi_comm_remote_size_		mpi_comm_remote_size__
#define mpi_comm_set_attr_		mpi_comm_set_attr__
#define mpi_comm_set_errhandler_	mpi_comm_set_errhandler__
#define mpi_comm_set_name_		mpi_comm_set_name__
#define mpi_comm_size_			mpi_comm_size__
#define mpi_comm_spawn_			mpi_comm_spawn__
#define mpi_comm_spawn_multiple_	mpi_comm_spawn_multiple__
#define mpi_comm_split_			mpi_comm_split__
#define mpi_comm_test_inter_		mpi_comm_test_inter__
#define mpi_dims_create_		mpi_dims_create__
#define mpi_errhandler_f2c_             mpi_errhandler_f2c__
#define mpi_errhandler_create_		mpi_errhandler_create__
#define mpi_errhandler_c2f_             mpi_errhandler_c2f__
#define mpi_errhandler_free_		mpi_errhandler_free__
#define mpi_errhandler_get_		mpi_errhandler_get__
#define mpi_errhandler_set_		mpi_errhandler_set__
#define mpi_error_class_		mpi_error_class__
#define mpi_error_string_		mpi_error_string__
#define mpi_free_mem_			mpi_free_mem__
#define mpi_finalize_			mpi_finalize__
#define mpi_finalized_			mpi_finalized__
#define mpi_gather_			mpi_gather__
#define mpi_gatherv_			mpi_gatherv__
#define mpi_get_			mpi_get__
#define mpi_get_address_		mpi_get_address__
#define mpi_get_count_			mpi_get_count__
#define mpi_get_elements_		mpi_get_elements__
#define mpi_get_processor_name_		mpi_get_processor_name__
#define mpi_get_version_		mpi_get_version__
#define mpi_graph_create_		mpi_graph_create__
#define mpi_graph_get_			mpi_graph_get__
#define mpi_graph_map_			mpi_graph_map__
#define mpi_graph_neighbors_		mpi_graph_neighbors__
#define mpi_graph_neighbors_count_	mpi_graph_neighbors_count__
#define mpi_graphdims_get_		mpi_graphdims_get__
#define mpi_group_compare_		mpi_group_compare__
#define mpi_group_difference_		mpi_group_difference__
#define mpi_group_excl_			mpi_group_excl__
#define mpi_group_free_			mpi_group_free__
#define mpi_group_incl_			mpi_group_incl__
#define mpi_group_intersection_		mpi_group_intersection__
#define mpi_group_range_excl_		mpi_group_range_excl__
#define mpi_group_range_incl_		mpi_group_range_incl__
#define mpi_group_rank_			mpi_group_rank__
#define mpi_group_size_			mpi_group_size__
#define mpi_group_translate_ranks_	mpi_group_translate_ranks__
#define mpi_group_union_		mpi_group_union__
#define mpi_ibsend_			mpi_ibsend__
#define mpi_info_create_		mpi_info_create__
#define mpi_info_delete_		mpi_info_delete__
#define mpi_info_dup_			mpi_info_dup__
#define mpi_info_free_			mpi_info_free__
#define mpi_info_get_			mpi_info_get__
#define mpi_info_get_nkeys_		mpi_info_get_nkeys__
#define mpi_info_get_nthkey_		mpi_info_get_nthkey__
#define mpi_info_get_valuelen_		mpi_info_get_valuelen__
#define mpi_info_set_			mpi_info_set__
#define mpi_init_			mpi_init__
#define mpi_init_thread_		mpi_init_thread__
#define mpi_initialized_		mpi_initialized__
#define mpi_intercomm_create_		mpi_intercomm_create__
#define mpi_intercomm_merge_		mpi_intercomm_merge__
#define mpi_iprobe_			mpi_iprobe__
#define mpi_irecv_			mpi_irecv__
#define mpi_irsend_			mpi_irsend__
#define mpi_is_thread_main_		mpi_is_thread_main__
#define mpi_isend_			mpi_isend__
#define mpi_issend_			mpi_issend__
#define mpi_keyval_create_		mpi_keyval_create__
#define mpi_keyval_free_		mpi_keyval_free__
#define mpi_lookup_name_		mpi_lookup_name__
#define mpi_op_create_			mpi_op_create__
#define mpi_op_free_			mpi_op_free__
#define mpi_open_port_			mpi_open_port__
#define mpi_pack_			mpi_pack__
#define mpi_pack_size_			mpi_pack_size__
#define mpi_pcontrol_			mpi_pcontrol__
#define mpi_probe_			mpi_probe__
#define mpi_publish_name_		mpi_publish_name__
#define mpi_put_			mpi_put__
#define mpi_query_thread_		mpi_query_thread__
#define mpi_recv_			mpi_recv__
#define mpi_recv_init_			mpi_recv_init__
#define mpi_reduce_			mpi_reduce__
#define mpi_reduce_scatter_		mpi_reduce_scatter__
#define mpi_request_free_		mpi_request_free__
#define mpi_rsend_			mpi_rsend__
#define mpi_rsend_init_			mpi_rsend_init__
#define mpi_scan_			mpi_scan__
#define mpi_scatter_			mpi_scatter__
#define mpi_scatterv_			mpi_scatterv__
#define mpi_send_			mpi_send__
#define mpi_send_init_			mpi_send_init__
#define mpi_sendrecv_			mpi_sendrecv__
#define mpi_sendrecv_replace_		mpi_sendrecv_replace__
#define mpi_ssend_			mpi_ssend__
#define mpi_ssend_init_			mpi_ssend_init__
#define mpi_start_			mpi_start__
#define mpi_startall_			mpi_startall__
#define mpi_test_			mpi_test__
#define mpi_test_cancelled_		mpi_test_cancelled__
#define mpi_testall_			mpi_testall__
#define mpi_testany_			mpi_testany__
#define mpi_testsome_			mpi_testsome__
#define mpi_topo_test_			mpi_topo_test__
#define mpi_type_commit_		mpi_type_commit__
#define mpi_type_contiguous_		mpi_type_contiguous__
#define mpi_type_count_			mpi_type_count__
#define mpi_type_create_darray_		mpi_type_create_darray__
#define mpi_type_create_hindexed_	mpi_type_create_hindexed__
#define mpi_type_create_hvector_	mpi_type_create_hvector__
#define mpi_type_create_keyval_		mpi_type_create_keyval__
#define mpi_type_create_resized_	mpi_type_create_resized__
#define mpi_type_create_struct_		mpi_type_create_struct__
#define mpi_type_create_subarray_	mpi_type_create_subarray__
#define mpi_type_delete_attr_		mpi_type_delete_attr__
#define mpi_type_dup_			mpi_type_dup__
#define mpi_type_extent_		mpi_type_extent__
#define mpi_type_free_			mpi_type_free__
#define mpi_type_free_keyval_		mpi_type_free_keyval__
#define mpi_type_get_attr_		mpi_type_get_attr__
#define mpi_type_get_contents_		mpi_type_get_contents__
#define mpi_type_get_envelope_		mpi_type_get_envelope__
#define mpi_type_get_extent_		mpi_type_get_extent__
#define mpi_type_get_name_		mpi_type_get_name__
#define mpi_type_get_true_extent_	mpi_type_get_true_extent__
#define mpi_type_hindexed_		mpi_type_hindexed__
#define mpi_type_hvector_		mpi_type_hvector__
#define mpi_type_indexed_		mpi_type_indexed__
#define mpi_type_lb_			mpi_type_lb__
#define mpi_type_set_attr_		mpi_type_set_attr__
#define mpi_type_set_name_		mpi_type_set_name__
#define mpi_type_size_			mpi_type_size__
#define mpi_type_struct_		mpi_type_struct__
#define mpi_type_ub_			mpi_type_ub__
#define mpi_type_vector_		mpi_type_vector__
#define mpi_unpack_			mpi_unpack__
#define mpi_unpublish_name_		mpi_unpublish_name__
#define mpi_wait_			mpi_wait__
#define mpi_waitall_			mpi_waitall__
#define mpi_waitany_			mpi_waitany__
#define mpi_waitsome_			mpi_waitsome__
#define mpi_win_complete_		mpi_win_complete__
#define mpi_win_create_			mpi_win_create__
#define mpi_win_create_errhandler_	mpi_win_create_errhandler__
#define mpi_win_create_keyval_		mpi_win_create_keyval__
#define mpi_win_delete_attr_		mpi_win_delete_attr__
#define mpi_win_fence_			mpi_win_fence__
#define mpi_win_free_			mpi_win_free__
#define mpi_win_free_keyval_		mpi_win_free_keyval__
#define mpi_win_get_attr_		mpi_win_get_attr__
#define mpi_win_get_errhandler_		mpi_win_get_errhandler__
#define mpi_win_get_group_		mpi_win_get_group__
#define mpi_win_get_name_		mpi_win_get_name__
#define mpi_win_post_			mpi_win_post__
#define mpi_win_set_attr_		mpi_win_set_attr__
#define mpi_win_set_errhandler_		mpi_win_set_errhandler__
#define mpi_win_set_name_		mpi_win_set_name__
#define mpi_win_start_			mpi_win_start__
#define mpi_win_wait_			mpi_win_wait__
#define mpi_wtick_			mpi_wtick__
#define mpi_wtime_			mpi_wtime__

#define mpil_comm_gps_			mpil_comm_gps__
#define mpil_comm_id_			mpil_comm_id__
#define mpil_comm_parent_		mpil_comm_parent__
#define mpil_signal_			mpil_signal__
#define mpil_spawn_			mpil_spawn__
#define mpil_type_id_			mpil_type_id__

#endif /* not LAM_PROFILELIB */

#define mpi_dup_fn_			mpi_dup_fn__
#define mpi_comm_dup_fn_		mpi_comm_dup_fn__
#define mpi_type_dup_fn_		mpi_type_dup_fn__
#define mpi_win_dup_fn_			mpi_win_dup_fn__
#define mpi_null_copy_fn_		mpi_null_copy_fn__
#define mpi_null_delete_fn_		mpi_null_delete_fn__
#define mpi_comm_null_copy_fn_		mpi_comm_null_copy_fn__
#define mpi_comm_null_delete_fn_	mpi_comm_null_delete_fn__
#define mpi_type_null_copy_fn_		mpi_type_null_copy_fn__
#define mpi_type_null_delete_fn_	mpi_type_null_delete_fn__
#define mpi_win_null_copy_fn_		mpi_win_null_copy_fn__
#define mpi_win_null_delete_fn_		mpi_win_null_delete_fn__

#define mpi_bottom_			mpi_bottom__
#define mpi_argv_null_			mpi_argv_null__
#define mpi_argvs_null_			mpi_argvs_null__
#define mpi_errcodes_ignore_		mpi_errcodes_ignore__
#define mpi_status_ignore_		mpi_status_ignore__
#define mpi_statuses_ignore_		mpi_statuses_ignore__

#define xmpi_buoy_			xmpi_buoy__
#define xmpi_coloron_			xmpi_coloron__
#define xmpi_coloroff_			xmpi_coloroff__

#elif LAM_FORTRANCAPS

/*
 * caps convention
 */

#if LAM_PROFILELIB

#define mpi_abort_			PMPI_ABORT
#define mpi_accumulate_			PMPI_ACCUMULATE
#define mpi_address_			PMPI_ADDRESS
#define mpi_allgather_			PMPI_ALLGATHER
#define mpi_allgatherv_			PMPI_ALLGATHERV
#define mpi_alloc_mem_			PMPI_ALLOC_MEM
#define mpi_allreduce_			PMPI_ALLREDUCE
#define mpi_alltoall_			PMPI_ALLTOALL
#define mpi_alltoallv_			PMPI_ALLTOALLV
#define mpi_attr_delete_		PMPI_ATTR_DELETE
#define mpi_attr_get_			PMPI_ATTR_GET
#define mpi_attr_put_			PMPI_ATTR_PUT
#define mpi_barrier_			PMPI_BARRIER
#define mpi_bcast_			PMPI_BCAST
#define mpi_bsend_			PMPI_BSEND
#define mpi_bsend_init_			PMPI_BSEND_INIT
#define mpi_buffer_attach_		PMPI_BUFFER_ATTACH
#define mpi_buffer_detach_		PMPI_BUFFER_DETACH
#define mpi_cancel_			PMPI_CANCEL
#define mpi_cart_coords_		PMPI_CART_COORDS
#define mpi_cart_create_		PMPI_CART_CREATE
#define mpi_cart_get_			PMPI_CART_GET
#define mpi_cart_map_			PMPI_CART_MAP
#define mpi_cart_rank_			PMPI_CART_RANK
#define mpi_cart_shift_			PMPI_CART_SHIFT
#define mpi_cart_sub_			PMPI_CART_SUB
#define mpi_cartdim_get_		PMPI_CARTDIM_GET
#define mpi_close_port_			PMPI_CLOSE_PORT
#define mpi_comm_accept_		PMPI_COMM_ACCEPT
#define mpi_comm_compare_		PMPI_COMM_COMPARE
#define mpi_comm_connect_		PMPI_COMM_CONNECT
#define mpi_comm_create_		PMPI_COMM_CREATE
#define mpi_comm_create_errhandler_	PMPI_COMM_CREATE_ERRHANDLER
#define mpi_comm_create_keyval_		PMPI_COMM_CREATE_KEYVAL
#define mpi_comm_delete_attr_		PMPI_COMM_DELETE_ATTR
#define mpi_comm_disconnect_		PMPI_COMM_DISCONNECT
#define mpi_comm_dup_			PMPI_COMM_DUP
#define mpi_comm_free_			PMPI_COMM_FREE
#define mpi_comm_free_keyval_		PMPI_COMM_FREE_KEYVAL
#define mpi_comm_get_attr_		PMPI_COMM_GET_ATTR
#define mpi_comm_get_errhandler_	PMPI_COMM_GET_ERRHANDLER
#define mpi_comm_get_name_		PMPI_COMM_GET_NAME
#define mpi_comm_get_parent_		PMPI_COMM_GET_PARENT
#define mpi_comm_group_			PMPI_COMM_GROUP
#define mpi_comm_join_			PMPI_COMM_JOIN
#define mpi_comm_rank_			PMPI_COMM_RANK
#define mpi_comm_remote_group_		PMPI_COMM_REMOTE_GROUP
#define mpi_comm_remote_size_		PMPI_COMM_REMOTE_SIZE
#define mpi_comm_set_attr_		PMPI_COMM_SET_ATTR
#define mpi_comm_set_errhandler_	PMPI_COMM_SET_ERRHANDLER
#define mpi_comm_set_name_		PMPI_COMM_SET_NAME
#define mpi_comm_size_			PMPI_COMM_SIZE
#define mpi_comm_spawn_			PMPI_COMM_SPAWN
#define mpi_comm_spawn_multiple_	PMPI_COMM_SPAWN_MULTIPLE
#define mpi_comm_split_			PMPI_COMM_SPLIT
#define mpi_comm_test_inter_		PMPI_COMM_TEST_INTER
#define mpi_dims_create_		PMPI_DIMS_CREATE
#define mpi_errhandler_f2c_             PMPI_ERRHANDLER_F2C
#define mpi_errhandler_create_		PMPI_ERRHANDLER_CREATE
#define mpi_errhandler_c2f_             PMPI_ERRHANDLER_C2F
#define mpi_errhandler_free_		PMPI_ERRHANDLER_FREE
#define mpi_errhandler_get_		PMPI_ERRHANDLER_GET
#define mpi_errhandler_set_		PMPI_ERRHANDLER_SET
#define mpi_error_class_		PMPI_ERROR_CLASS
#define mpi_error_string_		PMPI_ERROR_STRING
#define mpi_free_mem_			PMPI_FREE_MEM
#define mpi_finalize_			PMPI_FINALIZE
#define mpi_finalized_			PMPI_FINALIZED
#define mpi_gather_			PMPI_GATHER
#define mpi_gatherv_			PMPI_GATHERV
#define mpi_get_			PMPI_GET
#define mpi_get_address_		PMPI_GET_ADDRESS
#define mpi_get_count_			PMPI_GET_COUNT
#define mpi_get_elements_		PMPI_GET_ELEMENTS
#define mpi_get_processor_name_		PMPI_GET_PROCESSOR_NAME
#define mpi_get_version_		PMPI_GET_VERSION
#define mpi_graph_create_		PMPI_GRAPH_CREATE
#define mpi_graph_get_			PMPI_GRAPH_GET
#define mpi_graph_map_			PMPI_GRAPH_MAP
#define mpi_graph_neighbors_		PMPI_GRAPH_NEIGHBORS
#define mpi_graph_neighbors_count_	PMPI_GRAPH_NEIGHBORS_COUNT
#define mpi_graphdims_get_		PMPI_GRAPHDIMS_GET
#define mpi_group_compare_		PMPI_GROUP_COMPARE
#define mpi_group_difference_		PMPI_GROUP_DIFFERENCE
#define mpi_group_excl_			PMPI_GROUP_EXCL
#define mpi_group_free_			PMPI_GROUP_FREE
#define mpi_group_incl_			PMPI_GROUP_INCL
#define mpi_group_intersection_		PMPI_GROUP_INTERSECTION
#define mpi_group_range_excl_		PMPI_GROUP_RANGE_EXCL
#define mpi_group_range_incl_		PMPI_GROUP_RANGE_INCL
#define mpi_group_rank_			PMPI_GROUP_RANK
#define mpi_group_size_			PMPI_GROUP_SIZE
#define mpi_group_translate_ranks_	PMPI_GROUP_TRANSLATE_RANKS
#define mpi_group_union_		PMPI_GROUP_UNION
#define mpi_ibsend_			PMPI_IBSEND
#define mpi_info_create_		PMPI_INFO_CREATE
#define mpi_info_delete_		PMPI_INFO_DELETE
#define mpi_info_dup_			PMPI_INFO_DUP
#define mpi_info_free_			PMPI_INFO_FREE
#define mpi_info_get_			PMPI_INFO_GET
#define mpi_info_get_nkeys_		PMPI_INFO_GET_NKEYS
#define mpi_info_get_nthkey_		PMPI_INFO_GET_NTHKEY
#define mpi_info_get_valuelen_		PMPI_INFO_GET_VALUELEN
#define mpi_info_set_			PMPI_INFO_SET
#define mpi_init_			PMPI_INIT
#define mpi_init_thread_		PMPI_INIT_THREAD
#define mpi_initialized_		PMPI_INITIALIZED
#define mpi_intercomm_create_		PMPI_INTERCOMM_CREATE
#define mpi_intercomm_merge_		PMPI_INTERCOMM_MERGE
#define mpi_iprobe_			PMPI_IPROBE
#define mpi_irecv_			PMPI_IRECV
#define mpi_irsend_			PMPI_IRSEND
#define mpi_is_thread_main_		PMPI_IS_THREAD_MAIN
#define mpi_isend_			PMPI_ISEND
#define mpi_issend_			PMPI_ISSEND
#define mpi_keyval_create_		PMPI_KEYVAL_CREATE
#define mpi_keyval_free_		PMPI_KEYVAL_FREE
#define mpi_lookup_name_		PMPI_LOOKUP_NAME
#define mpi_op_create_			PMPI_OP_CREATE
#define mpi_op_free_			PMPI_OP_FREE
#define mpi_open_port_			PMPI_OPEN_PORT
#define mpi_pack_			PMPI_PACK
#define mpi_pack_size_			PMPI_PACK_SIZE
#define mpi_pcontrol_			PMPI_PCONTROL
#define mpi_probe_			PMPI_PROBE
#define mpi_publish_name_		PMPI_PUBLISH_NAME
#define mpi_put_			PMPI_PUT
#define mpi_query_thread_		PMPI_QUERY_THREAD
#define mpi_recv_			PMPI_RECV
#define mpi_recv_init_			PMPI_RECV_INIT
#define mpi_reduce_			PMPI_REDUCE
#define mpi_reduce_scatter_		PMPI_REDUCE_SCATTER
#define mpi_request_free_		PMPI_REQUEST_FREE
#define mpi_rsend_			PMPI_RSEND
#define mpi_rsend_init_			PMPI_RSEND_INIT
#define mpi_scan_			PMPI_SCAN
#define mpi_scatter_			PMPI_SCATTER
#define mpi_scatterv_			PMPI_SCATTERV
#define mpi_send_			PMPI_SEND
#define mpi_send_init_			PMPI_SEND_INIT
#define mpi_sendrecv_			PMPI_SENDRECV
#define mpi_sendrecv_replace_		PMPI_SENDRECV_REPLACE
#define mpi_ssend_			PMPI_SSEND
#define mpi_ssend_init_			PMPI_SSEND_INIT
#define mpi_start_			PMPI_START
#define mpi_startall_			PMPI_STARTALL
#define mpi_test_			PMPI_TEST
#define mpi_test_cancelled_		PMPI_TEST_CANCELLED
#define mpi_testall_			PMPI_TESTALL
#define mpi_testany_			PMPI_TESTANY
#define mpi_testsome_			PMPI_TESTSOME
#define mpi_topo_test_			PMPI_TOPO_TEST
#define mpi_type_commit_		PMPI_TYPE_COMMIT
#define mpi_type_contiguous_		PMPI_TYPE_CONTIGUOUS
#define mpi_type_count_			PMPI_TYPE_COUNT
#define mpi_type_create_darray_		PMPI_TYPE_CREATE_DARRAY
#define mpi_type_create_hindexed_	PMPI_TYPE_CREATE_HINDEXED
#define mpi_type_create_hvector_	PMPI_TYPE_CREATE_HVECTOR
#define mpi_type_create_keyval_		PMPI_TYPE_CREATE_KEYVAL
#define mpi_type_create_resized_	PMPI_TYPE_CREATE_RESIZED
#define mpi_type_create_struct_		PMPI_TYPE_CREATE_STRUCT
#define mpi_type_create_subarray_	PMPI_TYPE_CREATE_SUBARRAY
#define mpi_type_delete_attr_		PMPI_TYPE_DELETE_ATTR
#define mpi_type_dup_			PMPI_TYPE_DUP
#define mpi_type_extent_		PMPI_TYPE_EXTENT
#define mpi_type_free_			PMPI_TYPE_FREE
#define mpi_type_free_keyval_		PMPI_TYPE_FREE_KEYVAL
#define mpi_type_get_attr_		PMPI_TYPE_GET_ATTR
#define mpi_type_get_contents_		PMPI_TYPE_GET_CONTENTS
#define mpi_type_get_envelope_		PMPI_TYPE_GET_ENVELOPE
#define mpi_type_get_extent_		PMPI_TYPE_GET_EXTENT
#define mpi_type_get_name_		PMPI_TYPE_GET_NAME
#define mpi_type_get_true_extent_	PMPI_TYPE_GET_TRUE_EXTENT
#define mpi_type_hindexed_		PMPI_TYPE_HINDEXED
#define mpi_type_hvector_		PMPI_TYPE_HVECTOR
#define mpi_type_indexed_		PMPI_TYPE_INDEXED
#define mpi_type_lb_			PMPI_TYPE_LB
#define mpi_type_set_attr_		PMPI_TYPE_SET_ATTR
#define mpi_type_set_name_		PMPI_TYPE_SET_NAME
#define mpi_type_size_			PMPI_TYPE_SIZE
#define mpi_type_struct_		PMPI_TYPE_STRUCT
#define mpi_type_ub_			PMPI_TYPE_UB
#define mpi_type_vector_		PMPI_TYPE_VECTOR
#define mpi_unpack_			PMPI_UNPACK
#define mpi_unpublish_name_		PMPI_UNPUBLISH_NAME
#define mpi_wait_			PMPI_WAIT
#define mpi_waitall_			PMPI_WAITALL
#define mpi_waitany_			PMPI_WAITANY
#define mpi_waitsome_			PMPI_WAITSOME
#define mpi_win_complete_		PMPI_WIN_COMPLETE
#define mpi_win_create_			PMPI_WIN_CREATE
#define mpi_win_create_errhandler_	PMPI_WIN_CREATE_ERRHANDLER
#define mpi_win_create_keyval_		PMPI_WIN_CREATE_KEYVAL
#define mpi_win_delete_attr_		PMPI_WIN_DELETE_ATTR
#define mpi_win_fence_			PMPI_WIN_FENCE
#define mpi_win_free_			PMPI_WIN_FREE
#define mpi_win_free_keyval_		PMPI_WIN_FREE_KEYVAL
#define mpi_win_get_attr_		PMPI_WIN_GET_ATTR
#define mpi_win_get_errhandler_		PMPI_WIN_GET_ERRHANDLER
#define mpi_win_get_group_		PMPI_WIN_GET_GROUP
#define mpi_win_get_name_		PMPI_WIN_GET_NAME
#define mpi_win_post_			PMPI_WIN_POST
#define mpi_win_set_attr_		PMPI_WIN_SET_ATTR
#define mpi_win_set_errhandler_		PMPI_WIN_SET_ERRHANDLER
#define mpi_win_set_name_		PMPI_WIN_SET_NAME
#define mpi_win_start_			PMPI_WIN_START
#define mpi_win_wait_			PMPI_WIN_WAIT
#define mpi_wtick_			PMPI_WTICK
#define mpi_wtime_			PMPI_WTIME

#define mpil_comm_gps_			PMPIL_COMM_GPS
#define mpil_comm_id_			PMPIL_COMM_ID
#define mpil_comm_parent_		PMPIL_COMM_PARENT
#define mpil_signal_			PMPIL_SIGNAL
#define mpil_spawn_			PMPIL_SPAWN
#define mpil_type_id_			PMPIL_TYPE_ID

#else  /* not LAM_PROFILELIB */

#define mpi_abort_			MPI_ABORT
#define mpi_accumulate_			MPI_ACCUMULATE
#define mpi_address_			MPI_ADDRESS
#define mpi_allgather_			MPI_ALLGATHER
#define mpi_allgatherv_			MPI_ALLGATHERV
#define mpi_alloc_mem_			MPI_ALLOC_MEM
#define mpi_allreduce_			MPI_ALLREDUCE
#define mpi_alltoall_			MPI_ALLTOALL
#define mpi_alltoallv_			MPI_ALLTOALLV
#define mpi_attr_delete_		MPI_ATTR_DELETE
#define mpi_attr_get_			MPI_ATTR_GET
#define mpi_attr_put_			MPI_ATTR_PUT
#define mpi_barrier_			MPI_BARRIER
#define mpi_bcast_			MPI_BCAST
#define mpi_bsend_			MPI_BSEND
#define mpi_bsend_init_			MPI_BSEND_INIT
#define mpi_buffer_attach_		MPI_BUFFER_ATTACH
#define mpi_buffer_detach_		MPI_BUFFER_DETACH
#define mpi_cancel_			MPI_CANCEL
#define mpi_cart_coords_		MPI_CART_COORDS
#define mpi_cart_create_		MPI_CART_CREATE
#define mpi_cart_get_			MPI_CART_GET
#define mpi_cart_map_			MPI_CART_MAP
#define mpi_cart_rank_			MPI_CART_RANK
#define mpi_cart_shift_			MPI_CART_SHIFT
#define mpi_cart_sub_			MPI_CART_SUB
#define mpi_cartdim_get_		MPI_CARTDIM_GET
#define mpi_close_port_			MPI_CLOSE_PORT
#define mpi_comm_accept_		MPI_COMM_ACCEPT
#define mpi_comm_compare_		MPI_COMM_COMPARE
#define mpi_comm_connect_		MPI_COMM_CONNECT
#define mpi_comm_create_		MPI_COMM_CREATE
#define mpi_comm_create_errhandler_	MPI_COMM_CREATE_ERRHANDLER
#define mpi_comm_create_keyval_		MPI_COMM_CREATE_KEYVAL
#define mpi_comm_delete_attr_		MPI_COMM_DELETE_ATTR
#define mpi_comm_disconnect_		MPI_COMM_DISCONNECT
#define mpi_comm_dup_			MPI_COMM_DUP
#define mpi_comm_free_			MPI_COMM_FREE
#define mpi_comm_free_keyval_		MPI_COMM_FREE_KEYVAL
#define mpi_comm_get_attr_		MPI_COMM_GET_ATTR
#define mpi_comm_get_errhandler_	MPI_COMM_GET_ERRHANDLER
#define mpi_comm_get_name_		MPI_COMM_GET_NAME
#define mpi_comm_get_parent_		MPI_COMM_GET_PARENT
#define mpi_comm_group_			MPI_COMM_GROUP
#define mpi_comm_join_			MPI_COMM_JOIN
#define mpi_comm_rank_			MPI_COMM_RANK
#define mpi_comm_remote_group_		MPI_COMM_REMOTE_GROUP
#define mpi_comm_remote_size_		MPI_COMM_REMOTE_SIZE
#define mpi_comm_set_attr_		MPI_COMM_SET_ATTR
#define mpi_comm_set_errhandler_	MPI_COMM_SET_ERRHANDLER
#define mpi_comm_set_name_		MPI_COMM_SET_NAME
#define mpi_comm_size_			MPI_COMM_SIZE
#define mpi_comm_spawn_			MPI_COMM_SPAWN
#define mpi_comm_spawn_multiple_	MPI_COMM_SPAWN_MULTIPLE
#define mpi_comm_split_			MPI_COMM_SPLIT
#define mpi_comm_test_inter_		MPI_COMM_TEST_INTER
#define mpi_dims_create_		MPI_DIMS_CREATE
#define mpi_errhandler_f2c_             MPI_ERRHANLDER_F2C
#define mpi_errhandler_create_		MPI_ERRHANDLER_CREATE
#define mpi_errhandler_c2f_             MPI_ERRHANLDER_C2F
#define mpi_errhandler_free_		MPI_ERRHANDLER_FREE
#define mpi_errhandler_get_		MPI_ERRHANDLER_GET
#define mpi_errhandler_set_		MPI_ERRHANDLER_SET
#define mpi_error_class_		MPI_ERROR_CLASS
#define mpi_error_string_		MPI_ERROR_STRING
#define mpi_free_mem_			MPI_FREE_MEM
#define mpi_finalize_			MPI_FINALIZE
#define mpi_finalized_			MPI_FINALIZED
#define mpi_gather_			MPI_GATHER
#define mpi_gatherv_			MPI_GATHERV
#define mpi_get_			MPI_GET
#define mpi_get_address_		MPI_GET_ADDRESS
#define mpi_get_count_			MPI_GET_COUNT
#define mpi_get_elements_		MPI_GET_ELEMENTS
#define mpi_get_processor_name_		MPI_GET_PROCESSOR_NAME
#define mpi_get_version_		MPI_GET_VERSION
#define mpi_graph_create_		MPI_GRAPH_CREATE
#define mpi_graph_get_			MPI_GRAPH_GET
#define mpi_graph_map_			MPI_GRAPH_MAP
#define mpi_graph_neighbors_		MPI_GRAPH_NEIGHBORS
#define mpi_graph_neighbors_count_	MPI_GRAPH_NEIGHBORS_COUNT
#define mpi_graphdims_get_		MPI_GRAPHDIMS_GET
#define mpi_group_compare_		MPI_GROUP_COMPARE
#define mpi_group_difference_		MPI_GROUP_DIFFERENCE
#define mpi_group_excl_			MPI_GROUP_EXCL
#define mpi_group_free_			MPI_GROUP_FREE
#define mpi_group_incl_			MPI_GROUP_INCL
#define mpi_group_intersection_		MPI_GROUP_INTERSECTION
#define mpi_group_range_excl_		MPI_GROUP_RANGE_EXCL
#define mpi_group_range_incl_		MPI_GROUP_RANGE_INCL
#define mpi_group_rank_			MPI_GROUP_RANK
#define mpi_group_size_			MPI_GROUP_SIZE
#define mpi_group_translate_ranks_	MPI_GROUP_TRANSLATE_RANKS
#define mpi_group_union_		MPI_GROUP_UNION
#define mpi_ibsend_			MPI_IBSEND
#define mpi_info_create_		MPI_INFO_CREATE
#define mpi_info_delete_		MPI_INFO_DELETE
#define mpi_info_dup_			MPI_INFO_DUP
#define mpi_info_free_			MPI_INFO_FREE
#define mpi_info_get_			MPI_INFO_GET
#define mpi_info_get_nkeys_		MPI_INFO_GET_NKEYS
#define mpi_info_get_nthkey_		MPI_INFO_GET_NTHKEY
#define mpi_info_get_valuelen_		MPI_INFO_GET_VALUELEN
#define mpi_info_set_			MPI_INFO_SET
#define mpi_init_			MPI_INIT
#define mpi_init_thread_		MPI_INIT_THREAD
#define mpi_initialized_		MPI_INITIALIZED
#define mpi_intercomm_create_		MPI_INTERCOMM_CREATE
#define mpi_intercomm_merge_		MPI_INTERCOMM_MERGE
#define mpi_iprobe_			MPI_IPROBE
#define mpi_irecv_			MPI_IRECV
#define mpi_irsend_			MPI_IRSEND
#define mpi_is_thread_main_		MPI_IS_THREAD_MAIN
#define mpi_isend_			MPI_ISEND
#define mpi_issend_			MPI_ISSEND
#define mpi_keyval_create_		MPI_KEYVAL_CREATE
#define mpi_keyval_free_		MPI_KEYVAL_FREE
#define mpi_lookup_name_		MPI_LOOKUP_NAME
#define mpi_op_create_			MPI_OP_CREATE
#define mpi_op_free_			MPI_OP_FREE
#define mpi_open_port_			MPI_OPEN_PORT
#define mpi_pack_			MPI_PACK
#define mpi_pack_size_			MPI_PACK_SIZE
#define mpi_pcontrol_			MPI_PCONTROL
#define mpi_probe_			MPI_PROBE
#define mpi_publish_name_		MPI_PUBLISH_NAME
#define mpi_put_			MPI_PUT
#define mpi_query_thread_		MPI_QUERY_THREAD
#define mpi_recv_			MPI_RECV
#define mpi_recv_init_			MPI_RECV_INIT
#define mpi_reduce_			MPI_REDUCE
#define mpi_reduce_scatter_		MPI_REDUCE_SCATTER
#define mpi_request_free_		MPI_REQUEST_FREE
#define mpi_rsend_			MPI_RSEND
#define mpi_rsend_init_			MPI_RSEND_INIT
#define mpi_scan_			MPI_SCAN
#define mpi_scatter_			MPI_SCATTER
#define mpi_scatterv_			MPI_SCATTERV
#define mpi_send_			MPI_SEND
#define mpi_send_init_			MPI_SEND_INIT
#define mpi_sendrecv_			MPI_SENDRECV
#define mpi_sendrecv_replace_		MPI_SENDRECV_REPLACE
#define mpi_ssend_			MPI_SSEND
#define mpi_ssend_init_			MPI_SSEND_INIT
#define mpi_start_			MPI_START
#define mpi_startall_			MPI_STARTALL
#define mpi_test_			MPI_TEST
#define mpi_test_cancelled_		MPI_TEST_CANCELLED
#define mpi_testall_			MPI_TESTALL
#define mpi_testany_			MPI_TESTANY
#define mpi_testsome_			MPI_TESTSOME
#define mpi_topo_test_			MPI_TOPO_TEST
#define mpi_type_commit_		MPI_TYPE_COMMIT
#define mpi_type_contiguous_		MPI_TYPE_CONTIGUOUS
#define mpi_type_count_			MPI_TYPE_COUNT
#define mpi_type_create_darray_		MPI_TYPE_CREATE_DARRAY
#define mpi_type_create_hindexed_	MPI_TYPE_CREATE_HINDEXED
#define mpi_type_create_hvector_	MPI_TYPE_CREATE_HVECTOR
#define mpi_type_create_keyval_		MPI_TYPE_CREATE_KEYVAL
#define mpi_type_create_resized_	MPI_TYPE_CREATE_RESIZED
#define mpi_type_create_struct_		MPI_TYPE_CREATE_STRUCT
#define mpi_type_create_subarray_	MPI_TYPE_CREATE_SUBARRAY
#define mpi_type_delete_attr_		MPI_TYPE_DELETE_ATTR
#define mpi_type_dup_			MPI_TYPE_DUP
#define mpi_type_extent_		MPI_TYPE_EXTENT
#define mpi_type_free_			MPI_TYPE_FREE
#define mpi_type_free_keyval_		MPI_TYPE_FREE_KEYVAL
#define mpi_type_get_attr_		MPI_TYPE_GET_ATTR
#define mpi_type_get_contents_		MPI_TYPE_GET_CONTENTS
#define mpi_type_get_envelope_		MPI_TYPE_GET_ENVELOPE
#define mpi_type_get_extent_		MPI_TYPE_GET_EXTENT
#define mpi_type_get_name_		MPI_TYPE_GET_NAME
#define mpi_type_get_true_extent_	MPI_TYPE_GET_TRUE_EXTENT
#define mpi_type_hindexed_		MPI_TYPE_HINDEXED
#define mpi_type_hvector_		MPI_TYPE_HVECTOR
#define mpi_type_indexed_		MPI_TYPE_INDEXED
#define mpi_type_lb_			MPI_TYPE_LB
#define mpi_type_set_attr_		MPI_TYPE_SET_ATTR
#define mpi_type_set_name_		MPI_TYPE_SET_NAME
#define mpi_type_size_			MPI_TYPE_SIZE
#define mpi_type_struct_		MPI_TYPE_STRUCT
#define mpi_type_ub_			MPI_TYPE_UB
#define mpi_type_vector_		MPI_TYPE_VECTOR
#define mpi_unpack_			MPI_UNPACK
#define mpi_unpublish_name_		MPI_UNPUBLISH_NAME
#define mpi_wait_			MPI_WAIT
#define mpi_waitall_			MPI_WAITALL
#define mpi_waitany_			MPI_WAITANY
#define mpi_waitsome_			MPI_WAITSOME
#define mpi_win_complete_		MPI_WIN_COMPLETE
#define mpi_win_create_			MPI_WIN_CREATE
#define mpi_win_create_errhandler_	MPI_WIN_CREATE_ERRHANDLER
#define mpi_win_create_keyval_		MPI_WIN_CREATE_KEYVAL
#define mpi_win_delete_attr_		MPI_WIN_DELETE_ATTR
#define mpi_win_fence_			MPI_WIN_FENCE
#define mpi_win_free_			MPI_WIN_FREE
#define mpi_win_free_keyval_		MPI_WIN_FREE_KEYVAL
#define mpi_win_get_attr_		MPI_WIN_GET_ATTR
#define mpi_win_get_errhandler_		MPI_WIN_GET_ERRHANDLER
#define mpi_win_get_group_		MPI_WIN_GET_GROUP
#define mpi_win_get_name_		MPI_WIN_GET_NAME
#define mpi_win_post_			MPI_WIN_POST
#define mpi_win_set_attr_		MPI_WIN_SET_ATTR
#define mpi_win_set_errhandler_		MPI_WIN_SET_ERRHANDLER
#define mpi_win_set_name_		MPI_WIN_SET_NAME
#define mpi_win_start_			MPI_WIN_START
#define mpi_win_wait_			MPI_WIN_WAIT
#define mpi_wtick_			MPI_WTICK
#define mpi_wtime_			MPI_WTIME

#define mpil_comm_gps_			MPIL_COMM_GPS
#define mpil_comm_id_			MPIL_COMM_ID
#define mpil_comm_parent_		MPIL_COMM_PARENT
#define mpil_signal_			MPIL_SIGNAL
#define mpil_spawn_			MPIL_SPAWN
#define mpil_type_id_			MPIL_TYPE_ID

#endif /* not LAM_PROFILELIB */

#define mpi_dup_fn_			MPI_F_DUP_FN
#define mpi_comm_dup_fn_		MPI_F_COMM_DUP_FN
#define mpi_type_dup_fn_		MPI_F_TYPE_DUP_FN
#define mpi_win_dup_fn_			MPI_F_WIN_DUP_FN

#undef MPI_NULL_COPY_FN
#undef MPI_NULL_DELETE_FN
#undef MPI_COMM_NULL_COPY_FN
#undef MPI_COMM_NULL_DELETE_FN
#undef MPI_TYPE_NULL_COPY_FN
#undef MPI_TYPE_NULL_DELETE_FN
#undef MPI_WIN_NULL_COPY_FN
#undef MPI_WIN_NULL_DELETE_FN

#define mpi_null_copy_fn_		MPI_NULL_COPY_FN
#define mpi_null_delete_fn_		MPI_NULL_DELETE_FN
#define mpi_comm_null_copy_fn_		MPI_COMM_NULL_COPY_FN
#define mpi_comm_null_delete_fn_	MPI_COMM_NULL_DELETE_FN
#define mpi_type_null_copy_fn_		MPI_TYPE_NULL_COPY_FN
#define mpi_type_null_delete_fn_	MPI_TYPE_NULL_DELETE_FN
#define mpi_win_null_copy_fn_		MPI_WIN_NULL_COPY_FN
#define mpi_win_null_delete_fn_		MPI_WIN_NULL_DELETE_FN

#undef MPI_BOTTOM
#undef MPI_ARGV_NULL
#undef MPI_ARGVS_NULL
#undef MPI_ERRCODES_IGNORE
#undef MPI_STATUS_IGNORE
#undef MPI_STATUSES_IGNORE

#define mpi_bottom_			MPI_BOTTOM
#define mpi_argv_null_			MPI_ARGV_NULL
#define mpi_argvs_null_			MPI_ARGVS_NULL
#define mpi_errcodes_ignore_		MPI_ERRCODES_IGNORE
#define mpi_status_ignore_		MPI_STATUS_IGNORE
#define mpi_statuses_ignore_		MPI_STATUSES_IGNORE

#define xmpi_buoy_			XMPI_BUOY
#define xmpi_coloron_			XMPI_COLORON
#define xmpi_coloroff_			XMPI_COLOROFF

#elif LAM_FORTRANUNDERSCORE

/*
 * single underscore convention
 */

#ifdef LAM_PROFILELIB

#define mpi_abort_			pmpi_abort_
#define mpi_accumulate_			pmpi_accumulate_
#define mpi_address_			pmpi_address_
#define mpi_allgather_			pmpi_allgather_
#define mpi_allgatherv_			pmpi_allgatherv_
#define mpi_alloc_mem_			pmpi_alloc_mem_
#define mpi_allreduce_			pmpi_allreduce_
#define mpi_alltoall_			pmpi_alltoall_
#define mpi_alltoallv_			pmpi_alltoallv_
#define mpi_attr_delete_		pmpi_attr_delete_
#define mpi_attr_get_			pmpi_attr_get_
#define mpi_attr_put_			pmpi_attr_put_
#define mpi_barrier_			pmpi_barrier_
#define mpi_bcast_			pmpi_bcast_
#define mpi_bsend_			pmpi_bsend_
#define mpi_bsend_init_			pmpi_bsend_init_
#define mpi_buffer_attach_		pmpi_buffer_attach_
#define mpi_buffer_detach_		pmpi_buffer_detach_
#define mpi_cancel_			pmpi_cancel_
#define mpi_cart_coords_		pmpi_cart_coords_
#define mpi_cart_create_		pmpi_cart_create_
#define mpi_cart_get_			pmpi_cart_get_
#define mpi_cart_map_			pmpi_cart_map_
#define mpi_cart_rank_			pmpi_cart_rank_
#define mpi_cart_shift_			pmpi_cart_shift_
#define mpi_cart_sub_			pmpi_cart_sub_
#define mpi_cartdim_get_		pmpi_cartdim_get_
#define mpi_close_port_			pmpi_close_port_
#define mpi_comm_accept_		pmpi_comm_accept_
#define mpi_comm_compare_		pmpi_comm_compare_
#define mpi_comm_connect_		pmpi_comm_connect_
#define mpi_comm_create_		pmpi_comm_create_
#define mpi_comm_create_errhandler_	pmpi_comm_create_errhandler_
#define mpi_comm_create_keyval_		pmpi_comm_create_keyval_
#define mpi_comm_delete_attr_		pmpi_comm_delete_attr_
#define mpi_comm_disconnect_		pmpi_comm_disconnect_
#define mpi_comm_dup_			pmpi_comm_dup_
#define mpi_comm_free_			pmpi_comm_free_
#define mpi_comm_free_keyval_		pmpi_comm_free_keyval_
#define mpi_comm_get_attr_		pmpi_comm_get_attr_
#define mpi_comm_get_errhandler_	pmpi_comm_get_errhandler_
#define mpi_comm_get_name_		pmpi_comm_get_name_
#define mpi_comm_get_parent_		pmpi_comm_get_parent_
#define mpi_comm_group_			pmpi_comm_group_
#define mpi_comm_join_			pmpi_comm_join_
#define mpi_comm_rank_			pmpi_comm_rank_
#define mpi_comm_remote_group_		pmpi_comm_remote_group_
#define mpi_comm_remote_size_		pmpi_comm_remote_size_
#define mpi_comm_set_attr_		pmpi_comm_set_attr_
#define mpi_comm_set_errhandler_	pmpi_comm_set_errhandler_
#define mpi_comm_set_name_		pmpi_comm_set_name_
#define mpi_comm_size_			pmpi_comm_size_
#define mpi_comm_spawn_			pmpi_comm_spawn_
#define mpi_comm_spawn_multiple_	pmpi_comm_spawn_multiple_
#define mpi_comm_split_			pmpi_comm_split_
#define mpi_comm_test_inter_		pmpi_comm_test_inter_
#define mpi_dims_create_		pmpi_dims_create_
#define mpi_errhandler_f2c_             pmpi_errhandler_f2c_
#define mpi_errhandler_create_		pmpi_errhandler_create_
#define mpi_errhandler_c2f_             pmpi_errhandler_c2f_
#define mpi_errhandler_free_		pmpi_errhandler_free_
#define mpi_errhandler_get_		pmpi_errhandler_get_
#define mpi_errhandler_set_		pmpi_errhandler_set_
#define mpi_error_class_		pmpi_error_class_
#define mpi_error_string_		pmpi_error_string_
#define mpi_free_mem_			pmpi_free_mem_
#define mpi_finalize_			pmpi_finalize_
#define mpi_finalized_			pmpi_finalized_
#define mpi_gather_			pmpi_gather_
#define mpi_gatherv_			pmpi_gatherv_
#define mpi_get_			pmpi_get_
#define mpi_get_address_		pmpi_get_address_
#define mpi_get_count_			pmpi_get_count_
#define mpi_get_elements_		pmpi_get_elements_
#define mpi_get_processor_name_		pmpi_get_processor_name_
#define mpi_get_version_		pmpi_get_version_
#define mpi_graph_create_		pmpi_graph_create_
#define mpi_graph_get_			pmpi_graph_get_
#define mpi_graph_map_			pmpi_graph_map_
#define mpi_graph_neighbors_		pmpi_graph_neighbors_
#define mpi_graph_neighbors_count_	pmpi_graph_neighbors_count_
#define mpi_graphdims_get_		pmpi_graphdims_get_
#define mpi_group_compare_		pmpi_group_compare_
#define mpi_group_difference_		pmpi_group_difference_
#define mpi_group_excl_			pmpi_group_excl_
#define mpi_group_free_			pmpi_group_free_
#define mpi_group_incl_			pmpi_group_incl_
#define mpi_group_intersection_		pmpi_group_intersection_
#define mpi_group_range_excl_		pmpi_group_range_excl_
#define mpi_group_range_incl_		pmpi_group_range_incl_
#define mpi_group_rank_			pmpi_group_rank_
#define mpi_group_size_			pmpi_group_size_
#define mpi_group_translate_ranks_	pmpi_group_translate_ranks_
#define mpi_group_union_		pmpi_group_union_
#define mpi_ibsend_			pmpi_ibsend_
#define mpi_info_create_		pmpi_info_create_
#define mpi_info_delete_		pmpi_info_delete_
#define mpi_info_dup_			pmpi_info_dup_
#define mpi_info_free_			pmpi_info_free_
#define mpi_info_get_			pmpi_info_get_
#define mpi_info_get_nkeys_		pmpi_info_get_nkeys_
#define mpi_info_get_nthkey_		pmpi_info_get_nthkey_
#define mpi_info_get_valuelen_		pmpi_info_get_valuelen_
#define mpi_info_set_			pmpi_info_set_
#define mpi_init_			pmpi_init_
#define mpi_init_thread_		pmpi_init_thread_
#define mpi_initialized_		pmpi_initialized_
#define mpi_intercomm_create_		pmpi_intercomm_create_
#define mpi_intercomm_merge_		pmpi_intercomm_merge_
#define mpi_iprobe_			pmpi_iprobe_
#define mpi_irecv_			pmpi_irecv_
#define mpi_irsend_			pmpi_irsend_
#define mpi_is_thread_main_		pmpi_is_thread_main_
#define mpi_isend_			pmpi_isend_
#define mpi_issend_			pmpi_issend_
#define mpi_keyval_create_		pmpi_keyval_create_
#define mpi_keyval_free_		pmpi_keyval_free_
#define mpi_lookup_name_		pmpi_lookup_name_
#define mpi_op_create_			pmpi_op_create_
#define mpi_op_free_			pmpi_op_free_
#define mpi_open_port_			pmpi_open_port_
#define mpi_pack_			pmpi_pack_
#define mpi_pack_size_			pmpi_pack_size_
#define mpi_pcontrol_			pmpi_pcontrol_
#define mpi_probe_			pmpi_probe_
#define mpi_publish_name_		pmpi_publish_name_
#define mpi_put_			pmpi_put_
#define mpi_query_thread_		pmpi_query_thread_
#define mpi_recv_			pmpi_recv_
#define mpi_recv_init_			pmpi_recv_init_
#define mpi_reduce_			pmpi_reduce_
#define mpi_reduce_scatter_		pmpi_reduce_scatter_
#define mpi_request_free_		pmpi_request_free_
#define mpi_rsend_			pmpi_rsend_
#define mpi_rsend_init_			pmpi_rsend_init_
#define mpi_scan_			pmpi_scan_
#define mpi_scatter_			pmpi_scatter_
#define mpi_scatterv_			pmpi_scatterv_
#define mpi_send_			pmpi_send_
#define mpi_send_init_			pmpi_send_init_
#define mpi_sendrecv_			pmpi_sendrecv_
#define mpi_sendrecv_replace_		pmpi_sendrecv_replace_
#define mpi_ssend_			pmpi_ssend_
#define mpi_ssend_init_			pmpi_ssend_init_
#define mpi_start_			pmpi_start_
#define mpi_startall_			pmpi_startall_
#define mpi_test_			pmpi_test_
#define mpi_test_cancelled_		pmpi_test_cancelled_
#define mpi_testall_			pmpi_testall_
#define mpi_testany_			pmpi_testany_
#define mpi_testsome_			pmpi_testsome_
#define mpi_topo_test_			pmpi_topo_test_
#define mpi_type_commit_		pmpi_type_commit_
#define mpi_type_contiguous_		pmpi_type_contiguous_
#define mpi_type_count_			pmpi_type_count_
#define mpi_type_create_darray_		pmpi_type_create_darray_
#define mpi_type_create_hindexed_	pmpi_type_create_hindexed_
#define mpi_type_create_hvector_	pmpi_type_create_hvector_
#define mpi_type_create_keyval_		pmpi_type_create_keyval_
#define mpi_type_create_resized_	pmpi_type_create_resized_
#define mpi_type_create_struct_		pmpi_type_create_struct_
#define mpi_type_create_subarray_	pmpi_type_create_subarray_
#define mpi_type_delete_attr_		pmpi_type_delete_attr_
#define mpi_type_dup_			pmpi_type_dup_
#define mpi_type_extent_		pmpi_type_extent_
#define mpi_type_free_			pmpi_type_free_
#define mpi_type_free_keyval_		pmpi_type_free_keyval_
#define mpi_type_get_attr_		pmpi_type_get_attr_
#define mpi_type_get_contents_		pmpi_type_get_contents_
#define mpi_type_get_envelope_		pmpi_type_get_envelope_
#define mpi_type_get_extent_		pmpi_type_get_extent_
#define mpi_type_get_name_		pmpi_type_get_name_
#define mpi_type_get_true_extent_	pmpi_type_get_true_extent_
#define mpi_type_hindexed_		pmpi_type_hindexed_
#define mpi_type_hvector_		pmpi_type_hvector_
#define mpi_type_indexed_		pmpi_type_indexed_
#define mpi_type_lb_			pmpi_type_lb_
#define mpi_type_set_attr_		pmpi_type_set_attr_
#define mpi_type_set_name_		pmpi_type_set_name_
#define mpi_type_size_			pmpi_type_size_
#define mpi_type_struct_		pmpi_type_struct_
#define mpi_type_ub_			pmpi_type_ub_
#define mpi_type_vector_		pmpi_type_vector_
#define mpi_unpack_			pmpi_unpack_
#define mpi_unpublish_name_		pmpi_unpublish_name_
#define mpi_wait_			pmpi_wait_
#define mpi_waitall_			pmpi_waitall_
#define mpi_waitany_			pmpi_waitany_
#define mpi_waitsome_			pmpi_waitsome_
#define mpi_win_complete_		pmpi_win_complete_
#define mpi_win_create_			pmpi_win_create_
#define mpi_win_create_errhandler_	pmpi_win_create_errhandler_
#define mpi_win_create_keyval_		pmpi_win_create_keyval_
#define mpi_win_delete_attr_		pmpi_win_delete_attr_
#define mpi_win_fence_			pmpi_win_fence_
#define mpi_win_free_			pmpi_win_free_
#define mpi_win_free_keyval_		pmpi_win_free_keyval_
#define mpi_win_get_attr_		pmpi_win_get_attr_
#define mpi_win_get_errhandler_		pmpi_win_get_errhandler_
#define mpi_win_get_group_		pmpi_win_get_group_
#define mpi_win_get_name_		pmpi_win_get_name_
#define mpi_win_post_			pmpi_win_post_
#define mpi_win_set_attr_		pmpi_win_set_attr_
#define mpi_win_set_errhandler_		pmpi_win_set_errhandler_
#define mpi_win_set_name_		pmpi_win_set_name_
#define mpi_win_start_			pmpi_win_start_
#define mpi_win_wait_			pmpi_win_wait_
#define mpi_wtick_			pmpi_wtick_
#define mpi_wtime_			pmpi_wtime_

#define mpil_comm_gps_			pmpil_comm_gps_
#define mpil_comm_id_			pmpil_comm_id_
#define mpil_comm_parent_		pmpil_comm_parent_
#define mpil_signal_			pmpil_signal_
#define mpil_spawn_			pmpil_spawn_
#define mpil_type_id_			pmpil_type_id_

#else  /* not LAM_PROFILELIB */

#define mpi_abort_			mpi_abort_
#define mpi_accumulate_			mpi_accumulate_
#define mpi_address_			mpi_address_
#define mpi_allgather_			mpi_allgather_
#define mpi_allgatherv_			mpi_allgatherv_
#define mpi_alloc_mem_			mpi_alloc_mem_
#define mpi_allreduce_			mpi_allreduce_
#define mpi_alltoall_			mpi_alltoall_
#define mpi_alltoallv_			mpi_alltoallv_
#define mpi_attr_delete_		mpi_attr_delete_
#define mpi_attr_get_			mpi_attr_get_
#define mpi_attr_put_			mpi_attr_put_
#define mpi_barrier_			mpi_barrier_
#define mpi_bcast_			mpi_bcast_
#define mpi_bsend_			mpi_bsend_
#define mpi_bsend_init_			mpi_bsend_init_
#define mpi_buffer_attach_		mpi_buffer_attach_
#define mpi_buffer_detach_		mpi_buffer_detach_
#define mpi_cancel_			mpi_cancel_
#define mpi_cart_coords_		mpi_cart_coords_
#define mpi_cart_create_		mpi_cart_create_
#define mpi_cart_get_			mpi_cart_get_
#define mpi_cart_map_			mpi_cart_map_
#define mpi_cart_rank_			mpi_cart_rank_
#define mpi_cart_shift_			mpi_cart_shift_
#define mpi_cart_sub_			mpi_cart_sub_
#define mpi_cartdim_get_		mpi_cartdim_get_
#define mpi_close_port_			mpi_close_port_
#define mpi_comm_accept_		mpi_comm_accept_
#define mpi_comm_compare_		mpi_comm_compare_
#define mpi_comm_connect_		mpi_comm_connect_
#define mpi_comm_create_		mpi_comm_create_
#define mpi_comm_create_errhandler_	mpi_comm_create_errhandler_
#define mpi_comm_create_keyval_		mpi_comm_create_keyval_
#define mpi_comm_delete_attr_		mpi_comm_delete_attr_
#define mpi_comm_disconnect_		mpi_comm_disconnect_
#define mpi_comm_dup_			mpi_comm_dup_
#define mpi_comm_free_			mpi_comm_free_
#define mpi_comm_free_keyval_		mpi_comm_free_keyval_
#define mpi_comm_get_attr_		mpi_comm_get_attr_
#define mpi_comm_get_errhandler_	mpi_comm_get_errhandler_
#define mpi_comm_get_name_		mpi_comm_get_name_
#define mpi_comm_get_parent_		mpi_comm_get_parent_
#define mpi_comm_group_			mpi_comm_group_
#define mpi_comm_join_			mpi_comm_join_
#define mpi_comm_rank_			mpi_comm_rank_
#define mpi_comm_remote_group_		mpi_comm_remote_group_
#define mpi_comm_remote_size_		mpi_comm_remote_size_
#define mpi_comm_set_attr_		mpi_comm_set_attr_
#define mpi_comm_set_errhandler_	mpi_comm_set_errhandler_
#define mpi_comm_set_name_		mpi_comm_set_name_
#define mpi_comm_size_			mpi_comm_size_
#define mpi_comm_spawn_			mpi_comm_spawn_
#define mpi_comm_spawn_multiple_	mpi_comm_spawn_multiple_
#define mpi_comm_split_			mpi_comm_split_
#define mpi_comm_test_inter_		mpi_comm_test_inter_
#define mpi_dims_create_		mpi_dims_create_
#define mpi_errhandler_f2c_             mpi_errhandler_f2c_
#define mpi_errhandler_create_		mpi_errhandler_create_
#define mpi_errhandler_c2f_             mpi_errhandler_c2f_
#define mpi_errhandler_free_		mpi_errhandler_free_
#define mpi_errhandler_get_		mpi_errhandler_get_
#define mpi_errhandler_set_		mpi_errhandler_set_
#define mpi_error_class_		mpi_error_class_
#define mpi_error_string_		mpi_error_string_
#define mpi_free_mem_			mpi_free_mem_
#define mpi_finalize_			mpi_finalize_
#define mpi_finalized_			mpi_finalized_
#define mpi_gather_			mpi_gather_
#define mpi_gatherv_			mpi_gatherv_
#define mpi_get_			mpi_get_
#define mpi_get_address_		mpi_get_address_
#define mpi_get_count_			mpi_get_count_
#define mpi_get_elements_		mpi_get_elements_
#define mpi_get_processor_name_		mpi_get_processor_name_
#define mpi_get_version_		mpi_get_version_
#define mpi_graph_create_		mpi_graph_create_
#define mpi_graph_get_			mpi_graph_get_
#define mpi_graph_map_			mpi_graph_map_
#define mpi_graph_neighbors_		mpi_graph_neighbors_
#define mpi_graph_neighbors_count_	mpi_graph_neighbors_count_
#define mpi_graphdims_get_		mpi_graphdims_get_
#define mpi_group_compare_		mpi_group_compare_
#define mpi_group_difference_		mpi_group_difference_
#define mpi_group_excl_			mpi_group_excl_
#define mpi_group_free_			mpi_group_free_
#define mpi_group_incl_			mpi_group_incl_
#define mpi_group_intersection_		mpi_group_intersection_
#define mpi_group_range_excl_		mpi_group_range_excl_
#define mpi_group_range_incl_		mpi_group_range_incl_
#define mpi_group_rank_			mpi_group_rank_
#define mpi_group_size_			mpi_group_size_
#define mpi_group_translate_ranks_	mpi_group_translate_ranks_
#define mpi_group_union_		mpi_group_union_
#define mpi_ibsend_			mpi_ibsend_
#define mpi_info_create_		mpi_info_create_
#define mpi_info_delete_		mpi_info_delete_
#define mpi_info_dup_			mpi_info_dup_
#define mpi_info_free_			mpi_info_free_
#define mpi_info_get_			mpi_info_get_
#define mpi_info_get_nkeys_		mpi_info_get_nkeys_
#define mpi_info_get_nthkey_		mpi_info_get_nthkey_
#define mpi_info_get_valuelen_		mpi_info_get_valuelen_
#define mpi_info_set_			mpi_info_set_
#define mpi_init_			mpi_init_
#define mpi_init_thread_		mpi_init_thread_
#define mpi_initialized_		mpi_initialized_
#define mpi_intercomm_create_		mpi_intercomm_create_
#define mpi_intercomm_merge_		mpi_intercomm_merge_
#define mpi_iprobe_			mpi_iprobe_
#define mpi_irecv_			mpi_irecv_
#define mpi_irsend_			mpi_irsend_
#define mpi_is_thread_main_		mpi_is_thread_main_
#define mpi_isend_			mpi_isend_
#define mpi_issend_			mpi_issend_
#define mpi_keyval_create_		mpi_keyval_create_
#define mpi_keyval_free_		mpi_keyval_free_
#define mpi_lookup_name_		mpi_lookup_name_
#define mpi_op_create_			mpi_op_create_
#define mpi_op_free_			mpi_op_free_
#define mpi_open_port_			mpi_open_port_
#define mpi_pack_			mpi_pack_
#define mpi_pack_size_			mpi_pack_size_
#define mpi_pcontrol_			mpi_pcontrol_
#define mpi_probe_			mpi_probe_
#define mpi_publish_name_		mpi_publish_name_
#define mpi_put_			mpi_put_
#define mpi_query_thread_		mpi_query_thread_
#define mpi_recv_			mpi_recv_
#define mpi_recv_init_			mpi_recv_init_
#define mpi_reduce_			mpi_reduce_
#define mpi_reduce_scatter_		mpi_reduce_scatter_
#define mpi_request_free_		mpi_request_free_
#define mpi_rsend_			mpi_rsend_
#define mpi_rsend_init_			mpi_rsend_init_
#define mpi_scan_			mpi_scan_
#define mpi_scatter_			mpi_scatter_
#define mpi_scatterv_			mpi_scatterv_
#define mpi_send_			mpi_send_
#define mpi_send_init_			mpi_send_init_
#define mpi_sendrecv_			mpi_sendrecv_
#define mpi_sendrecv_replace_		mpi_sendrecv_replace_
#define mpi_ssend_			mpi_ssend_
#define mpi_ssend_init_			mpi_ssend_init_
#define mpi_start_			mpi_start_
#define mpi_startall_			mpi_startall_
#define mpi_test_			mpi_test_
#define mpi_test_cancelled_		mpi_test_cancelled_
#define mpi_testall_			mpi_testall_
#define mpi_testany_			mpi_testany_
#define mpi_testsome_			mpi_testsome_
#define mpi_topo_test_			mpi_topo_test_
#define mpi_type_commit_		mpi_type_commit_
#define mpi_type_contiguous_		mpi_type_contiguous_
#define mpi_type_count_			mpi_type_count_
#define mpi_type_create_darray_		mpi_type_create_darray_
#define mpi_type_create_hindexed_	mpi_type_create_hindexed_
#define mpi_type_create_hvector_	mpi_type_create_hvector_
#define mpi_type_create_keyval_		mpi_type_create_keyval_
#define mpi_type_create_resized_	mpi_type_create_resized_
#define mpi_type_create_struct_		mpi_type_create_struct_
#define mpi_type_create_subarray_	mpi_type_create_subarray_
#define mpi_type_delete_attr_		mpi_type_delete_attr_
#define mpi_type_dup_			mpi_type_dup_
#define mpi_type_extent_		mpi_type_extent_
#define mpi_type_free_			mpi_type_free_
#define mpi_type_free_keyval_		mpi_type_free_keyval_
#define mpi_type_get_attr_		mpi_type_get_attr_
#define mpi_type_get_contents_		mpi_type_get_contents_
#define mpi_type_get_envelope_		mpi_type_get_envelope_
#define mpi_type_get_extent_		mpi_type_get_extent_
#define mpi_type_get_name_		mpi_type_get_name_
#define mpi_type_get_true_extent_	mpi_type_get_true_extent_
#define mpi_type_hindexed_		mpi_type_hindexed_
#define mpi_type_hvector_		mpi_type_hvector_
#define mpi_type_indexed_		mpi_type_indexed_
#define mpi_type_lb_			mpi_type_lb_
#define mpi_type_set_attr_		mpi_type_set_attr_
#define mpi_type_set_name_		mpi_type_set_name_
#define mpi_type_size_			mpi_type_size_
#define mpi_type_struct_		mpi_type_struct_
#define mpi_type_ub_			mpi_type_ub_
#define mpi_type_vector_		mpi_type_vector_
#define mpi_unpack_			mpi_unpack_
#define mpi_unpublish_name_		mpi_unpublish_name_
#define mpi_wait_			mpi_wait_
#define mpi_waitall_			mpi_waitall_
#define mpi_waitany_			mpi_waitany_
#define mpi_waitsome_			mpi_waitsome_
#define mpi_win_complete_		mpi_win_complete_
#define mpi_win_create_			mpi_win_create_
#define mpi_win_create_errhandler_	mpi_win_create_errhandler_
#define mpi_win_create_keyval_		mpi_win_create_keyval_
#define mpi_win_delete_attr_		mpi_win_delete_attr_
#define mpi_win_fence_			mpi_win_fence_
#define mpi_win_free_			mpi_win_free_
#define mpi_win_free_keyval_		mpi_win_free_keyval_
#define mpi_win_get_attr_		mpi_win_get_attr_
#define mpi_win_get_errhandler_		mpi_win_get_errhandler_
#define mpi_win_get_group_		mpi_win_get_group_
#define mpi_win_get_name_		mpi_win_get_name_
#define mpi_win_post_			mpi_win_post_
#define mpi_win_set_attr_		mpi_win_set_attr_
#define mpi_win_set_errhandler_		mpi_win_set_errhandler_
#define mpi_win_set_name_		mpi_win_set_name_
#define mpi_win_start_			mpi_win_start_
#define mpi_win_wait_			mpi_win_wait_
#define mpi_wtick_			mpi_wtick_
#define mpi_wtime_			mpi_wtime_

#define mpil_comm_gps_			mpil_comm_gps_
#define mpil_comm_id_			mpil_comm_id_
#define mpil_comm_parent_		mpil_comm_parent_
#define mpil_signal_			mpil_signal_
#define mpil_spawn_			mpil_spawn_
#define mpil_type_id_			mpil_type_id_

#endif /* not LAM_PROFILELIB */

#define mpi_dup_fn_			mpi_dup_fn_
#define mpi_comm_dup_fn_		mpi_comm_dup_fn_
#define mpi_type_dup_fn_		mpi_type_dup_fn_
#define mpi_win_dup_fn_			mpi_win_dup_fn_
#define mpi_null_copy_fn_		mpi_null_copy_fn_
#define mpi_null_delete_fn_		mpi_null_delete_fn_
#define mpi_comm_null_copy_fn_		mpi_comm_null_copy_fn_
#define mpi_comm_null_delete_fn_	mpi_comm_null_delete_fn_
#define mpi_type_null_copy_fn_		mpi_type_null_copy_fn_
#define mpi_type_null_delete_fn_	mpi_type_null_delete_fn_
#define mpi_win_null_copy_fn_		mpi_win_null_copy_fn_
#define mpi_win_null_delete_fn_		mpi_win_null_delete_fn_

#define mpi_bottom_			mpi_bottom_
#define mpi_argv_null_			mpi_argv_null_
#define mpi_argvs_null_			mpi_argvs_null_
#define mpi_errcodes_ignore_		mpi_errcodes_ignore_
#define mpi_status_ignore_		mpi_status_ignore_
#define mpi_statuses_ignore_		mpi_statuses_ignore_

#define xmpi_buoy_			xmpi_buoy_
#define xmpi_coloron_			xmpi_coloron_
#define xmpi_coloroff_			xmpi_coloroff_

#endif /* LAM_FORTRANUNDERSCORE */

/*
 * LAM MPI F77 external functions
 */
#ifdef __cplusplus
extern "C" {
#endif

extern void		MPI_F_DUP_FN();
extern void		MPI_F_COMM_DUP_FN();
extern void		MPI_F_TYPE_DUP_FN();
extern void		MPI_F_WIN_DUP_FN();

extern void		mpi_null_copy_fn_();
extern void		mpi_null_delete_fn_();
extern void		mpi_comm_null_copy_fn_();
extern void		mpi_comm_null_delete_fn_();
extern void		mpi_type_null_copy_fn_();
extern void		mpi_type_null_delete_fn_();
extern void		mpi_win_null_copy_fn_();
extern void		mpi_win_null_delete_fn_();

#ifdef __cplusplus
}
#endif

#endif	/* _MPISYS_F77_H */
