/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	$Id: show_version.c,v 1.3 2000/09/20 05:15:03 jsquyres Exp $
 * 
 *	Function:	- show the version of LAM/MPI
 *
 */

#include <lam_config.h>

#include <stdio.h>

#include <etc_misc.h>

void
lam_show_version(int verbose)
{
  printf("\nLAM %s", LAM_VERSION);
#if LAM_WANT_IMPI
  printf("/IMPI");
#endif
#if LAM_WANT_MPI2CPP
  printf("/MPI 2 C++");
#endif
#if LAM_WANT_ROMIO
  printf("/ROMIO");
#endif
  printf(" - University of Notre Dame\n\n");
  if (verbose == 1) {
    printf("\tArch:\t\t%s\n", LAM_ARCH);
    printf("\tRPI:\t\t%s\n", LAM_RPI);
  }
}
