/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD
 *
 *	$Id: getinetaddr.c,v 1.1 2000/02/08 09:32:33 jsquyres Exp $
 * 
 *	Function:	- return the machine Internet address (OTB only)
 *			- address is a 4-byte array
 *	Accepts:	- machine name
 *			- 4-byte machine address (returned value)
 *	Returns:	- 0 or ERROR
 */

#include <string.h>

#include <netdb.h>
#include <portable.h>
#include <terror.h>
#include <typical.h>

int
getinetaddr(hostname, hostaddr)

char			*hostname;
unsigned char		*hostaddr;

{
	struct hostent	*p;
/*
 * Get host name entry.
 */
	p = gethostbyname(hostname);

	if (p == 0) {
		errno = EBADHOST;
		return(LAMERROR);
	}
/*
 * Copy the 4-byte Internet address.
 */
	if (p->h_length == 4) {
		memcpy((char *) hostaddr, p->h_addr, 4);
	}
/*
 * Not an Internet address.  Do nothing for now, it's an error.
 */
	else {
		errno = EINVAL;
		return(LAMERROR);
	}

	return(0);
}
