/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log: trillium.c,v $
 *	Revision 6.2  1999/06/12 17:11:37  kmeyer1
 *	added copyright
 *	
 *	Revision 6.1  1996/11/23 18:45:24  nevin
 *	Ohio Release
 *	
 * Revision 6.0  96/02/29  13:32:16  gdburns
 * Ohio Release
 * 
 *	Function:	- internal client access to local servers
 */

#include <portable.h>
#include <preq.h>
#include <t_types.h>
#include <typical.h>
#include <terror.h>

/*
 * external functions
 */
extern char		*flforget();
extern int		*pdoom();

/*
 *	rforget
 *
 *	Function:	- translates tag to address
 *	Accepts:	- server node ID (not used, always local)
 *			- flag tag
 *	Returns:	- address or 0
 */
char
*rforget(nodeid, tag)

int4			nodeid;
int4			tag;

{
	return(flforget(tag));
}

/*
 *	rpdoom
 *
 *	Function:	- delivers a signal to kenyad process(es)
 *	Accepts:	- server node ID (not used, always local)
 *			- process selection method
 *			- selection value
 *			- signal number
 *	Returns:	- 0 or ERROR
 */
int
rpdoom(nodeid, flags, value, sig)

int4			nodeid;
int4			flags;
int4			value;
int4			sig;

{
	struct preq	request;	/* kenya request */
	struct preply	reply;		/* kenya reply */

	request.pq_sel_method = flags;
	request.pq_sel_value = value;
	request.pq_signal = sig;

	pdoom(&request, &reply);

	if (reply.pr_reply) {
		errno = ttol(reply.pr_reply);
		return(LAMERROR);
	} else {
		return(0);
	}
}
