/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1994 The Ohio State University
 *	GDB
 *
 *	$Id: nrecv.c,v 6.3 1999/09/10 05:19:28 jsquyres Exp $
 * 
 *	Function:	- receives a buffered network message
 *	Accepts:	- ptr to network message descriptor
 *	Returns:	- 0 or ERROR
 */

#include <lam_config.h>

#include <bfreq.h>
#include <events.h>
#include <net.h>

int
nrecv(nhead)

struct nmsg		*nhead;

{
	struct bfreq	*req;		/* bufferd request */
	struct nmsg	bfhead;		/* bufferd message */

	if (!(nhead->nh_flags & NOBUF)) {
		LAM_ZERO_ME(bfhead);
		req = (struct bfreq *) bfhead.nh_data;
		req->bfq_req = BFQRECV;
		req->bfq_event = nhead->nh_event;
		req->bfq_type = nhead->nh_type;
		bfhead.nh_dl_event = EVBUFFERD;
		bfhead.nh_node = LOCAL;
		bfhead.nh_event = EVBUFFERD;
		bfhead.nh_type = DLCTL;
		bfhead.nh_flags = 0;
		bfhead.nh_length = 0;
		bfhead.nh_msg = 0;

		return(dsfr(&bfhead, nhead));
	} else {
		return(frecv(nhead));
	}
}
