/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB
 *
 *	$Id: filed.h,v 6.3 1999/06/12 17:11:28 kmeyer1 Exp $
 *
 *	Function:	- general templates and contants used by filed
 */

#ifndef _FILED_H
#define _FILED_H

#include <portable.h>

/*
 * Trollius file descriptor
 */
struct fdesc {
	int4		f_tfd;		/* Trollius file descriptor */
	int4		f_fd;		/* Unix file descriptor */
	int4		f_ptr;		/* current pointer within file */
	int4		f_tflags;	/* Trollius peculiar flags */
	int4		f_flags;	/* Unix flags */
	int4		f_flow;		/* total data flow */
	int4		f_count;	/* open count O_REUSE */
	int4		f_src_node;	/* last client's node */
	int4		f_src_event;	/* last client's event */
	char		*f_name;	/* file name */
	struct fdesc	*f_next;	/* next entry in file desc. list */
	struct fdesc	*f_prev;	/* previous entry in file desc. list */
};

/*
 * nulls
 */
#define FDNULL		((struct fdesc *) 0)

/*
 * limits
 */
#define ACTIVEMAX	64		/* filed's open descriptors */

/*
 * codes
 */
#define FMT		'f'		/* formatted F77 file */
#define UFMT		'u'		/* unformatted F77 file */


#ifndef __ARGS
#if __STDC__ || defined(c_plusplus) || defined(__cplusplus)
#define __ARGS(a)	a
#else
#define __ARGS(a)	()
#endif
#endif

/*
 * prototypes
 */
#ifdef __cplusplus
extern "C" {
#endif

extern int	fdlock __ARGS((struct fdesc *));

#ifdef __cplusplus
}
#endif

#endif	/* _FILED_H */
