/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB
 *
 *	$Id: do_load.c,v 6.3 1999/06/12 17:11:26 kmeyer1 Exp $
 * 
 *	Function:	- UDP Internet datalink output
 *			- loads output link information
 */

#include <stdlib.h>

#include <dl_inet.h>
#include <events.h>
#include <kreq.h>
#include <portable.h>
#include <terror.h>

/*
 * external variables
 */
extern struct dolink	*dolinks;	/* link table */
extern int		dol_cnt;	/* dol table length */
extern int		do_fault;	/* watch for faulty links */

/*
 * local variables
 */
static int4		config[3];	/* configuration parameters */

/*
 * global functions
 */
void			(*(do_loadinit()))();
void			(*(do_loadlinks()))();

/*
 * external functions
 */
extern void		(*(do_init2()))();

/*
 *	do_loadinit
 *
 *	Function:	- initializes the link table
 *			- receives neighbour link info from dli
 *			- blocks on a special event until info is received
 */
void (*(
do_loadinit()))()

{
	struct kmsg	khead;		/* kernel message desc. */

	khead.k_event = EVDLOINIT;
	khead.k_type = 0;
	khead.k_flags = 0;
	khead.k_length = sizeof(config);
	khead.k_msg = (char *) config;
/*
 * Receive the length of the link array.
 */
	if (krecv(&khead)) lampanic("dlo_inet (krecv)");

	return((void (*)()) do_loadlinks);
}

/*
 *	do_loadlinks
 *
 *	Function:	- loads link information from dli
 */
void (*(
do_loadlinks()))()

{
	struct kmsg	khead;			/* kernel message desc. */

	dol_cnt = (int) config[0];
	do_fault = (int) config[2];

	khead.k_event = EVDLOINIT;
	khead.k_type = 0;
	khead.k_flags = 0;
	khead.k_length = dol_cnt * sizeof(struct dolink);

	dolinks = (struct dolink *) malloc((unsigned) khead.k_length);
	if (!dolinks) lampanic("dlo_inet (malloc)");

	khead.k_msg = (char *) dolinks;
/*
 * Receive the neighbour link information.
 */
	if (krecv(&khead)) lampanic("dlo_inet (krecv)");

	return(do_init2());
}
