/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB
 *
 *	$Id: bforward.c,v 1.3 2000/03/15 21:52:12 jsquyres Exp $
 * 
 *	Function:	- bforward, henchman of bufferd
 *			- forwards remote messages for bufferd
 */

#include <lam_config.h>

#include <string.h>

#include <bfreq.h>
#include <events.h>
#include <net.h>
#include <rreq.h>
#include <terror.h>

/*
 * local variables
 */
static char		buf[MAXNMSGLEN];
static struct nmsg	nhead;			/* network message */

/*
 * local functions
 */
static void		bwrecv();

/*
 * global functions
 */
void			(*(bw_init()))();
void			(*(bforward()))();

/*
 *	bw_init
 *
 *	Function:	- bforward initialization
 */
void (*(
bw_init()))()

{
/*
 * Receive first request.
 */
	LAM_ZERO_ME(nhead);
	memset((void*) buf, -1, MAXNMSGLEN);

	bwrecv();
	return((void (*)()) bforward);
}

/*
 *	bforward
 *
 *	Function:	- server loop
 *			- forwards message & receives next message
 */
void
(*(bforward()))()

{
/*
 * Don't forward the KTRY, DDLI or KTRACE flags.
 */
	nhead.nh_flags &= ~(KTRY | DDLI | KTRACE);

	if (getroute(&nhead)) lampanic("bforward (getroute)");

	if (dsend(&nhead)) lampanic("bforward (dsend)");
/*
 * Receive next message.
 */
	bwrecv();
	return((void (*)()) bforward);
}

/*
 *	bwrecv
 *
 *	Function:	- receives a message from bufferd
 */
static void
bwrecv()

{
	nhead.nh_event = EVBFORWARD;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = MAXNMSGLEN;
	nhead.nh_msg = buf;

	if (bfrecv(&nhead)) lampanic("bforward (bfrecv)");
}
