/***************************************************************************
                          kxmleditorpart.cpp  -  description
                             -------------------
    begin                : Wed Sep 19 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : OleBowle@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxmleditorpart.h"
#include "kxmleditorfactory.h"

#include "kxe_viewelement.h"
#include "kxe_viewprocinstr.h"
#include "kxe_treeviewitem.h"
#include "dlgconfiguration.h"
#include "dlgsearch.h"
#include "dlgxmlelement.h"
#include "dlgxmlprocinstr.h"
#include "dlgxmlchardata.h"
#include "actions.h"
#include "qdom_add.h"

#include <kinstance.h>
#include <kdebug.h>
#include <klocale.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kpopupmenu.h>
#include <kiconloader.h>
#include <kmessagebox.h>

#include <qsplitter.h>
#include <qtabwidget.h>
#include <qmultilinedit.h>
#include <qfile.h>
#include <qtextstream.h>

#include "dcopiface_part_ro.h" // DCOP Iface

KXMLEditorPart::KXMLEditorPart( bool fReadWrite, QWidget * pParent, const char * pszName )
	: KParts::ReadWritePart(pParent,pszName),
	  m_pDoc( new QDomDocument() ),
	  m_pDlgSearch(0)
{
	//////////////////////////////
	// INIT PART
	//////////////////////////////

	setInstance( KXMLEditorFactory::instance() );

	new KXMLEditorBrowserExtension( this, "KXMLEditorPart browser extension" );

	//////////////////////////////
	// CREATE ACTIONS
	//////////////////////////////

	// edit actions
	m_pActEditFind = KStdAction::find( this, SLOT(slotEditFind()), actionCollection(), "find" );
	m_pActEditFindNext = KStdAction::findNext( this, SLOT(slotEditFindNext()), actionCollection(), "findNext" );
	m_pActEditDeselect = new KAction( i18n("&Deselect Node"), 0, this,
	                                SLOT(slotEditDeselect()), actionCollection(), "deselect" );

	// view actions
	m_pActViewNodeUp = new KAction( i18n("To &Parent Node"), "up", 0, this,
	                                SLOT(slotViewNodeUp()), actionCollection(), "treeitem_up" );

	m_pActViewExpNode = new KToolBarPopupAction( i18n("&Expand Node"), "expand_node", CTRL+Key_Plus, this,
	                                             SLOT(slotViewExpNode()), actionCollection(), "treeitem_expand" );
	KPopupMenu * pMenuExpNode = m_pActViewExpNode->popupMenu();
	connect( pMenuExpNode, SIGNAL(activated(int)), this, SLOT(slotViewExpNode(int)) );
	for ( uint i = 1; i <= 8; i++ )
		pMenuExpNode->insertItem( i18n("Expand to level %1").arg(i), i-1 );

	m_pActViewColNode = new KToolBarPopupAction( i18n("&Collapse Node"), "collapse_node", CTRL+Key_Minus, this,
	                                             SLOT(slotViewColNode()), actionCollection(), "treeitem_collapse" );
	KPopupMenu * pMenuColNode = m_pActViewColNode->popupMenu();
	connect( pMenuColNode, SIGNAL(activated(int)), this, SLOT(slotViewColNode(int)) );
	for ( uint i = 0; i <= 7; i++ )
		pMenuColNode->insertItem( i18n("Collapse to level %1").arg(i), i );

	// bookmark actions
	m_pActBookmarksToggle = new KAction( i18n("&Toggle Bookmark"), "bookmark_add", CTRL+Key_B, this,
	                                   SLOT(slotBookmarksToggle()), actionCollection(), "bookmark_toggle" );
	m_pActBookmarksPrev = new KAction( i18n("&Previous Bookmark"), "bookmark_prev", SHIFT+Key_F5, this,
	                                   SLOT(slotBookmarksPrev()), actionCollection(), "bookmark_prev" );
	m_pActBookmarksNext = new KAction( i18n("&Next Bookmark"), "bookmark_next", Key_F5, this,
	                                   SLOT(slotBookmarksNext()), actionCollection(), "bookmark_next" );

	// settings actions
	new KAction( i18n("&Configure KXMLEditor..."), "configure", 0, this,
	             SLOT (slotConfigure()), actionCollection(), "configure" );

	// path toolbar
	m_pActPathCombo = new KXmlEditorComboAction( i18n("Path Bar"), 0, this,
	                                             SLOT(slotPathSelected(const QString &)), actionCollection(), "path_combo" );
	new KAction( i18n("Clear Path bar"), BarIcon("locationbar_erase", 16), 0, this,
	             SLOT(slotPathClear()), actionCollection(), "path_clear" );
	new KXmlEditorLabelAction( i18n("&Path "), actionCollection(), "path_label");

	setXMLFile( "kxmleditorpartBrowseUI.rc", true );

	if ( fReadWrite )
	{
		new KAction( i18n("&Insert element"), "xml_insert_element", CTRL+Key_E, this, SLOT(slotXmlElementInsert()), actionCollection(), "xml_ins_element" );
		new KAction( i18n("&Edit element"), "xml_edit_element", 0, this, SLOT(slotXmlElementEdit()), actionCollection(), "xml_edit_element" );
		new KAction( i18n("&Delete element"), "xml_delete_element", 0, this, SLOT(slotXmlElementDelete()), actionCollection(), "xml_del_element" );

		new KAction( i18n("Insert proc. instruction"), "xml_insert_procins", CTRL+Key_R, this, SLOT(slotXmlProcInstrInsert()), actionCollection(), "xml_ins_procins" );
		new KAction( i18n("Edit proc. instruction"), "xml_edit_procins", 0, this, SLOT(slotXmlProcInstrEdit()), actionCollection(), "xml_edit_procins" );
		new KAction( i18n("Delete proc. instruction"), "xml_delete_procins", 0, this, SLOT(slotXmlProcInstrDelete()), actionCollection(), "xml_del_procins" );

		new KAction(i18n("Insert character data"), "xml_insert_contents", CTRL+Key_T, this, SLOT(slotXmlCharDataInsert()), actionCollection(), "xml_ins_contents");
		new KAction(i18n("Edit character data"), "xml_edit_contents", 0, this, SLOT(slotXmlCharDataEdit()), actionCollection(), "xml_edit_contents");
		new KAction(i18n("Delete character data"), "xml_delete_contents", 0, this, SLOT(slotXmlCharDataDelete()), actionCollection(), "xml_del_contents");

		setXMLFile( "kxmleditorpartEditUI.rc", true );
	}

	//////////////////////////////
	// CREATE WIDGETS
	//////////////////////////////

	QSplitter * pSplitter = new QSplitter( pParent, "KXMLEditorPart main widget (Splitter)" );
	pSplitter->setFocusPolicy( QWidget::StrongFocus );
	setWidget( pSplitter );

	// create configuration dialog -------------
	m_pDlgConfiguration = new DlgConfiguration(pSplitter);
	m_pDlgConfiguration->readConfiguration( instance()->config() );
	connect( m_pDlgConfiguration, SIGNAL(configurationChanged( const DlgConfiguration * const)), this, SLOT(slotConfigurationChanged()) );

	// create the tree view -------------------
	m_pViewTree = new KXE_TreeView( this, pSplitter, "KXMLEditorPart treeview" );

	connect( m_pViewTree, SIGNAL(sigSelectionChanged(const QDomElement &)), this, SLOT(slotSelectionChanged(const QDomElement &)) );
	connect( m_pViewTree, SIGNAL(sigSelectionChanged(const QDomCharacterData &)), this, SLOT(slotSelectionChanged(const QDomCharacterData &)) );
	connect( m_pViewTree, SIGNAL(sigSelectionChanged(const QDomProcessingInstruction &)), this, SLOT(slotSelectionChanged(const QDomProcessingInstruction &)) );
	connect( m_pDlgConfiguration, SIGNAL(configurationChanged( const DlgConfiguration * const)), m_pViewTree, SLOT(slotConfigurationChanged( const DlgConfiguration * const)) );

	// create tab widget ----------------------
	m_pTabWidget = new QTabWidget( pSplitter, "KXMLEditorPart tabwidget");

	// create element view
	m_pViewElement = new KXE_ViewElement( m_pTabWidget, "KXMLEditorPart element view" );
	m_pTabWidget->addTab( m_pViewElement, g_iconElement, i18n("Element") );

	// create edit widget, that display XML contents
	m_pViewContents = new QMultiLineEdit( m_pTabWidget, "KXMLEditorPart contents view" );
	m_pTabWidget->addTab( m_pViewContents, g_iconText, i18n("Contents") );
	m_pViewContents->setReadOnly(true);

	// create proc.instr. view
	m_pViewProcInstr = new KXE_ViewProcInstr( m_pTabWidget, "KXMLEditorPart proc.instr. view" );
	m_pTabWidget->addTab( m_pViewProcInstr, g_iconProcessingInstruction, i18n("Proc.Instruction") );

	connect( this, SIGNAL(started(KIO::Job*)), this, SLOT(started()) );
	connect( this, SIGNAL(completed()), this, SLOT(completed()) );
	connect( this, SIGNAL(canceled(const QString &)), this, SLOT(canceled()) );

	//////////////////////////////
	// INIT BEGIN STATE
	//////////////////////////////

	// Disable actions
	m_pActEditFindNext->setEnabled(false);
	m_pActEditDeselect->setEnabled(false);
	m_pActViewNodeUp->setEnabled(false);
	m_pActViewExpNode->setEnabled(false);
	m_pActViewColNode->setEnabled(false);
	m_pActBookmarksToggle->setEnabled(false);
	m_pActBookmarksPrev->setEnabled(false);
	m_pActBookmarksNext->setEnabled(false);

	m_pTabWidget->setTabEnabled( m_pViewElement, false );
	m_pTabWidget->setTabEnabled( m_pViewContents, false );
	m_pTabWidget->setTabEnabled( m_pViewProcInstr, false );

	setReadWrite(fReadWrite);

	// use configuration
	m_pViewTree->slotConfigurationChanged( m_pDlgConfiguration );

	//////////////////////////////
	// INIT DCOP object (if any)
	//////////////////////////////
	//m_pDCOPIface = NULL;
	//m_pDCOPIface = new KXMLEditorPartIfaceReadOnly(this);
	m_pDCOPIface = new KXMLEditorPartIfaceReadWrite(this); // temporarly to test openUrl
}

KXMLEditorPart::~KXMLEditorPart()
{
	if (m_pDCOPIface)
		delete m_pDCOPIface;

	delete m_pDoc;
}


/////////////////////////////////////////////////////////////////////
//                   KPART FUNCTIONALITY
/////////////////////////////////////////////////////////////////////

bool KXMLEditorPart::openFile()
{
	if ( isModified() )
	{
		kdDebug() << "KXMLEditorPart::openFile the current document is modified." << endl;
		return false;
	}

	// ( 1.) parse the file and fill our document
	QFile file(m_file);

	if ( ! file.open(IO_ReadOnly) )
	{
		kdDebug() << "KXMLEditorPart::openFile: Can't open file." << endl;
		return false;
	}

	QTextStream txtStreamLocal( & file );
	txtStreamLocal.setEncoding(QTextStream::Locale);
	QString strFileContents = txtStreamLocal.read();
	file.close();

  //-- Set string with XML to QDomDocument ------------------------------------------
	QString strErrorMsg;
  int iErrorLine, iErrorColumn;
	QDomDocument * pNewDoc = new QDomDocument; // first try with a new document

 	if( ! pNewDoc->setContent(strFileContents, true, &strErrorMsg, &iErrorLine, &iErrorColumn) )
 		{ kdDebug() << "KXMLEditorPart::openFile: Failed parsing the file." << endl;
 		 	
			KMessageBox::error(0,
												 i18n("%1 in line %2, column %3").arg(strErrorMsg).arg(iErrorLine).arg(iErrorColumn),
												 i18n("Parsing error !"));

			delete pNewDoc; // remove the new document, because it's useless
			return false;
 		}

	delete m_pDoc;    // remove the former document
	m_pDoc = pNewDoc; // and take the new one

	// ( 2.) update the view
	m_pViewTree->slotUpdateClear();
	m_pViewTree->slotUpdateNodeCreated( m_pDoc->documentElement() );

	return true;
}

bool KXMLEditorPart::saveFile()
{
	return false;
}

void KXMLEditorPart::setModified( bool fModified )
{
	static bool fAlreadyModified = false;

	if ( fAlreadyModified != fModified )
	{
		fAlreadyModified = fModified;

		QString szNewCaption = m_url.prettyURL();
		if (fModified)
			szNewCaption += " [" + i18n("modified") + "]";
		emit setWindowCaption( szNewCaption );
	}

	KParts::ReadWritePart::setModified( fModified ); // base functionality
}

void KXMLEditorPart::setReadWrite( bool fReadWrite )
{
	m_pViewTree->setReadWrite(fReadWrite);
	m_pViewElement->setReadWrite(fReadWrite);
	m_pViewProcInstr->setReadWrite(fReadWrite);
	m_pViewContents->setReadOnly( ! fReadWrite );
}

void KXMLEditorPart::started()
{
	kdDebug() << "KXMLEditorPart::started" << endl;
}
void KXMLEditorPart::completed()
{
	kdDebug() << "KXMLEditorPart::completed" << endl;
}
void KXMLEditorPart::canceled()
{
	kdDebug() << "KXMLEditorPart::canceled" << endl;
}


/////////////////////////////////////////////////////////////////////
//                     ACTION SLOTS
/////////////////////////////////////////////////////////////////////

void KXMLEditorPart::slotEditFind()
{
	emit setStatusBarText( i18n("Search in XML tree ...") );

	if ( ! m_pDlgSearch )
	{
		m_pDlgSearch = new DlgSearch( widget(), "search dialog", true );
	}

	if ( m_pDlgSearch->exec() == DlgSearch::Accepted )
		slotEditFindNext();

	m_pActEditFindNext->setEnabled(true);

	emit setStatusBarText( i18n("Ready.") );
}

void KXMLEditorPart::slotEditFindNext()
{
	emit setStatusBarText( i18n("Search in XML tree ...") );

	if ( ! m_pDlgSearch )
	{
		kdDebug() << "KXMLEditorPart::slotEditFindNext implementation error - no search dialog" << endl;
		emit setStatusBarText( i18n("Ready.") );
		return;
	}

	// get node to start with (either the next node of the item selected at the tree view or documents root node)
	QDomNode node = ( (m_pViewTree->getSelectedNode()) && (! m_pViewTree->getSelectedNode()->isNull()) ) ? domTool_nextNode(* m_pViewTree->getSelectedNode()) : m_pDoc->documentElement();

	// start testing til the last node
	while( ! node.isNull() )
	{
		if ( domTool_match( node, m_pDlgSearch ) )
		{
			m_pViewTree->selectNode(node);
			emit setStatusBarText( i18n("Ready.") );
			return;
		}
		
		node = domTool_nextNode(node);
	}

	emit setStatusBarText( i18n("Ready.") );
}

void KXMLEditorPart::slotEditDeselect()
{
	// Enable/Disable actions
	m_pActEditDeselect->setEnabled(false);
	m_pActViewNodeUp->setEnabled(false); // disable if it's a root item
	m_pActViewExpNode->setEnabled(false);
	m_pActViewColNode->setEnabled(false);
	m_pActBookmarksToggle->setEnabled(false);

	m_pActPathCombo->slotClearEdit();

	// change views
	m_pViewTree->slotEditDeselect();

	m_pViewContents->clear();

	m_pTabWidget->setTabEnabled( m_pViewElement, false );
	m_pTabWidget->setTabEnabled( m_pViewContents, false );
	m_pTabWidget->setTabEnabled( m_pViewProcInstr, false );

	m_pTabWidget->showPage( m_pViewContents );

	// change path combo
	m_pActPathCombo->slotClearEdit();
}

void KXMLEditorPart::slotXmlElementInsert()
{
	if ( ! isReadWrite() )
	{
		kdError() << "KXMLEditorPart::slotXmlElementInsert called in readonly mode." << endl;
		return;
	}

	emit setStatusBarText( i18n("Inserting XML element into document...") );

	DlgXMLElement dlg( widget(), "XML element dialog" );
	int iDlgReturn = QDialog::Rejected;
	QDomElement domElement = m_pDoc->createElement( QString() );

	if ( m_pDoc->documentElement().isNull() ) // the document doesn't
	{                                         // have a root element
		iDlgReturn = dlg.exec( * m_pDoc, domElement );
	}
	else  // the document seems to
	{     // have a root element
		QDomNode * pNode = m_pViewTree->getSelectedNode();

		if ( (pNode) && (pNode->isElement()) )
		{
			QDomElement domParentElement = pNode->toElement();
			iDlgReturn = dlg.exec( domParentElement, domElement );
		}
		else
			kdError() << "KXMLEditorPart::slotXmlElementInsert no element selected." << endl;
	}

	if ( iDlgReturn == QDialog::Accepted )
	{
		m_pViewTree->slotUpdateNodeCreated(domElement);
		setModified();
	}

	emit setStatusBarText( i18n("Ready.") );
}

void KXMLEditorPart::slotXmlElementEdit()
{
	if ( ! isReadWrite() )
	{
		kdError() << "KXMLEditorPart::slotXmlElementEdit called in readonly mode." << endl;
		return;
	}

	QDomNode * pNode = m_pViewTree->getSelectedNode();
	if ( (!pNode) || (!pNode->isElement()) )
	{
		kdError() << "KXMLEditorPart::slotXmlElementEdit no node selected or selected node is no XML element." << endl;
		return;
	}

	emit setStatusBarText( i18n("Editing XML element...") );

	QDomElement domElement = pNode->toElement();

	DlgXMLElement dlg( widget(), "XML element dialog" );
	if ( dlg.exec( domElement ) == QDialog::Accepted )
	{
		m_pViewTree->slotUpdateNodeChanged(domElement);
		setModified();
	}

	emit setStatusBarText( i18n("Ready.") );
}

void KXMLEditorPart::slotXmlElementDelete()
{
	if ( ! isReadWrite() )
	{
		kdError() << "KXMLEditorPart::slotXmlElementDelete called in readonly mode." << endl;
		return;
	}

	QDomNode * pNode = m_pViewTree->getSelectedNode();
	if ( (!pNode) || (!pNode->isElement()) )
	{
		kdError() << "KXMLEditorPart::slotXmlElementDelete no node selected or selected node is no XML element." << endl;
		return;
	}

	if ( pNode->parentNode().isNull() )
	{
		kdError() << "KXMLEditorPart::slotXmlElementDelete selected nodes parent node is empty." << endl;
		return;
	}

	emit setStatusBarText( i18n("Deleting XML element...") );

	if ( pNode->parentNode().removeChild( *pNode ).isNull() )
		kdError() << "KXMLEditorPart::slotXmlElementDelete error removing the selected node." << endl;
	else
	{
		m_pViewTree->slotUpdateNodeDeleted(*pNode);
		setModified();
	}

	emit setStatusBarText( i18n("Ready.") );
}

void KXMLEditorPart::slotXmlProcInstrInsert()
{
	if ( ! isReadWrite() )
	{
		kdError() << "KXMLEditorPart::slotXmlProcInstrInsert called in readonly mode." << endl;
		return;
	}

	QDomNode * pNode = m_pViewTree->getSelectedNode();
	if ( (!pNode) || (!pNode->isElement()) )
	{
		kdError() << "KXMLEditorPart::slotXmlProcInstrInsert no element selected." << endl;
		return;
	}

	emit setStatusBarText( i18n("Inserting processing instruction into document...") );

	DlgXMLProcInstr dlg( widget(), "proc.instr. dialog" );
	QDomProcessingInstruction domProcInstr;
	QDomElement domParentElement = pNode->toElement();

	if ( dlg.exec( domParentElement, domProcInstr ) == QDialog::Accepted )
	{
		m_pViewTree->slotUpdateNodeCreated(domProcInstr);
		setModified();
	}

	emit setStatusBarText( i18n("Ready.") );
}

void KXMLEditorPart::slotXmlProcInstrEdit()
{
	if ( ! isReadWrite() )
	{
		kdError() << "KXMLEditorPart::slotXmlProcInstrEdit called in readonly mode." << endl;
		return;
	}

	QDomNode * pNode = m_pViewTree->getSelectedNode();
	if ( (!pNode) || (!pNode->isProcessingInstruction()) )
	{
		kdError() << "KXMLEditorPart::slotXmlProcInstrEdit no node selected or selected node is no processing instruction." << endl;
		return;
	}

	emit setStatusBarText( i18n("Editing processing instruction...") );

	QDomProcessingInstruction domProcInstr = pNode->toProcessingInstruction();
	DlgXMLProcInstr dlg( widget(), "proc.instr. dialog" );

	if ( dlg.exec( domProcInstr ) == QDialog::Accepted )
	{
		m_pViewTree->slotUpdateNodeChanged(domProcInstr);
		setModified();
	}

	emit setStatusBarText( i18n("Ready.") );
}

void KXMLEditorPart::slotXmlProcInstrDelete()
{
	if ( ! isReadWrite() )
	{
		kdError() << "KXMLEditorPart::slotXmlProcInstrDelete called in readonly mode." << endl;
		return;
	}

	QDomNode * pNode = m_pViewTree->getSelectedNode();
	if ( (!pNode) || (!pNode->isProcessingInstruction()) )
	{
		kdError() << "KXMLEditorPart::slotXmlProcInstrDelete no node selected or selected node is no processing instruction." << endl;
		return;
	}

	if ( pNode->parentNode().isNull() )
	{
		kdError() << "KXMLEditorPart::slotXmlProcInstrDelete selected nodes parent node is empty." << endl;
		return;
	}

	emit setStatusBarText( i18n("Deleting processing instruction...") );

	if ( pNode->parentNode().removeChild( *pNode ).isNull() )
		kdError() << "KXMLEditorPart::slotXmlProcInstrDelete error removing the selected node." << endl;
	else
	{
		m_pViewTree->slotUpdateNodeDeleted(*pNode);
		setModified();
	}

	emit setStatusBarText( i18n("Ready.") );
}

void KXMLEditorPart::slotXmlCharDataInsert()
{
	if ( ! isReadWrite() )
	{
		kdError() << "KXMLEditorPart::slotXmlCharDataInsert called in readonly mode." << endl;
		return;
	}

	QDomNode * pNode = m_pViewTree->getSelectedNode();
	if ( (!pNode) || (!pNode->isElement()) )
	{
		kdError() << "KXMLEditorPart::slotXmlCharDataInsert no element selected." << endl;
		return;
	}

	emit setStatusBarText( i18n("Inserting character data into document...") );

	DlgXMLCharData dlg( widget(), "char.data dialog" );
	QDomCharacterData domCharData;
	QDomElement domParentElement = pNode->toElement();

	if ( dlg.exec( domParentElement, domCharData ) == QDialog::Accepted )
	{
		m_pViewTree->slotUpdateNodeCreated(domCharData);
		setModified();
	}

	emit setStatusBarText( i18n("Ready.") );
}

void KXMLEditorPart::slotXmlCharDataEdit()
{
	if ( ! isReadWrite() )
	{
		kdError() << "KXMLEditorPart::slotXmlCharDataEdit called in readonly mode." << endl;
		return;
	}

	QDomNode * pNode = m_pViewTree->getSelectedNode();
	if ( (!pNode) || (!pNode->isCharacterData()) )
	{
		kdError() << "KXMLEditorPart::slotXmlCharDataEdit no node selected or selected node is no character data." << endl;
		return;
	}

	emit setStatusBarText( i18n("Editing character data...") );

	QDomCharacterData domCharData = pNode->toCharacterData();
	DlgXMLCharData dlg( widget(), "char.data dialog" );

	if ( dlg.exec( domCharData ) == QDialog::Accepted )
	{
		m_pViewTree->slotUpdateNodeChanged(domCharData);
		setModified();
	}

	emit setStatusBarText( i18n("Ready.") );
}

void KXMLEditorPart::slotXmlCharDataDelete()
{
	if ( ! isReadWrite() )
	{
		kdError() << "KXMLEditorPart::slotXmlCharDataDelete called in readonly mode." << endl;
		return;
	}

	QDomNode * pNode = m_pViewTree->getSelectedNode();
	if ( (!pNode) || (!pNode->isCharacterData()) )
	{
		kdError() << "KXMLEditorPart::slotXmlCharDataDelete no node selected or selected node is no character data." << endl;
		return;
	}

	if ( pNode->parentNode().isNull() )
	{
		kdError() << "KXMLEditorPart::slotXmlCharDataDelete selected nodes parent node is empty." << endl;
		return;
	}

	emit setStatusBarText( i18n("Deleting character data...") );

	if ( pNode->parentNode().removeChild( *pNode ).isNull() )
		kdError() << "KXMLEditorPart::slotXmlCharDataDelete error removing the selected node." << endl;
	else
	{
		m_pViewTree->slotUpdateNodeDeleted(*pNode);
		setModified();
	}

	emit setStatusBarText( i18n("Ready.") );
}

void KXMLEditorPart::slotBookmarksToggle()
{
	m_pViewTree->slotBookmarksToggle();
	m_pActBookmarksPrev->setEnabled( m_pViewTree->containsBookmarkedItems() );
	m_pActBookmarksNext->setEnabled( m_pViewTree->containsBookmarkedItems() );
}

void KXMLEditorPart::slotConfigure()
{
	emit setStatusBarText( i18n("Configure KXMLEditor ...") );

	m_pDlgConfiguration->exec();

	emit setStatusBarText( i18n("Ready.") );
}

void KXMLEditorPart::slotPathSelected( const QString & szPath )
{
	QDomNode node = domTool_matchingNode( m_pDoc->documentElement(), szPath );
	if ( node.isNull() )
	{
		m_pActPathCombo->slotClearEdit();
		return;
	}

	if ( ! m_pViewTree->selectNode(node) )
		m_pActPathCombo->slotClearEdit();
}

void KXMLEditorPart::slotPathClear()
{
	slotEditDeselect();
	m_pActPathCombo->slotFocusEdit();
}


/////////////////////////////////////////////////////////////////////
//                     MISC FUNCTIONS
/////////////////////////////////////////////////////////////////////

void KXMLEditorPart::slotSelectionChanged( const QDomElement & selectedNode )
{
	// Enable/Disable actions
	m_pActEditDeselect->setEnabled(true);
	m_pActViewNodeUp->setEnabled( ! selectedNode.parentNode().isNull() ); // disable if it's a root item
	m_pActViewExpNode->setEnabled( ! selectedNode.firstChild().isNull() ); // no childs -> disable
	m_pActViewColNode->setEnabled( ! selectedNode.firstChild().isNull() ); // no childs -> disable
	m_pActBookmarksToggle->setEnabled(true);

	// change views
	m_pViewElement->slotChange(selectedNode);

	m_pTabWidget->setTabEnabled( m_pViewElement, true );
	m_pTabWidget->setTabEnabled( m_pViewContents, false );
	m_pTabWidget->setTabEnabled( m_pViewProcInstr, false );

	m_pTabWidget->showPage(m_pViewElement);

	// change path combo
	m_pActPathCombo->insertItem( domTool_getIconForNodeType(selectedNode.nodeType()), domTool_getPath(selectedNode) );
}

void KXMLEditorPart::slotSelectionChanged( const QDomCharacterData & selectedNode )
{
	// Enable/Disable actions
	m_pActEditDeselect->setEnabled(true);
	m_pActViewNodeUp->setEnabled( ! selectedNode.parentNode().isNull() ); // disable if it's a root item
	m_pActViewExpNode->setEnabled(false);
	m_pActViewColNode->setEnabled(false);
	m_pActBookmarksToggle->setEnabled(true);

	// change views
	m_pViewContents->setText( selectedNode.data() );

	m_pTabWidget->setTabEnabled( m_pViewElement, false );
	m_pTabWidget->setTabEnabled( m_pViewContents, true );
	m_pTabWidget->setTabEnabled( m_pViewProcInstr, false );

	m_pTabWidget->showPage( m_pViewContents );

	// change path combo
	m_pActPathCombo->insertItem( domTool_getIconForNodeType(selectedNode.nodeType()), domTool_getPath(selectedNode) );
}

void KXMLEditorPart::slotSelectionChanged( const QDomProcessingInstruction & selectedNode )
{
	// Enable/Disable actions
	m_pActEditDeselect->setEnabled(true);
	m_pActViewNodeUp->setEnabled( ! selectedNode.parentNode().isNull() ); // disable if it's a root item
	m_pActViewExpNode->setEnabled(false);
	m_pActViewColNode->setEnabled(false);
	m_pActBookmarksToggle->setEnabled(true);

	// change views
	m_pViewContents->clear();

	m_pTabWidget->setTabEnabled( m_pViewElement, false );
	m_pTabWidget->setTabEnabled( m_pViewContents, false );
	m_pTabWidget->setTabEnabled( m_pViewProcInstr, true );

	m_pTabWidget->showPage( m_pViewProcInstr );

	// change path combo
	m_pActPathCombo->slotClearEdit();
}

void KXMLEditorPart::slotConfigurationChanged() const
{
	// save the new configuration to our config file
	m_pDlgConfiguration->saveConfiguration( instance()->config() );
}
