/***************************************************************************
                          dlgxmlprocinstr.h  -  description
                             -------------------
    begin                : Mit Apr 24 2002
    copyright            : (C) 2002 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DLGXMLPROCINSTR_H
#define DLGXMLPROCINSTR_H

#include "dlgxmlprocinstrbase.h"

#include <qdom.h>

class DlgXMLProcInstr : public DlgXMLProcInstrBase
{
		Q_OBJECT

	public:
		DlgXMLProcInstr( QWidget * pParent = 0, const char * pszName = 0, bool fModal = true, WFlags fl = 0 );

	public slots:
		/**
		 * To be used for editing the given proc.instruction, therefore
		 * hides the "Where to insert" widgets.
		 * Updates the given proc.instr. with the data entered by the user
		 * (if OK was pressed).
		 *
		 * @return see @ref QDialog::exec
		 */
		int exec( QDomProcessingInstruction & domProcInstr );
		/**
		 * To be used for inserting a proc.instruction as child
		 * of the given parent element.
		 * If OK was pressed, a new proc.instr. is created with the entered
		 * data and gets set as a child of the given parent element. The
		 * new proc.instr. can be accessed via domNewProcInstr.
		 *
		 * @return see @ref QDialog::exec
		 */
		int exec( QDomElement & domParentElement, QDomProcessingInstruction & domNewProcInstr );

		/**
		 * Fills the dialogs widgets with the data from the given proc.instruction.
		 */
		void fillDialog( const QDomProcessingInstruction & domProcInstr );
		/**
		 * Clears the dialogs widgets.
		 */
		void clearDialog();
		/**
		 * Updates the given proc.instr. with the data entered in the dialogs widgets.
		 */
		void fillProcInstr( QDomProcessingInstruction & domProcInstr );

	protected slots:
		/**
		 * Don't use this function directly, it's for internal use only.
		 * Use one of the other @ref DlgXMLProcInstr::exec functions instead.
		 */
		int exec();
		/**
		 * Called, when the editlines are changed.
		 * Disables the OK button, if the given editlines are empty.
		 */
		void slotChanged( const QString & );

};

#endif
