/***************************************************************************
                          dlgxmlprocinstr.cpp  -  description
                             -------------------
    begin                : Mit Apr 24 2002
    copyright            : (C) 2002 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dlgxmlprocinstr.h"

#include <qlabel.h>
#include <qcombobox.h>
#include <qpushbutton.h>

#include <klineedit.h>
#include <kdebug.h>

DlgXMLProcInstr::DlgXMLProcInstr( QWidget * pParent = 0, const char * pszName = 0, bool fModal = true, WFlags fl = 0 )
	: DlgXMLProcInstrBase( pParent, pszName, fModal, fl )
{
	connect( m_pEditTarget, SIGNAL(textChanged(const QString&)), this, SLOT(slotChanged(const QString&)) );
	connect( m_pEditData, SIGNAL(textChanged(const QString&)), this, SLOT(slotChanged(const QString&)) );
}

void DlgXMLProcInstr::fillDialog( const QDomProcessingInstruction & domProcInstr )
{
	m_pEditTarget->setText( domProcInstr.target() );
	m_pEditData->setText( domProcInstr.data() );
}

void DlgXMLProcInstr::clearDialog()
{
	m_pEditTarget->clear();
	m_pEditData->clear();
}

int DlgXMLProcInstr::exec( QDomProcessingInstruction & domProcInstr )

{
	m_pComboInsert->hide();
	m_pComboInsert->setDisabled(true);
	m_pLblInsert->hide();
	m_pLblInsert->setDisabled(true);

	m_pEditTarget->setDisabled(true);
	fillDialog( domProcInstr );

	int iReturn = exec();
	if ( iReturn == Accepted )
		domProcInstr.setData( m_pEditData->text() );

	return iReturn;
}

int DlgXMLProcInstr::exec( QDomElement & domParentElement, QDomProcessingInstruction & domNewProcInstr )
{
	if ( domParentElement.isNull() )
	{
		kdError() << "DlgXMLProcInstr::exec the given parent XML element object is empty." << endl;
		return Rejected;
	}

	m_pEditTarget->setEnabled(true);
	clearDialog();

	int iReturn = exec();
	if ( iReturn == Accepted )
	{
		domNewProcInstr = domParentElement.ownerDocument().createProcessingInstruction( m_pEditTarget->text(), m_pEditData->text() );

		if ( m_pComboInsert->currentItem() == 0 )
		{                                         // insert as first child
			QDomNode domFirstChildNode = domParentElement.firstChild();
			if ( domFirstChildNode.isNull() )
				domParentElement.appendChild( domNewProcInstr ); // no childs yet -> simply append
			else
				domParentElement.insertBefore( domNewProcInstr, domFirstChildNode );
		}
		else                                      // insert as last child
			domParentElement.appendChild( domNewProcInstr );
	}

	return iReturn;
}

int DlgXMLProcInstr::exec()
{
	if ( m_pEditTarget->text().isEmpty() )
		m_pBtnOK->setEnabled(false);
	else
		m_pBtnOK->setEnabled(true);

	if ( m_pEditTarget->isEnabled() )
		m_pEditTarget->setFocus();
	else
		m_pEditData->setFocus();

	m_pBtnOK->setDefault(true);

	return DlgXMLProcInstrBase::exec();
}

void DlgXMLProcInstr::slotChanged( const QString & )
{
	if ( (m_pEditTarget->text().isEmpty()) || (m_pEditData->text().isEmpty()) )
		m_pBtnOK->setDisabled(true);
	else
		m_pBtnOK->setEnabled(true);
}
