/***************************************************************************
                          dlgxmlelement.cpp  -  description
                             -------------------
    begin                : Mit Apr 17 2002
    copyright            : (C) 2002 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dlgxmlelement.h"

#include <qlabel.h>
#include <qcombobox.h>
#include <qpushbutton.h>

#include <klineedit.h>
#include <kdebug.h>

DlgXMLElement::DlgXMLElement( QWidget * pParent = 0, const char * pszName = 0, bool fModal = true, WFlags fl = 0 )
	: DlgXMLElementBase( pParent, pszName, fModal, fl )
{
	connect( m_pEditTagName, SIGNAL(textChanged(const QString&)), this, SLOT(slotTagNameChanged(const QString&)) );
}

void DlgXMLElement::fillDialog( const QDomElement & domElement )
{
	m_pEditNamespace->setText( domElement.namespaceURI() );
	m_pEditTagName->setText( domElement.tagName() );
}

void DlgXMLElement::fillElement( QDomElement & domElement )
{
	domElement.setTagName( m_pEditTagName->text() );
}

int DlgXMLElement::exec( QDomElement & domElement )
{
	m_pComboInsert->hide();
	m_pComboInsert->setDisabled(true);
	m_pLblInsert->hide();
	m_pLblInsert->setDisabled(true);

	fillDialog( domElement );

	int iReturn = exec();
	if ( iReturn == Accepted )
		fillElement( domElement );

	return iReturn;
}

int DlgXMLElement::exec( QDomDocument & domDoc, QDomElement & domNewElement )
{
	if ( domDoc.isNull() )
	{
		kdError() << "DlgXMLElement::exec the given XML document object is empty." << endl;
		return Rejected;
	}
	if ( ! domDoc.documentElement().isNull() ) // if the document already
	{                                          // has a root element
		kdError() << "DlgXMLElement::exec the given XML document already has a root element." << endl;
		return Rejected;
	}

	m_pComboInsert->hide();
	m_pComboInsert->setDisabled(true);
	m_pLblInsert->hide();
	m_pLblInsert->setDisabled(true);

	fillDialog( domNewElement );

	int iReturn = exec();
	if ( iReturn == Accepted )
	{
		fillElement( domNewElement );
		domDoc.appendChild( domNewElement );
	}

	return iReturn;
}

int DlgXMLElement::exec( QDomElement & domParentElement, QDomElement & domNewElement )
{
	if ( domParentElement.isNull() )
	{
		kdError() << "DlgXMLElement::exec the given parent XML element object is empty." << endl;
		return Rejected;
	}

	fillDialog( domNewElement );

	int iReturn = exec();
	if ( iReturn == Accepted )
	{
		fillElement( domNewElement );
		if ( m_pComboInsert->currentItem() == 0 )
		{                                         // insert as first child
			QDomNode domFirstChildNode = domParentElement.firstChild();
			if ( domFirstChildNode.isNull() )
				domParentElement.appendChild( domNewElement ); // no childs yet -> simply append
			else
				domParentElement.insertBefore( domNewElement, domFirstChildNode );
		}
		else                                      // insert as last child
			domParentElement.appendChild( domNewElement );
	}

	return iReturn;
}

int DlgXMLElement::exec()
{
	if ( m_pEditTagName->text().isEmpty() )
		m_pBtnOK->setEnabled(false);
	else
		m_pBtnOK->setEnabled(true);
		
	m_pEditTagName->setFocus();
	m_pBtnOK->setDefault(true);

	return DlgXMLElementBase::exec();
}

void DlgXMLElement::slotTagNameChanged( const QString & szNewTagName )
{
	if ( szNewTagName.isEmpty() )
		m_pBtnOK->setEnabled(false);
	else
		m_pBtnOK->setEnabled(true);
}
