/***************************************************************************
                          dlgxmlchardata.h  -  description
                             -------------------
    begin                : Don Apr 25 2002
    copyright            : (C) 2002 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DLGXMLCHARDATA_H
#define DLGXMLCHARDATA_H

#include "dlgxmlchardatabase.h"

#include <qdom.h>

class DlgXMLCharData : public DlgXMLCharDataBase
{
		Q_OBJECT

	public:
		DlgXMLCharData( QWidget * pParent = 0, const char * pszName = 0, bool fModal = true, WFlags fl = 0 );

	public slots:
		/**
		 * To be used for editing the given XML character data, therefore
		 * hides the "Where to insert" widgets.
		 * Updates the given char.data with the data entered by the user (if OK was pressed).
		 *
		 * @return see @ref QDialog::exec
		 */
		int exec( QDomCharacterData & domCharData );
		/**
		 * To be used for inserting the given XML character data as child
		 * of the given parent element.
		 * If OK was pressed, a new char.data is created with the entered
		 * data and gets set as a child of the given parent element. The
		 * new char.data can be accessed via domNewCharData
		 *
		 * @return see @ref QDialog::exec
		 */
		int exec( QDomElement & domParentElement, QDomCharacterData & domNewCharData );

		/**
		 * Fills the dialogs widgets with the data from the given XML character data.
		 */
		void fillDialog( const QDomCharacterData & domCharData );
		/**
		 * Clears the dialogs widgets.
		 */
		void clearDialog();
		/**
		 * Updates the given character data with the data entered in the dialogs widgets.
		 */
		void fillCharData( QDomCharacterData & domCharData );

	protected slots:
		/**
		 * Don't use this function directly, it's for internal use only.
		 * Use one of the other @ref DlgXMLCharData::exec functions instead.
		 */
		int exec();
		/**
		 * Called, when the data in the text edit @ref DlgXMLCharDataBase::m_pEditData
		 * is changed.
		 * Disables the OK button, if the given string is empty.
		 */
		void slotDataChanged();
};

#endif
