/***************************************************************************
                          dlgxmlchardata.cpp  -  description
                             -------------------
    begin                : Don Apr 25 2002
    copyright            : (C) 2002 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dlgxmlchardata.h"

#include <qlabel.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qtextedit.h>

#include <kdebug.h>

DlgXMLCharData::DlgXMLCharData( QWidget * pParent = 0, const char * pszName = 0, bool fModal = true, WFlags fl = 0 )
	: DlgXMLCharDataBase( pParent, pszName, fModal, fl )
{
	connect( m_pEditData, SIGNAL(textChanged()), this, SLOT(slotDataChanged()) );
}

void DlgXMLCharData::fillDialog( const QDomCharacterData & domCharData )
{
	m_pEditData->setText( domCharData.data() );

	if ( domCharData.isCDATASection() )
		m_pComboType->setCurrentItem(1);
	else if ( domCharData.isText() )
		m_pComboType->setCurrentItem(0);
	else
		m_pComboType->setCurrentItem(2);

}

void DlgXMLCharData::clearDialog()
{
	m_pEditData->clear();
}

void DlgXMLCharData::fillCharData( QDomCharacterData & domCharData )
{
	domCharData.setData( m_pEditData->text() );
}

int DlgXMLCharData::exec( QDomCharacterData & domCharData )
{
	m_pComboInsert->hide();
	m_pComboInsert->setDisabled(true);
	m_pLblInsert->hide();
	m_pLblInsert->setDisabled(true);

	m_pComboType->setDisabled(true);
	fillDialog( domCharData );

	int iReturn = exec();
	if ( iReturn == Accepted )
		fillCharData( domCharData );

	return iReturn;
}

int DlgXMLCharData::exec( QDomElement & domParentElement, QDomCharacterData & domNewCharData )
{
	if ( domParentElement.isNull() )
	{
		kdError() << "DlgXMLCharData::exec the given parent XML element object is empty." << endl;
		return Rejected;
	}

	m_pComboType->setEnabled(true);
	clearDialog();

	int iReturn = exec();
	if ( iReturn == Accepted )
	{
		if ( m_pComboType->currentItem() == 0 )
			domNewCharData = domParentElement.ownerDocument().createTextNode( m_pEditData->text() );
		else if ( m_pComboType->currentItem() == 1 )
			domNewCharData = domParentElement.ownerDocument().createCDATASection( m_pEditData->text() );
		else
			domNewCharData = domParentElement.ownerDocument().createComment( m_pEditData->text() );

		if ( m_pComboInsert->currentItem() == 0 )
		{                                         // insert as first child
			QDomNode domFirstChildNode = domParentElement.firstChild();
			if ( domFirstChildNode.isNull() )
				domParentElement.appendChild( domNewCharData ); // no childs yet -> simply append
			else
				domParentElement.insertBefore( domNewCharData, domFirstChildNode );
		}
		else                                      // insert as last child
			domParentElement.appendChild( domNewCharData );
	}

	return iReturn;
}

int DlgXMLCharData::exec()
{
	if ( m_pEditData->text().isEmpty() )
		m_pBtnOK->setEnabled(false);
	else
		m_pBtnOK->setEnabled(true);
		
	m_pEditData->setFocus();
	m_pBtnOK->setDefault(true);

	return DlgXMLCharDataBase::exec();
}

void DlgXMLCharData::slotDataChanged()
{
	if ( m_pEditData->text().isEmpty() )
		m_pBtnOK->setEnabled(false);
	else
		m_pBtnOK->setEnabled(true);
}
