/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : t ec 10 12:39:26 CEST 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <dcopclient.h>

#include "kxmleditor.h"
#include "../part/kxmleditorabout.h"
#include "kxmleditorshell.h"


static KCmdLineOptions options[] =
{
  { "+[File(s)]", I18N_NOOP("XML file(s) to open"), 0 },
  { 0, 0, 0 }
};

#define USE_KPART 0
	// if set to true makes kxmleditor to be kpart based (currently developement version only)

int main(int argc, char *argv[])
{
	KCmdLineArgs::init( argc, argv, new KXMLEditorAboutData() );
	KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

	KApplication app;

  // comment the following lines to use KXMLEditorShell instead of KXMLEditorApp
#if ! USE_KPART
  if (app.isRestored())
  	{ RESTORE(KXMLEditorApp);
  	}
  else
  {
    KXMLEditorApp *kxmleditor = new KXMLEditorApp();
    kxmleditor->show();

    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

		if(args->count())
			{ QString strPath;

			  if(args->count() > 1)
					{ strPath = args->arg(1);
					}
          KURL url(args->arg(0));
					if (url.isMalformed() )
						{ // probably user entered just filename
							url.setProtocol("file");
							url.setPath(args->arg(0));
						}
					kxmleditor->openDocumentFile(url, strPath);
			}
		else
			{ kxmleditor->openDocumentFile();
			}
		args->clear();
  }
#else // USE_KPART

	if (app.isRestored())
	{
		RESTORE(KXMLEditorShell);
	}
	else
	{
		KCmdLineArgs * pArgs = KCmdLineArgs::parsedArgs();
		KXMLEditorShell * pShell;
		bool bNoCorrectInstance = true;
		if ( pArgs->count() > 0 )
		{
			for( int i = 0; i < pArgs->count(); i++ )
			{
				KURL url(pArgs->arg(i));
				if ( url.isMalformed() )
				{
					url.setProtocol("file");
					url.setPath(pArgs->arg(i));
				}
				pShell = new KXMLEditorShell();
				if ( pShell->openURL(url) )
				{
					pShell->show();
					bNoCorrectInstance = false;
				}
				else
					delete pShell;
			}
		}
		else
		{
			pShell = new KXMLEditorShell();
			pShell->show();
			bNoCorrectInstance = false;
		}
		pArgs->clear();

		if ( bNoCorrectInstance )
			return FALSE;
	}

	// registration as multi-instance DCOP client
	DCOPClient *client = app.dcopClient();
	client->attach();
	client->registerAs(kapp->name());

  // uncomment end
#endif // USE_KPART

  int iRetVal = app.exec();
  return iRetVal;
}

