/***************************************************************************
                          kxmleditorshell.cpp  -  description
                             -------------------
    begin                : Thu Oct 18 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxmleditorshell.h"

#include <klibloader.h>
#include <kstdaction.h>
#include <klocale.h>
#include <kdebug.h>
#include <kfiledialog.h>
#include <kkeydialog.h>
#include <kedittoolbar.h>
#include <kstatusbar.h>

#include "dcopiface_shell.h"

KXMLEditorShell::KXMLEditorShell( const char * name, WFlags f )
	: KParts::MainWindow( name, f ),
	  m_pPart(0),
	  m_pKXEShellIface(0)
{
	//////////////////////////////
	// CREATE ACTIONS
	//////////////////////////////
	setXMLFile("kxmleditorshell.rc");

	KStdAction::open( this, SLOT(slotFileOpen()), actionCollection() );
	m_pActFileOpenRecent = KStdAction::openRecent( this, SLOT(slotFileOpenRecent(const KURL&)), actionCollection());
	m_pActFileOpenRecent->loadEntries( instance()->config() );

	KToggleAction * pActToggleToolBar = KStdAction::showToolbar( this, SLOT(slotToggleToolBar()), actionCollection() );
	KToggleAction * pActToggleStatusBar = KStdAction::showStatusbar( this, SLOT(slotToggleStatusBar()), actionCollection() );
	KStdAction::keyBindings( this, SLOT(slotConfigureKeys()), actionCollection() );
	KStdAction::configureToolbars( this, SLOT(slotConfigureToolbars()), actionCollection() );

	KStdAction::quit( this, SLOT(close()), actionCollection() );

	// try to find libkxmleditor
	QString szLibName("libkxmleditorpart");
	KLibFactory * pFactory = KLibLoader::self()->factory(szLibName);
	if (pFactory)
	{
		m_pPart = static_cast <KParts::ReadOnlyPart*> ( pFactory->create( this, "KXMLEditor view", "KParts::ReadWritePart" ) );
		setCentralWidget( m_pPart->widget() );
		createGUI( m_pPart );
	}
	else
		kdFatal() << "KXMLEditorShell::KXMLEditorShell no " << szLibName << " found" << endl;

	//////////////////////////////
	// CREATE STATUSBAR
	//////////////////////////////
	statusBar()->message( i18n("Ready.") );

	//////////////////////////////
	// MISC. INITIALIZATION
	//////////////////////////////
	setAutoSaveSettings();
	pActToggleToolBar->setChecked( ! toolBar()->isHidden() );
	pActToggleStatusBar->setChecked( ! statusBar()->isHidden() );

	m_pKXEShellIface = new KXMLEditorShellIface(*this);
}

KXMLEditorShell::~KXMLEditorShell()
{
	if (m_pKXEShellIface)
		delete m_pKXEShellIface;
}

/////////////////////////////////////////////////////////////////////
//                     ACTION SLOTS
/////////////////////////////////////////////////////////////////////

void KXMLEditorShell::slotFileOpen()
{
	statusBar()->message( i18n("Opening file...") );

	KURL url = KFileDialog::getOpenURL( QString::null,
	                                    i18n("*.xml|XML files\n*|All files"),
	                                    this );
	openURL(url);

	statusBar()->message( i18n("Ready.") );
}

void KXMLEditorShell::slotFileOpenRecent(const KURL & url)
{
	statusBar()->message( i18n("Opening file...") );

	openURL(url);

	statusBar()->message( i18n("Ready.") );
}

void KXMLEditorShell::slotToggleToolBar()
{
	statusBar()->message( i18n("Toggle the toolbar...") );

	if( toolBar()->isHidden() )
		toolBar()->show();
	else
		toolBar()->hide();

	statusBar()->message( i18n("Ready.") );
}

void KXMLEditorShell::slotToggleStatusBar()
{
	statusBar()->message( i18n("Toggle the statusbar...") );

	if( statusBar()->isHidden() )
		statusBar()->show();
	else
		statusBar()->hide();

	statusBar()->message( i18n("Ready.") );
}

void KXMLEditorShell::slotConfigureKeys()
{
	KKeyDialog::configureKeys( actionCollection(), xmlFile() );
}

void KXMLEditorShell::slotConfigureToolbars()
{
	KEditToolbar dlg( factory() );
	if ( dlg.exec() )
		createGUI( m_pPart );
}

/////////////////////////////////////////////////////////////////////
//                    ADDITIONAL FUNCTIONS
/////////////////////////////////////////////////////////////////////

bool KXMLEditorShell::openURL( const KURL & url ) const
{
	if ( url.isEmpty() )
		return false;

	if ( ! m_pPart->openURL(url) )
		return false;

	m_pActFileOpenRecent->addURL(url);
	return true;
}

bool KXMLEditorShell::queryClose()
{
	m_pActFileOpenRecent->saveEntries( instance()->config() );

	return KParts::MainWindow::queryClose();
}

void KXMLEditorShell::saveProperties( KConfig * pConfig )
{
	pConfig->writeEntry( "CurrentURL", m_pPart->url().url() );

	KParts::MainWindow::saveProperties(pConfig);
}

void KXMLEditorShell::readProperties( KConfig * pConfig )
{
	KParts::MainWindow::readProperties(pConfig);

	QString strURL = pConfig->readEntry( "CurrentURL", "" );
	if ( strURL.isEmpty())
		return;
	m_pPart->openURL( strURL );
}
