/***************************************************************************
                          kxmleditor.cpp  -  description
                             -------------------
    begin                : t ec 10 12:39:26 CEST 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for QT
#include <qdir.h>
#include <qprinter.h>
#include <qpainter.h>

// include files for KDE
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kmenubar.h>
#include <klocale.h>
#include <kconfig.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kdebug.h>
#include <kedittoolbar.h>
#include <kkeydialog.h>
#include <kstatusbar.h>
#include <kpopupmenu.h>
// application specific includes
#include "kxmleditor.h"
#include "kxmleditorview.h"
#include "kxmleditordoc.h"
#include "xml_base.h"
#include "actions.h"
#include "optionsdialog.h"
#include "xmltreeview.h"
#include "searchdlg.h"

#define ID_STATUS_MSG 1

KXMLEditorApp::KXMLEditorApp(QWidget* , const char* name) : KMainWindow(0, name)
{
  config=kapp->config();

  OptionsDialog::readConfiguration(config);

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initStatusBar();
  initActions();
  initDocument();
  initView();
	
  readOptions();

  ///////////////////////////////////////////////////////////////////
  // disable actions at startup
  m_Actions.fileSave->setEnabled(false);
  //fileSaveAs->setEnabled(false);

  m_Actions.filePrint->setEnabled(false);
  m_Actions.editCut->setEnabled(false);
  m_Actions.editCopy->setEnabled(false);
  m_Actions.editPaste->setEnabled(false);

  m_Actions.goUp->setEnabled(false);

  m_Actions.bookmarksToggle->setEnabled(false);
  m_Actions.bookmarksPrev->setEnabled(false);
  m_Actions.bookmarksNext->setEnabled(false);

  m_Actions.xmlEditElement->setEnabled(false);
	m_Actions.xmlDeleteElement->setEnabled(false);
	
	m_Actions.xmlInsertAttribute->setEnabled(false);
	m_Actions.xmlEditAttribute->setEnabled(false);
	m_Actions.xmlDeleteAttribute->setEnabled(false);
	
	m_Actions.xmlInsertContents->setEnabled(false);
	m_Actions.xmlEditContents->setEnabled(false);
	m_Actions.xmlDeleteContents->setEnabled(false);
	
	m_Actions.xmlEditProcInstr->setEnabled(false);
	m_Actions.xmlDeleteProcInstr->setEnabled(false);
	
	m_Actions.xmlMoveItemUp->setEnabled(false);
	m_Actions.xmlMoveItemDown->setEnabled(false);
	
	m_Actions.xmlExpandNode->setEnabled(false);
	m_Actions.xmlCollapseNode->setEnabled(false);

	XmlTreeItem::m_strSubtypeXML = "xml";
	XmlTreeItem::m_strSubtypeXML_text = "xml.text";
	XmlTreeItem::m_strSubtypeXML_cdata = "xml.cdata";
	XmlTreeItem::m_strSubtypeXML_comment = "xml.comment";
	XmlTreeItem::m_strSubtypeXML_procins = "xml.procins";
}

KXMLEditorApp::~KXMLEditorApp()
{
	if(KXMLEditorView::m_pElementsMenu)
		delete KXMLEditorView::m_pElementsMenu;
	
	if(KXMLEditorView::m_pAttributesMenu)
		delete KXMLEditorView::m_pAttributesMenu;
		
	if(KXMLEditorView::m_pNewRootElementMenu)
		delete KXMLEditorView::m_pNewRootElementMenu;
	
	if(KXMLEditorView::m_pContentsMenu)
		delete KXMLEditorView::m_pContentsMenu;
		
	if(KXMLEditorView::m_pProcInstrMenu)
		delete KXMLEditorView::m_pProcInstrMenu;
}

void KXMLEditorApp::initActions()
{
	//-----------------------------------------------------------------
	// File menu
	m_Actions.fileNew = KStdAction::openNew(this, SLOT(slotFileNew()), actionCollection());
  m_Actions.fileOpen = KStdAction::open(this, SLOT(slotFileOpen()), actionCollection());
  m_Actions.fileOpenRecent = KStdAction::openRecent(this, SLOT(slotFileOpenRecent(const KURL&)), actionCollection());
  m_Actions.fileSave = KStdAction::save(this, SLOT(slotFileSave()), actionCollection());
  m_Actions.fileSaveAs = KStdAction::saveAs(this, SLOT(slotFileSaveAs()), actionCollection());
  m_Actions.fileClose = KStdAction::close(this, SLOT(slotFileClose()), actionCollection());
  m_Actions.filePrint = KStdAction::print(this, SLOT(slotFilePrint()), actionCollection());
  m_Actions.fileQuit = KStdAction::quit(this, SLOT(slotFileQuit()), actionCollection());

  //-----------------------------------------------------------------
	// Edit menu
	m_Actions.editCut = KStdAction::cut(this, SLOT(slotEditCut()), actionCollection());
  m_Actions.editCopy = KStdAction::copy(this, SLOT(slotEditCopy()), actionCollection());
  m_Actions.editPaste = KStdAction::paste(this, SLOT(slotEditPaste()), actionCollection());

  m_Actions.editFind = KStdAction::find(this, SLOT(slotEditFind()), actionCollection());
	m_Actions.editFindNext = KStdAction::findNext(this, SLOT(slotEditFindNext()), actionCollection());

  //-----------------------------------------------------------------
	// Settings menu
	m_Actions.settingsShowToolBar = KStdAction::showToolbar( this, SLOT(slotShowToolBar()), actionCollection(), "showtoolbar");
  m_Actions.settingsShowXmlToolBar = new KToggleAction( i18n( "Show &XML Toolbar" ), 0, this, SLOT( slotShowXmlToolBar() ), actionCollection(), "showxmltoolbar" );
  m_Actions.settingsShowPathBar = new KToggleAction( i18n( "Show &Path Toolbar" ), 0, this, SLOT( slotShowLocationBar() ), actionCollection(), "showlocationbar" );
  m_Actions.settingsShowStatusBar = KStdAction::showStatusbar(this, SLOT(slotViewStatusBar()), actionCollection(), "showstatusbar");
	
  KStdAction::keyBindings(this, SLOT(slotConfigureKeys()), actionCollection(), "configurekeys");
  KStdAction::configureToolbars(this, SLOT(slotConfigToolbars()), actionCollection(), "configuretoolbars");
	KStdAction::preferences(this, SLOT (slotConfigure()), actionCollection(), "configure");
	
	//-----------------------------------------------------------------
	// Go menu
  m_Actions.goUp = KStdAction::up(this, SLOT(slotUp()), actionCollection());

	//-----------------------------------------------------------------
	// Bookmark menu
  m_Actions.bookmarksToggle = KStdAction::addBookmark(this, SLOT(slotToggleBookmark()), actionCollection());
	m_Actions.bookmarksToggle->setText(i18n("&Toggle Bookmark"));

	m_Actions.bookmarksPrev = new KAction(i18n("&Previous Bookmark"), "bookmark_prev", SHIFT+Key_F5, this, SLOT(slotBookmarkPrev()), actionCollection(), "prev_bookmark");
	m_Actions.bookmarksNext = new KAction(i18n("&Next Bookmark"), "bookmark_next", Key_F5, this, SLOT(slotBookmarkNext()), actionCollection(), "next_bookmark");
	
	//-----------------------------------------------------------------
	// XML menu
	m_Actions.xmlInsertElement = new KAction(i18n("&Insert element"), "xml_insert_element", CTRL+Key_E, this, SLOT(slotXmlInsertElement()), actionCollection(), "xml_ins_element");
	m_Actions.xmlEditElement = new KAction(i18n("&Edit element"), "xml_edit_element", 0, this, SLOT(slotXmlEditElement()), actionCollection(), "xml_edit_element");
	m_Actions.xmlDeleteElement = new KAction(i18n("&Delete element"), "xml_delete_element", 0, this, SLOT(slotXmlDeleteElement()), actionCollection(), "xml_del_element");

	m_Actions.xmlInsertAttribute = new KAction(i18n("Insert attribute"), "xml_insert_attribute", CTRL+Key_A, this, SLOT(slotXmlInsertAttribute()), actionCollection(), "xml_ins_attribute");
	m_Actions.xmlEditAttribute = new KAction(i18n("Edit attribute"), "xml_edit_attribute", 0, this, SLOT(slotXmlEditAttribute()), actionCollection(), "xml_edit_attribute");
	m_Actions.xmlDeleteAttribute = new KAction(i18n("Delete attribute"), "xml_delete_attribute", 0, this, SLOT(slotXmlDeleteAttribute()), actionCollection(), "xml_del_attribute");

	m_Actions.xmlInsertContents = new KAction(i18n("Insert contents"), "xml_insert_contents", CTRL+Key_T, this, SLOT(slotXmlInsertContents()), actionCollection(), "xml_ins_contents");
	m_Actions.xmlEditContents = new KAction(i18n("Edit contents"), "xml_edit_contents", 0, this, SLOT(slotXmlEditContents()), actionCollection(), "xml_edit_contents");
	m_Actions.xmlDeleteContents = new KAction(i18n("Delete contents"), "xml_delete_contents", 0, this, SLOT(slotXmlDeleteContents()), actionCollection(), "xml_del_contents");

	m_Actions.xmlInsertProcInstr = new KAction(i18n("Insert proc. instruction"), "xml_insert_procins", CTRL+Key_R, this, SLOT(slotXmlInsertProcInstruction()), actionCollection(), "xml_ins_procins");
	m_Actions.xmlEditProcInstr = new KAction(i18n("Edit proc. instruction"), "xml_edit_procins", 0, this, SLOT(slotXmlEditProcInstruction()), actionCollection(), "xml_edit_procins");
	m_Actions.xmlDeleteProcInstr = new KAction(i18n("Delete proc. instruction"), "xml_delete_procins", 0, this, SLOT(slotXmlDeleteProcInstruction()), actionCollection(), "xml_del_procins");

	m_Actions.xmlMoveItemUp = new KAction(i18n("Move &Up"), "xml_move_item_up", CTRL+Key_U, this, SLOT(slotXmlMoveItemUp()), actionCollection(), "xml_move_item_up");
	m_Actions.xmlMoveItemDown = new KAction(i18n("Move &Down"), "xml_move_item_down", CTRL+Key_D, this, SLOT(slotXmlMoveItemDown()), actionCollection(), "xml_move_item_down");

	m_Actions.xmlExpandNode = new KToolBarPopupAction(i18n("&Expand Node"), "expand_node", CTRL+Key_Plus, this, SLOT(slotExpandNode()), actionCollection(), "expand_node");
	KPopupMenu * pMenuExpNode = m_Actions.xmlExpandNode->popupMenu();
	connect( pMenuExpNode, SIGNAL(activated(int)), this, SLOT(slotExpandNodeActivated(int)));
	for ( uint i = 1; i <= 8; i++ )
		pMenuExpNode->insertItem( i18n("Expand to level %1").arg(i), i+1 );

	m_Actions.xmlCollapseNode= new KToolBarPopupAction(i18n("&Collapse Node"), "collapse_node", CTRL+Key_Minus, this, SLOT(slotCollapseNode()), actionCollection(), "collapse_node");
	KPopupMenu * pMenuColNode = m_Actions.xmlCollapseNode->popupMenu();
	connect( pMenuColNode, SIGNAL(activated(int)), this, SLOT(slotCollapseNodeActivated(int)) );
	for ( uint i = 1; i <= 8; i++ )
		pMenuColNode->insertItem( i18n("Collapse to level %1").arg(i), i+1 );

	//-----------------------------------------------------------------
	// Popup menus
	KXMLEditorView::m_pElementsMenu = new KPopupMenu;
	KXMLEditorView::m_pAttributesMenu = new KPopupMenu;
	KXMLEditorView::m_pNewRootElementMenu = new KPopupMenu;
	KXMLEditorView::m_pContentsMenu = new KPopupMenu;
	KXMLEditorView::m_pProcInstrMenu = new KPopupMenu;

	m_Actions.xmlInsertElement->plug(KXMLEditorView::m_pNewRootElementMenu);
	m_Actions.xmlInsertProcInstr->plug(KXMLEditorView::m_pNewRootElementMenu);
	
	m_Actions.xmlInsertElement->plug(KXMLEditorView::m_pElementsMenu);
	m_Actions.xmlEditElement->plug(KXMLEditorView::m_pElementsMenu);
	m_Actions.xmlDeleteElement->plug(KXMLEditorView::m_pElementsMenu);
	KXMLEditorView::m_pElementsMenu->insertSeparator();
	m_Actions.xmlInsertContents->plug(KXMLEditorView::m_pElementsMenu);
	m_Actions.xmlInsertProcInstr->plug(KXMLEditorView::m_pElementsMenu);
	KXMLEditorView::m_pElementsMenu->insertSeparator();
	m_Actions.xmlMoveItemUp->plug(KXMLEditorView::m_pElementsMenu);
	m_Actions.xmlMoveItemDown->plug(KXMLEditorView::m_pElementsMenu);
	KXMLEditorView::m_pElementsMenu->insertSeparator();
	m_Actions.bookmarksToggle->plug(KXMLEditorView::m_pElementsMenu);

	m_Actions.xmlInsertAttribute->plug(KXMLEditorView::m_pAttributesMenu);
	m_Actions.xmlEditAttribute->plug(KXMLEditorView::m_pAttributesMenu);
	m_Actions.xmlDeleteAttribute->plug(KXMLEditorView::m_pAttributesMenu);
	
	m_Actions.xmlEditContents->plug(KXMLEditorView::m_pContentsMenu);
	m_Actions.xmlDeleteContents->plug(KXMLEditorView::m_pContentsMenu);
	KXMLEditorView::m_pContentsMenu->insertSeparator();
	m_Actions.xmlInsertElement->plug(KXMLEditorView::m_pContentsMenu);
	m_Actions.xmlInsertProcInstr->plug(KXMLEditorView::m_pContentsMenu);
	KXMLEditorView::m_pContentsMenu->insertSeparator();
	m_Actions.xmlMoveItemUp->plug(KXMLEditorView::m_pContentsMenu);
	m_Actions.xmlMoveItemDown->plug(KXMLEditorView::m_pContentsMenu);
	KXMLEditorView::m_pContentsMenu->insertSeparator();
	m_Actions.bookmarksToggle->plug(KXMLEditorView::m_pContentsMenu);
	
	m_Actions.xmlInsertProcInstr->plug(KXMLEditorView::m_pProcInstrMenu);
	m_Actions.xmlEditProcInstr->plug(KXMLEditorView::m_pProcInstrMenu);
	m_Actions.xmlDeleteProcInstr->plug(KXMLEditorView::m_pProcInstrMenu);
	KXMLEditorView::m_pProcInstrMenu->insertSeparator();
	m_Actions.xmlMoveItemUp->plug(KXMLEditorView::m_pProcInstrMenu);
	m_Actions.xmlMoveItemDown->plug(KXMLEditorView::m_pProcInstrMenu);
	KXMLEditorView::m_pProcInstrMenu->insertSeparator();
	m_Actions.bookmarksToggle->plug(KXMLEditorView::m_pProcInstrMenu);

	//-----------------------------------------------------------------

  //fileNewWindow->setStatusText(i18n("Opens a new application window"));
  m_Actions.fileNew->setStatusText(i18n("Creates a new document"));
  m_Actions.fileOpen->setStatusText(i18n("Opens an existing document"));
  m_Actions.fileOpenRecent->setStatusText(i18n("Opens a recently used file"));
  m_Actions.fileSave->setStatusText(i18n("Saves the actual document"));
  m_Actions.fileSaveAs->setStatusText(i18n("Saves the actual document as..."));
  m_Actions.fileClose->setStatusText(i18n("Closes the actual document"));
  m_Actions.filePrint->setStatusText(i18n("Prints out the actual document"));
  m_Actions.fileQuit->setStatusText(i18n("Quits the application"));
  m_Actions.editCut->setStatusText(i18n("Cuts the selected section and puts it to the clipboard"));
  m_Actions.editCopy->setStatusText(i18n("Copies the selected section to the clipboard"));
  m_Actions.editPaste->setStatusText(i18n("Pastes the clipboard contents to actual position"));

  m_Actions.settingsShowToolBar->setStatusText(i18n("Enables/disables the main toolbar"));
	m_Actions.settingsShowXmlToolBar->setStatusText(i18n("Enables/disables the XML toolbar"));
	m_Actions.settingsShowPathBar->setStatusText(i18n("Enables/disables the location bar"));
	m_Actions.settingsShowStatusBar->setStatusText(i18n("Enables/disables the statusbar"));

  //-----------------------------------------------------------------
  // Path bar initialization - based on Konqueror: KonqMainWindow::initActions()
  new KAction( i18n("Clear Path bar"), BarIcon("locationbar_erase", 16), 0, this, SLOT(slotClearLocationBar()), actionCollection(), "path_clear" );
  new KXmlEditorLabelAction( i18n("&Path "), actionCollection(), "path_label");
  m_Actions.pathCombo = new KXmlEditorComboAction( i18n("Path Bar"), 0, this, SLOT(slotPathComboActivated(const QString &)), actionCollection(), "path_combo");

	//-----------------------------------------------------------------
	// Use the absolute path to your kxmleditorui.rc file for testing purpose in createGUI();
  createGUI();
}

void KXMLEditorApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  // STATUSBAR
  // TODO: add your own items you need for displaying current application status.
  statusBar()->insertItem(i18n("Ready."), ID_STATUS_MSG);
}

void KXMLEditorApp::initDocument()
{
  doc = new KXMLEditorDoc(this);
  doc->newDocument();
  connect(doc, SIGNAL(sigModified()), this, SLOT(slotDocumentModified()) );
}

void KXMLEditorApp::initView()
{
	////////////////////////////////////////////////////////////////////
  // create the main widget here that is managed by KTMainWindow's view-region and
  // connect the widget to your document to display document contents.

  view = new KXMLEditorView(this);
  doc->addView(view);

	// KXMLEditorView is derived from QSplitter
  view->setOrientation(Horizontal);
	view->setOpaqueResize(TRUE);

  setCentralWidget(view);	
  setCaption(doc->URL().fileName(),false);

  connect(view, SIGNAL(sigSelectedElementChanged(const XmlTreeItem * const)), this, SLOT(slotSelectedElementChanged(const XmlTreeItem * const)) );
}

void KXMLEditorApp::openDocumentFile(const KURL& url, const QString &strPath)
{
  slotStatusMsg(i18n("Opening file..."));

  if (!doc->openDocument(url, QString::null) )
		{ slotStatusMsg(i18n("Ready. Opening %1 failed.").arg(url.url()));
		}
  else
		{ setCaption(url.fileName(), false);
		
			if(strPath.length() > 0)
  			slotPathComboActivated(strPath);

			// KDE wizard generated code not contain this condition, this
			// cause empty lines in recent menu.
			if(!url.isEmpty())
				m_Actions.fileOpenRecent->addURL(url);

		slotStatusMsg(i18n("Ready."));
	}
}


KXMLEditorDoc *KXMLEditorApp::getDocument() const
{
  return doc;
}

void KXMLEditorApp::saveOptions()
{	
config->setGroup("General Options");
  config->writeEntry("Geometry", size());

  config->writeEntry("Show Main Toolbar", m_Actions.settingsShowToolBar->isChecked());
  config->writeEntry("Show Path Bar", m_Actions.settingsShowPathBar->isChecked());
  config->writeEntry("Show XML Toolbar", m_Actions.settingsShowXmlToolBar->isChecked());

  config->writeEntry("Show Statusbar", m_Actions.settingsShowStatusBar->isChecked());
  config->writeEntry("ToolBarPos_mainToolBar", (int) toolBar("mainToolBar")->barPos());
  config->writeEntry("ToolBarPos_pathToolBar", (int) toolBar("pathToolBar")->barPos());
  config->writeEntry("ToolBarPos_xmlToolBar", (int) toolBar("xmlToolBar")->barPos());
  m_Actions.fileOpenRecent->saveEntries(config, "Recent Files");

  // save app settings
	OptionsDialog::saveConfiguration(config);
}


void KXMLEditorApp::readOptions()
{
  config->setGroup("General Options");

  // bar status settings
  bool bViewToolbar;

  bViewToolbar = config->readBoolEntry("Show Main Toolbar", true);
  m_Actions.settingsShowToolBar->setChecked(bViewToolbar);
  setToolBarState("mainToolBar", bViewToolbar);

  bViewToolbar = config->readBoolEntry("Show Path Bar", true);
  m_Actions.settingsShowPathBar->setChecked(bViewToolbar);
  setToolBarState("pathToolBar", bViewToolbar);

  bViewToolbar = config->readBoolEntry("Show XML Toolbar", true);
  m_Actions.settingsShowXmlToolBar->setChecked(bViewToolbar);
  setToolBarState("xmlToolBar", bViewToolbar);


  bool bViewStatusbar = config->readBoolEntry("Show Statusbar", true);
  m_Actions.settingsShowStatusBar->setChecked(bViewStatusbar);
  slotViewStatusBar();


  // bar position settings
  KToolBar::BarPosition toolBarPos;

  toolBarPos=(KToolBar::BarPosition) config->readNumEntry("ToolBarPos_mainToolBar", KToolBar::Top);
  toolBar("mainToolBar")->setBarPos(toolBarPos);

  toolBarPos=(KToolBar::BarPosition) config->readNumEntry("ToolBarPos_pathToolBar", KToolBar::Top);
  toolBar("pathToolBar")->setBarPos(toolBarPos);

  toolBarPos=(KToolBar::BarPosition) config->readNumEntry("ToolBarPos_xmlToolBar", KToolBar::Left);
  toolBar("xmlToolBar")->setBarPos(toolBarPos);
	
  // initialize the recent file list
  m_Actions.fileOpenRecent->loadEntries(config,"Recent Files");

  QSize size=config->readSizeEntry("Geometry");
  if(!size.isEmpty())
  {
    resize(size);
  }
}

void KXMLEditorApp::saveProperties(KConfig *_cfg)
{
  if(doc->URL().fileName() == i18n("Untitled") && !doc->isModified())
  {
    // saving to tempfile not necessary

  }
  else
  {
    KURL url=doc->URL();	
    _cfg->writeEntry("filename", url.url());
    _cfg->writeEntry("modified", doc->isModified());
    _cfg->writeEntry("comprTarEntryName", doc->compressedTarEntryName());
    QString tempname = kapp->tempSaveName(url.url());
    QString tempurl= KURL::encode_string(tempname);
    KURL _url(tempurl);
    doc->saveDocument(_url);
  }
}

void KXMLEditorApp::readProperties(KConfig* _cfg)
{
  QString filename = _cfg->readEntry("filename", "");
	KURL url(filename);
  bool modified = _cfg->readBoolEntry("modified", false);
	QString strComprTarEntryName = _cfg->readEntry("comprTarEntryName", "");

  if(modified)
  {
    bool canRecover;
    QString tempname = kapp->checkRecoverFile(filename, canRecover);
    KURL _url(tempname);
  	
    if(canRecover)
    	{ doc->openDocument(_url, strComprTarEntryName);
      	doc->setModified();
      	setCaption(_url.fileName(),true);
      	QFile::remove(tempname);
    	}
  }
  else
  {
    if(!filename.isEmpty())
    { doc->openDocument(url, strComprTarEntryName);
      setCaption(url.fileName(),false);
    }
  }
}		

bool KXMLEditorApp::queryClose()
{
  return doc->saveModified();
}

bool KXMLEditorApp::queryExit()
{
  saveOptions();
  return true;
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////
/*
void KXMLEditorApp::slotFileNewWindow()
{
  slotStatusMsg(i18n("Opening a new application window..."));

  KXMLEditorApp *new_window= new KXMLEditorApp();
  new_window->show();

  slotStatusMsg(i18n("Ready."));
}*/

void KXMLEditorApp::slotFileNew()
{
  slotStatusMsg(i18n("Creating new document..."));

  if(!doc->saveModified())
  {
     // here saving wasn't successful

  }
  else
  {
    doc->newDocument();
    setCaption(doc->URL().fileName(), false);
    m_Actions.pathCombo->slotClear();
  }

  slotStatusMsg(i18n("Ready."));
}

void KXMLEditorApp::slotFileOpen()
{
  slotStatusMsg(i18n("Opening file..."));

  if(!doc->saveModified())
  	{ // here saving wasn't successful
		}
  else
  	{ KURL url = KFileDialog::getOpenURL(QString::null, i18n("*.xml|XML files\n*|All files"), this, i18n("Open File..."));
    	if(!url.isEmpty())
    		{ doc->openDocument(url, QString::null);
      		setCaption(url.fileName(), false);
      		m_Actions.fileOpenRecent->addURL(url);
    		}
  	}

  m_Actions.pathCombo->slotClear();

  slotStatusMsg(i18n("Ready."));
}

void KXMLEditorApp::slotFileOpenRecent(const KURL& url)
{
  slotStatusMsg(i18n("Opening file..."));

  if(!doc->saveModified())
  {
     // here saving wasn't successful
  }
  else
  {
    doc->openDocument(url, QString::null);
    setCaption(url.fileName(), false);
  }

  m_Actions.pathCombo->slotClear();

  slotStatusMsg(i18n("Ready."));
}

void KXMLEditorApp::slotFileSave()
{
  slotStatusMsg(i18n("Saving file..."));
	
	if(doc->URL().fileName() == i18n("Untitled"))
  	slotFileSaveAs();
	else
		doc->saveDocument(doc->URL());
		
	setCaption(doc->URL().fileName(), doc->isModified());

  m_Actions.fileSave->setEnabled(false);

  slotStatusMsg(i18n("Ready."));
}

void KXMLEditorApp::slotFileSaveAs()
{
  slotStatusMsg(i18n("Saving file with a new filename..."));

  KURL url=KFileDialog::getSaveURL(QDir::currentDirPath(),
        													 i18n("*.xml|XML files\n*|All files"),
        													 this,
        													 i18n("Save as...")
        													);
  if(!url.isEmpty())
  	{ doc->saveDocument(url);
    	m_Actions.fileOpenRecent->addURL(url);
    	setCaption(url.fileName(), doc->isModified());
    	
    	m_Actions.fileSave->setEnabled(false);	
  	}

  slotStatusMsg(i18n("Ready."));
}

void KXMLEditorApp::slotFileClose()
{
  slotStatusMsg(i18n("Closing file..."));

  close();

  slotStatusMsg(i18n("Ready."));
}

void KXMLEditorApp::slotFilePrint()
{
  slotStatusMsg(i18n("Printing..."));

  QPrinter printer;
  if (printer.setup(this))
  {
    view->print(&printer);
  }

  slotStatusMsg(i18n("Ready."));
}

void KXMLEditorApp::slotFileQuit()
{
  slotStatusMsg(i18n("Exiting..."));
  saveOptions();
  // close the first window, the list makes the next one the first again.
  // This ensures that queryClose() is called on each window to ask for closing
  KMainWindow* w;
  if(memberList)
  {
    for(w=memberList->first(); w!=0; w=memberList->first())
    {
      // only close the window if the closeEvent is accepted. If the user presses Cancel on the saveModified() dialog,
      // the window and the application stay open.
      if(!w->close())
				break;
    }
  }	
  slotStatusMsg(i18n("Ready."));
}

void KXMLEditorApp::slotEditCut()
{
  slotStatusMsg(i18n("Cutting selection..."));
	view->editCut();
  slotStatusMsg(i18n("Ready."));
}

void KXMLEditorApp::slotEditCopy()
{
  slotStatusMsg(i18n("Copying selection to clipboard..."));
	view->editCopy();
  slotStatusMsg(i18n("Ready."));
}

void KXMLEditorApp::slotEditPaste()
{
  slotStatusMsg(i18n("Inserting clipboard contents..."));
	view->editPaste();
  slotStatusMsg(i18n("Ready."));
}

/** Show/Hide tool bar */
void KXMLEditorApp::setToolBarState(const char *szName, bool bShow)
{
	KToolBar *pToolBar = toolBarByName(szName);
  if(!pToolBar)
    return;

  // turn toolbar on or off
  if(!bShow)
  	{ pToolBar->hide();
  	}
  else
  	{ pToolBar->show();
  	}		
}

void KXMLEditorApp::slotViewStatusBar()
{
  slotStatusMsg(i18n("Toggle the statusbar..."));
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  if(!m_Actions.settingsShowStatusBar->isChecked())
  {
    statusBar()->hide();
  }
  else
  {
    statusBar()->show();
  }

  slotStatusMsg(i18n("Ready."));
}


void KXMLEditorApp::slotStatusMsg(const QString &text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG);
}

/** Display Search dialog and find string in XML document */
void KXMLEditorApp::slotEditFind()
{
	slotStatusMsg(i18n("Search in XML document ..."));
	
	SearchDlg dlg(this, 0, true);
	if(dlg.exec() == SearchDlg::Accepted)
		{ view->searchString(dlg.m_strSearchedString,
												 dlg.m_bMatchCase,
												 dlg.m_bElementNames,
												 dlg.m_bAttributeNames,
												 dlg.m_bAttributeValues,
												 dlg.m_bContents
											  );
		}
		
	slotStatusMsg(i18n("Ready."));
}

/** Find next occurence of string in XML document */
void KXMLEditorApp::slotEditFindNext()
{
	slotStatusMsg(i18n("Search in XML document ..."));
		
	if(!SearchDlg::m_strSearchedString.isEmpty())
		{ view->searchString(SearchDlg::m_strSearchedString,
												 SearchDlg::m_bMatchCase,
												 SearchDlg::m_bElementNames,
												 SearchDlg::m_bAttributeNames,
												 SearchDlg::m_bAttributeValues,
												 SearchDlg::m_bContents
											  );
		}
		
	slotStatusMsg(i18n("Ready."));
}
/** Insert XML element into document */
void KXMLEditorApp::slotXmlInsertElement()
{
	slotStatusMsg(i18n("Insert XML elelemt into document ..."));
	view->xmlInsertElement();
	slotStatusMsg(i18n("Ready."));
}
/** Edit XML element propetries */
void KXMLEditorApp::slotXmlEditElement()
{
	slotStatusMsg(i18n("Edit XML element propetries ..."));
	view->xmlEditElement();
	slotStatusMsg(i18n("Ready."));
}
/** Delete XML element from document */
void KXMLEditorApp::slotXmlDeleteElement()
{
	slotStatusMsg(i18n("Delete XML element from document ..."));
	view->xmlDeleteElement();
	slotStatusMsg(i18n("Ready."));
}
/** Insert XML Attribute into element list */
void KXMLEditorApp::slotXmlInsertAttribute()
{
	slotStatusMsg(i18n("Insert XML Attribute into element list ..."));
	view->xmlInsertAttribute();
	slotStatusMsg(i18n("Ready."));
}
/** Edit XML atttribute properties */
void KXMLEditorApp::slotXmlEditAttribute()
{
	slotStatusMsg(i18n("Edit XML atttribute properties ..."));
	view->xmlEditAttribute();
	slotStatusMsg(i18n("Ready."));
}
/** Delete XML attribute from element */
void KXMLEditorApp::slotXmlDeleteAttribute()
{
	slotStatusMsg(i18n("Delete XML attribute from element ..."));
	view->xmlDeleteAttribute();
	slotStatusMsg(i18n("Ready."));
}
/** Insert XML element contents */
void KXMLEditorApp::slotXmlInsertContents()
{
	slotStatusMsg(i18n("Insert XML element contents ..."));
	view->xmlInsertContents();
	slotStatusMsg(i18n("Ready."));
}
/** Edit XML element contents */
void KXMLEditorApp::slotXmlEditContents()
{
	slotStatusMsg(i18n("Edit XML element contents ..."));
	view->xmlEditContents();
	slotStatusMsg(i18n("Ready."));
}
/** Delete XML element contents */
void KXMLEditorApp::slotXmlDeleteContents()
{
	slotStatusMsg(i18n("Delete XML element contents ..."));
	view->xmlDeleteContents();
	slotStatusMsg(i18n("Ready."));
}

/** Insert new XML Processing instruction */
void KXMLEditorApp::slotXmlInsertProcInstruction()
{
	slotStatusMsg(i18n("Insert XML processing instruction ..."));
	view->xmlInsertProcInstruction();
	slotStatusMsg(i18n("Ready."));
}
/** Edit XML Processing Instruction */
void KXMLEditorApp::slotXmlEditProcInstruction()
{
	slotStatusMsg(i18n("Edit XML processing instruction ..."));
	view->xmlEditProcInstruction();
	slotStatusMsg(i18n("Ready."));
}
/** Delete XML Processing Instruction */
void KXMLEditorApp::slotXmlDeleteProcInstruction()
{
	slotStatusMsg(i18n("Delete XML processing instruction ..."));
	view->xmlDeleteProcInstruction();
	slotStatusMsg(i18n("Ready."));
}


/** Move item in tree view Up */
void KXMLEditorApp::slotXmlMoveItemUp()
{
	view->xmlMoveItemUp();
}
/** Move item in tree view Down */
void KXMLEditorApp::slotXmlMoveItemDown()
{
	view->xmlMoveItemDown();
}

/** Called, when selected element in XML tree view is changed */
void KXMLEditorApp::slotSelectedElementChanged( const XmlTreeItem * const pElement )
{
	m_Actions.editCut->setEnabled(true);
  m_Actions.editCopy->setEnabled(true);
  m_Actions.editPaste->setEnabled(true);

  m_Actions.goUp->setEnabled(true);

  m_Actions.bookmarksToggle->setEnabled(true);

  XmlTreeItem::enItemType type = pElement->itemType();

	m_Actions.xmlEditElement->setEnabled( type == XmlTreeItem::itemElement );
	m_Actions.xmlDeleteElement->setEnabled( type == XmlTreeItem::itemElement );
	
	m_Actions.xmlInsertAttribute->setEnabled( type == XmlTreeItem::itemElement );
	m_Actions.xmlEditAttribute->setEnabled( type == XmlTreeItem::itemElement );
	m_Actions.xmlDeleteAttribute->setEnabled( type == XmlTreeItem::itemElement );
	
	m_Actions.xmlInsertContents->setEnabled( type == XmlTreeItem::itemElement );
	m_Actions.xmlEditContents->setEnabled( type == XmlTreeItem::itemText | type == XmlTreeItem::itemCDATA | type == XmlTreeItem::itemComment );
	m_Actions.xmlDeleteContents->setEnabled( type == XmlTreeItem::itemText | type == XmlTreeItem::itemCDATA | type == XmlTreeItem::itemComment );

	m_Actions.xmlEditProcInstr->setEnabled( type == XmlTreeItem::itemProcInstr );
	m_Actions.xmlDeleteProcInstr->setEnabled( type == XmlTreeItem::itemProcInstr );
	
	m_Actions.xmlMoveItemUp->setEnabled(true);
	m_Actions.xmlMoveItemDown->setEnabled(true);

	m_Actions.pathCombo->insertItem( pElement->pixmap(0) ? QPixmap(*pElement->pixmap(0)) : QPixmap(), pElement->path(0) );

	m_Actions.xmlExpandNode->setEnabled( pElement->childCount() != 0 );
	m_Actions.xmlCollapseNode->setEnabled( pElement->childCount() != 0 );
}

/** Called, when path combo is activated. */
void KXMLEditorApp::slotPathComboActivated(const QString & szPath)
{
	if(! view->changePath(szPath))
		m_Actions.pathCombo->removeItem(szPath); // path not found, remove it from combo
}

/** Clear location bar */
void KXMLEditorApp::slotClearLocationBar()
{
	m_Actions.pathCombo->slotClearEdit();
	m_Actions.pathCombo->slotFocusEdit();
	view->slotUnselect();
}

/** Move selected item Up to parent item */
void KXMLEditorApp::slotUp()
{
	view->goUp();
}
/** Toggle bookmark on selected item */
void KXMLEditorApp::slotToggleBookmark()
{
	view->toggleBookmark();

  m_Actions.bookmarksPrev->setEnabled(true);
  m_Actions.bookmarksNext->setEnabled(true);
}
/** Search previous bookmark */
void KXMLEditorApp::slotBookmarkPrev()
{
	view->bookmarkPrev();
}
/** Search next bookmark */
void KXMLEditorApp::slotBookmarkNext()
{
	view->bookmarkNext();
}
/** Expand tree item subtree */
void KXMLEditorApp::slotExpandNode()
{
	view->expandNode(-1);
}
/** Collapse tree item subtree */
void KXMLEditorApp::slotCollapseNode()
{
	view->collapseNode(-1);
}

/** Called when menu item from Expand Node button is selected */
void KXMLEditorApp::slotExpandNodeActivated(int id)
{
	view->expandNode(id);
}

/** Called when menu item from Collapse Node button is selected */
void KXMLEditorApp::slotCollapseNodeActivated(int id)
{
	view->collapseNode(id);
}

/** Configure application toolbars */
void KXMLEditorApp::slotConfigToolbars()
{
	saveMainWindowSettings(KGlobal::config(), "XmlExplMainWindow");
  QString savedPath = m_Actions.pathCombo->currentText();
	const QPixmap * pTmp = m_Actions.pathCombo->currentPixmap();
  QPixmap savedPixmap = ( pTmp ? QPixmap(*pTmp) : QPixmap() );
	KEditToolbar dlg(actionCollection());

	if (dlg.exec())
		{ createGUI();

			if( ! savedPath.isEmpty() )
     		m_Actions.pathCombo->insertItem( savedPixmap, savedPath );
		}
}

void KXMLEditorApp::slotShowToolBar()
{
  toggleBar("mainToolBar");
}

void KXMLEditorApp::slotShowXmlToolBar()
{
  toggleBar("xmlToolBar");
}

void KXMLEditorApp::slotShowLocationBar()
{
  toggleBar("pathToolBar");
}

/** Show/Hide tool bar */
void KXMLEditorApp::toggleBar(const char *szName)
{
	KToolBar *bar = toolBarByName(szName);
  if(!bar)
    return;

  if(bar->isVisible())
    bar->hide();
  else
    bar->show();

  //saveMainWindowSettings(KGlobal::config(), "XmlExplMainWindow");
  //KGlobal::config()->sync();
  // otherwise changing toolbar style in kcontrol will lose our changes
}
/** Retreive pointer to toolbart from name */
KToolBar * KXMLEditorApp::toolBarByName(const char *szName)
{
	KToolBar *bar = static_cast<KToolBar *> (child(szName, "KToolBar"));
  return bar;
}

/** Configure XML Explorer options */
void KXMLEditorApp::slotConfigure()
{
	// I read that no widgets should be created on the stack
  OptionsDialog *pDlg = new OptionsDialog(0, "tabdialog");
	connect(pDlg, SIGNAL(configurationChanged()), this, SLOT(slotConfigurationChanged()));

 	// run options dialog
 	pDlg->exec();

  delete pDlg;
}

/** Called, when user press Apply or Ok button in Options dialog */
void KXMLEditorApp::slotConfigurationChanged()
{
	view->getElementsTreeView()->setRootIsDecorated(OptionsDialog::getTreeViewRootDecorated());

	view->getElementsTreeView()->setAcceptDrops(OptionsDialog::getTreeViewEnableDragDrop());
  view->getElementsTreeView()->viewport()->setAcceptDrops(OptionsDialog::getTreeViewEnableDragDrop());

	if(OptionsDialog::getTreeViewElemDisplayMode() == 0)
		{ if(view->getElementsTreeView()->columns() == 3)
				view->getElementsTreeView()->removeColumn(2);
		}
	else
		{ if(view->getElementsTreeView()->columns() == 2)
				view->getElementsTreeView()->addColumn(i18n("Attributes"));
				view->updateStringAttrLists();
		}

	// save the new configuration to our config file
	OptionsDialog::saveConfiguration(config);
}


/** Configure key bindings */
void KXMLEditorApp::slotConfigureKeys()
{
	KKeyDialog::configureKeys(actionCollection(), xmlFile());
}

/** Return path from combo */
QString KXMLEditorApp::path()
{
	return m_Actions.pathCombo->currentText();
}

void KXMLEditorApp::slotDocumentModified()
{
	m_Actions.fileSave->setEnabled(true);
	setCaption(doc->URL().fileName(), true);
}
