/***************************************************************************
                          xmlstructureparser.h  -  description
                             -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001 by Lumir Vanek
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef XMLSTRUCTUREPARSER_H
#define XMLSTRUCTUREPARSER_H

#include <qxml.h>
#include <qstack.h>
#include <qlist.h>
#include <qstring.h>

#include "xml_base.h"

class KXMLEditorDoc;
class XmlTreeView;

/**XML structure parser - parses XML and create XML tree in memory
	Based on QT sample: "Demonstration of SAX2 features"
  *@author Lumir Vanek
  */

class XmlStructureParser : public QXmlDefaultHandler
{
public:
	XmlStructureParser(XmlTreeView *, KXMLEditorDoc *);
  virtual ~XmlStructureParser() {;}

  // Content handler overrides
  bool startDocument();
  bool startElement(const QString&, const QString&, const QString&, const QXmlAttributes&);
  bool endElement(const QString&, const QString&, const QString&);
	bool characters(const QString&);
	bool processingInstruction(const QString &, const QString&);
	
	// Lexical handrer overrides
	bool startCDATA();
	bool endCDATA();
 	bool startDTD(const QString&, const QString&, const QString&);
 	bool endDTD();
	bool comment(const QString&);
		
	// Error handler overrides
	bool warning(const QXmlParseException &);
	bool error(const QXmlParseException &);
	bool fatalError(const QXmlParseException &);
	QString errorString();

	const QString GetErrorMsg() const { return m_strErrorMsg; }
	int		GetColumnNumber()	{ return m_iColumnNumber; }
	int		GetLineNumber()	{ return m_iLineNumber; }
	
	void pushXmlElement(XmlElement *pXmlElement)
		{ m_stackOfXmlElements.push(pXmlElement);
		}

protected:
	QString m_strErrorMsg;
	int			m_iColumnNumber;
	int			m_iLineNumber;
	
	bool		m_bStartCDATA;

private:
  QStack<XmlElement> m_stackOfXmlElements;

	// View that display XML tree structure
	XmlTreeView* m_pListWiew;
	
	// XML document
	KXMLEditorDoc *m_pDocument;
};

#endif
