/***************************************************************************
                          xmlattributedlg.cpp  -  description
                             -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001 by Lumir Vanek
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "xmlattributedlg.h"

#include <qlineedit.h>
#include <qpushbutton.h>

XmlAttributeDlg::XmlAttributeDlg(QWidget *parent, const char *name, bool modal)
	: XmlAttributeDlgBase(parent, name, modal)
{
	if(m_strAttributeName.isEmpty())
		m_pPushButtonOk->setEnabled(false);
	else
		m_pPushButtonOk->setEnabled(true);

	m_pEditAttributeName->setFocus();
	m_pPushButtonOk->setDefault(true);
}

XmlAttributeDlg::~XmlAttributeDlg()
{
}

/** Called, when user press OK button */
void XmlAttributeDlg::slotOk()
{
	m_strAttributeName = m_pEditAttributeName->text();
	m_strAttributeValue = m_pEditAttributeValue->text();
	accept();
}
/** Called, when XML attribute name is changed in edit line */
void XmlAttributeDlg::slotAttributeNameChanged(const QString &string)
{
	if(string.isEmpty())
		m_pPushButtonOk->setEnabled(false);
	else
		m_pPushButtonOk->setEnabled(true);
}
