/***************************************************************************
                          xml_base.h  -  description
                             -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001 by Lumir Vanek
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef XML_BASE_H
#define XML_BASE_H


#include <klistview.h>

class QPixmap;
class XmlTreeView;

/**XML attribute - contain name and attribute value
  *@author Lumir Vanek
  */

class XmlAttribute
{
public:
	XmlAttribute(const QString&, const QString&);
	
	/** Return XML attribute name */
	QString		name() const { return m_strName; }
	
	/** Return XML attribute value */
	QString		value() const { return m_strValue; }
	
	/** Set XML attribute name */
	void		setName(const QString &strName) { m_strName = strName; }
	
	/** Set XML attribute value */
	void		setValue(const QString &strValue) { m_strValue = strValue; }
	
protected:
	/** XML attribute name */
	QString		m_strName;

	/** XML attribute value */
	QString m_strValue;
};

class XmlTreeItem : public QListViewItem
{
public:
// All possible types of tree items
enum enItemType
{
	itemElement, itemText, itemCDATA, itemComment, itemProcInstr
};

// All possible results of searchString
enum enSearchResult
{
	searchNotFound, searchFoundInElementName, searchFoundInAttributeName,
	searchFoundInAtributeValue, searchFoundInContents
};

static	QCString m_strSubtypeXML;
static	QCString m_strSubtypeXML_text;
static	QCString m_strSubtypeXML_cdata;
static	QCString m_strSubtypeXML_comment;
static 	QCString m_strSubtypeXML_procins;

	XmlTreeItem(KListView *, const QString&, const QString&);
	XmlTreeItem(QListViewItem *, const QString&, const QString&);

	/**  Return type of XML item. Must be redefined by derived classes */
	virtual enItemType itemType() const = 0;
	
	/** Search string in XML element, if not found search in child elements */
  virtual enSearchResult searchString(const QString &, bool, bool, bool, bool, bool, QListViewItem **, bool*) = 0;
	
	/** Save XML to string */
  virtual void save(QString &, unsigned int) = 0;

  /** Return contents type as text string */
  const QCString contentsTypeAsText() const;

  /** Accept drops of this MIME types ? */
  bool acceptsDrops( const QStrList &);

  /** Test, if item in parameter is my direct or indirect child item */
  bool isMyChildren(const XmlTreeItem *);

  /** Return path for this XML item as string */
  virtual QString path(const XmlTreeItem *) const;

  /** Enable/disable bookmark on this tree item */
  bool toggleBookmark();

  bool hasBookmark() const { return m_bBookmark; }

  /** Expand tree node up to level specified in parameter. /-1: expand entire node/.  */
  void expandNode(int = -1, int = 1);

  /** Collapse tree node from level specified in parameter. /-1: collapse entire node/.  */
  void collapseNode(int = -1, int = 1);

  /** Search item fith path from parameter */
  virtual XmlTreeItem *searchPath(const QString &) = 0;

  /** Pixmap for XML element in KListWiew */
static  QPixmap* m_pPixmapElement;

	/** Pixmap for XML text in KListWiew */
static  QPixmap* m_pPixmapText;

	/** Pixmap for XML CDATA in KListWiew */
static  QPixmap* m_pPixmapCDATA;

	/** Pixmap for XML comment in KListWiew */
static  QPixmap* m_pPixmapComment;

	/** Pixmap for XML processing instriction in KListWiew */
static  QPixmap* m_pPixmapProcInstr;

	/** Pixmap for bookmark in KListWiew */
static  QPixmap* m_pPixmapBookmark;

protected:
	bool m_bBookmark;
};

/**XML processing instruction - contain target and data value
  *@author Lumir Vanek
  */
class XmlProcessingInstruction : public XmlTreeItem
{
public:
	XmlProcessingInstruction(XmlTreeView *, const QString &, const QString &);
	XmlProcessingInstruction(QListViewItem *, const QString &, const QString &);
	
	/**  Return type of tree item */
	enItemType itemType() const { return itemProcInstr; }
		
	// Return processing instruction target
	QString		target() const { return m_strTarget; }
	
	// Return processing instruction data
	QString		data() const { return m_strData; }
	
	/** Save XML to string */
  void save(QString &, unsigned int);

  /** Search item with path from parameter */
  XmlTreeItem * searchPath(const QString &);

  /** Return path for this XML item as string */
  QString path(const XmlTreeItem *) const;

  /** Search string in XML element, if not found search in child elements */
  enSearchResult searchString(const QString &, bool, bool, bool, bool, bool, QListViewItem **, bool*);

  /** Set Target and Data*/
  void setTargetData(const QString &, const QString &);
  /** Set Proccessing instruction Target and data from string */
  bool setContents(const QString &);
	
protected:
	// Processing instruction target
	QString m_strTarget;
	
	// Processing instruction data
	QString m_strData;
};

/**XML contents - contain text and info, if type is text, CDATA or comment
  *@author Lumir Vanek
  */
class XmlContentsItem : public XmlTreeItem
{
public:
	XmlContentsItem(XmlTreeView *, const QString &, enItemType);
	XmlContentsItem(QListViewItem *, const QString &, enItemType);

	/**  Return XML contents string */
	QString contents() const { return m_strContents; }
		
	/**  Return type of tree item */
	enItemType itemType() const { return m_eItemType; }
	
  /** Set contents type as text string */
  void setContents(const QString &strContents);

	/**  Set type of XML contents */
  void setItemType(enItemType eItemType);

  /** Search string in XML element, if not found search in child elements */
  enSearchResult searchString(const QString &, bool, bool, bool, bool, bool, QListViewItem **, bool*);
	
  /** Save XML to string */
  void save(QString &, unsigned int);

  /** Search item with path from parameter */
  XmlTreeItem * searchPath(const QString &);

  /** Return path for this XML item as string */
  QString path(const XmlTreeItem *) const;
  	
protected:
		/**  XML contents string */
		QString	 m_strContents;
	
		/**  Tree item type */
		enItemType		m_eItemType;
};

/**
	XML element - contain name, attributes list and child elements list
  *@author Lumir Vanek

  */
class XmlElement : public XmlTreeItem
{
public:
	XmlElement(XmlTreeView *, const QString&, const QString&);
	XmlElement(QListViewItem *, const QString&, const QString&);
	
	/**  Return type of tree item */
	XmlTreeItem::enItemType itemType() const { return XmlTreeItem::itemElement; }
	
	// Append XML attribute to list
	void appendAttribute(const XmlAttribute* attribute)
		{ m_listOfAttributes.append(attribute);
		}
		
	// Remove attribute from list
	void removeAttribute(unsigned int index)
		{ m_listOfAttributes.remove(index);
		}

	//** Return pointer to list of XML attributes */
	QList<XmlAttribute> * GetListOfAttributes() { return &m_listOfAttributes; }

	/** Search string in XML element, if not found search in child elements */
  enSearchResult searchString(const QString &, bool, bool, bool, bool, bool, QListViewItem **, bool*);

  /** Save XML to string */
  void save(QString &, unsigned int);

  /** Search item with path from parameter */
  XmlTreeItem * searchPath(const QString &);

  /** Return path for this XML item as string */
  QString path(const XmlTreeItem *) const;

  /** Update column with list of attributes */
  void updateStringAttrList();

protected: // Protected attributes

	//** List of XML attributes for this element */
	QList<XmlAttribute> m_listOfAttributes;
protected: // Protected methods

};

/** Replaces special characters with appropriate equvivalents */
QString prepareXmlForSave(const QString &);

/** Test string, if contain any useful character */
bool containUsefulCharacter(const QString &);

/** Remove useless characters from string */
QString removeUselessCharacters(const QString &);


#endif
