/***************************************************************************
                          kxmleditordoc.h  -  description
                             -------------------
    begin                : t ec 10 12:39:26 CEST 2001
    copyright            : (C) 2001 by Lumir Vanek
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXMLEDITORDOC_H
#define KXMLEDITORDOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for QT
#include <qobject.h>
#include <qstring.h>
#include <qlist.h>

// include files for KDE
#include <kurl.h>

// forward declaration of the KXMLEditor classes
class KXMLEditorView;

/**	KXMLEditorDoc provides a document object for a document-view model.
  *
  * The KXMLEditorDoc class provides a document object that can be used in conjunction with the classes KXMLEditorApp and KXMLEditorView
  * to create a document-view model for standard KDE applications based on KApplication and KMainWindow. Thereby, the document object
  * is created by the KXMLEditorApp instance and contains the document structure with the according methods for manipulation of the document
  * data by KXMLEditorView objects. Also, KXMLEditorDoc contains the methods for serialization of the document data from and to files.
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team. 	
  * @version KDevelop version 1.2 code generation
  */
class KXMLEditorDoc : public QObject
{
  Q_OBJECT
public:
    /** Constructor for the fileclass of the application */
    KXMLEditorDoc(QWidget *parent, const char *name=0);

    /** Destructor for the fileclass of the application */
    ~KXMLEditorDoc();

    /** adds a view to the document which represents the document contents. Usually this is your main view. */
    void addView(KXMLEditorView *view);

    /** removes a view from the list of currently connected views */
    void removeView(KXMLEditorView *view);

    /** sets the modified flag for the document after a modifying action on the view connected to the document.*/
    void setModified(){ if (! modified) { modified=true; emit sigModified(); } }

    /** returns if the document is modified or not. Use this to determine if your document needs saving by the user on closing.*/
    bool isModified(){ return modified; };

    /** "save modified" - asks the user for saving if the document is modified */
    bool saveModified();	

    /** deletes the document's contents */
    void deleteContents();

    /** initializes the document generally */
    bool newDocument();

    /** closes the acutal document */
    void closeDocument();

    /** loads the document by filename and format and emits the updateViews() signal */
    bool openDocument(const KURL&, const QString &, const char * = 0);

    /** saves the document under filename and format.*/	
    bool saveDocument(const KURL&, const char * = 0);

    /** returns the KURL of the document */
    const KURL& URL() const;

    /** sets the URL of the document */
	  void setURL(const KURL& url);

		void setEncoding(const QString& strEncoding) { m_strEncoding = strEncoding; }

		const QString encoding() const { return m_strEncoding; }
		
		const QString compressedTarEntryName() const { return m_strCompressedTarEntryName; }
	
public slots:
    /** calls repaint() on all views connected to the document object and is called by the view by which the document has been changed.
     * As this view normally repaints itself, it is excluded from the paintEvent.
     */
    void slotUpdateAllViews(KXMLEditorView *sender);
 	
public:	
  /** the list of the views currently connected to the document */
  static QList<KXMLEditorView> *pViewList;	

signals:
  void sigModified();

private:
    /** the modified flag of the current document */
    bool modified;

    KURL doc_url;

protected: // Protected attributes

  /** Encoding for this document */
  QString m_strEncoding;

  /** Name of entry in Tar archive */
  QString m_strCompressedTarEntryName;

  /** true, if file is readed from KTarGz */
  bool m_bIsCompressed;
};

#endif // KXMLEDITORDOC_H
