/***************************************************************************
                          actions.h  -  description
                             -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001 by Lumir Vanek
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ACTIONS_H
#define ACTIONS_H

#include <kaction.h>

class QLabel;
class QComboBox;

/**
  *@author Lumir Vanek
  */

class KXmlEditorComboAction : public KAction
{
  Q_OBJECT
public:
	KXmlEditorComboAction(const QString& text, int accel, const QObject *receiver, const char *member, QObject* parent, const char* name);
	~KXmlEditorComboAction();

    virtual int plug(QWidget *w, int index = -1);

    virtual void unplug(QWidget *w);

    /** Returns the text from the combobox' editline (@ref QComboBox::currentText). */
    QString currentText() const;
    /** Returns the current pixmap or 0, if there isn't any (see @ref QComboBox::pixmap). */
    const QPixmap * currentPixmap() const;

    /**
     * Inserts the given item as the first.
     * Deletes the old entry, if the item was already in the list.
     */
    void insertItem( const QPixmap & pixmap, const QString & text );
    /** Tries to remove the item with the given text. */
    void removeItem( const QString & text );

public slots:
    /** Clears the whole combobox using @ref QComboBox::clear. */
    void slotClear();
    /** Clears the combobox's editline and gives focus to the combobox. */
    void slotClearEdit();

protected:
    /**
     * Tries to find an item with the given text. If it finds it,
     * the items id is returned, otherwise -1.
     */
    virtual int findItem( const QString & text );

private:
    const QObject *m_receiver;
    const char *m_member;
    QComboBox * m_pCombo;
};



/**Based on KonqLabelAction from Konqueror

  *@author Lumir Vanek
  */

class KXmlEditorLabelAction : public KAction
{
  Q_OBJECT
public:
  KXmlEditorLabelAction(const QString &text, QObject *parent = 0, const char *name = 0);

  virtual int plug(QWidget *widget, int index = -1);
  virtual void unplug(QWidget *widget);
  QLabel * label() { return m_label; }

private:
  QLabel * m_label;
};

#endif
