#include <kxmainwindow.h>
#include <qcheckbox.h>
#include "kxstatusmessagedialogimpl.h"
#include <qmultilineedit.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <kxengine.h>
#include <kxcontact.h>
#include <klocale.h>
/* 
 *  Constructs a kxStatusMessageDialogImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
kxStatusMessageDialogImpl::kxStatusMessageDialogImpl( UIN _uin, QString _msg, QWidget* parent,  const char* name, bool modal, WFlags fl )
    : kxStatusMessageDialog( parent, name, modal, fl )
{
  QObject::connect(saveButton,SIGNAL(clicked()), this, SLOT(SlotOkButton()));
  uin=_uin;
  message->setText(_msg); 
  message->setReadOnly(TRUE);
  cancelButton->hide();
  if (ENGINE->CONTACT->getIgnoreAway(_uin)) { hide(); return; } 
  topicLabel->setText(ENGINE->CONTACT->getContact(_uin).nick+i18n(" is ")+ENGINE->CONTACT->status2str(ENGINE->CONTACT->getContact(_uin).status)+". ");
  saveButton->setText(i18n("Ok"));
  saveButton->setFocus();
  ok=TRUE;
}
kxStatusMessageDialogImpl::kxStatusMessageDialogImpl( UIN _uin, int _status, QWidget* parent,  const char* name, bool modal, WFlags fl )
    : kxStatusMessageDialog( parent, name, modal, fl )
{
  modalDialog=modal;
  QObject::connect(saveButton,SIGNAL(clicked()), this, SLOT(SlotOkButton()));
  QObject::connect(cancelButton,SIGNAL(clicked()), this, SLOT(SlotCancelButton()));
  uin=_uin;
  status=_status;
  message->setText(ENGINE->getStatusMessages(_status)); 
  message->setFocus();
  dontShow->hide();  
  topicLabel->setText(i18n("Set message for ")+ENGINE->CONTACT->status2str(status)+" status. ");
  saveButton->setText(i18n("Save"));
  message->setFocus();
  ok=TRUE;
}

/*  
 *  Destroys the object and frees any allocated resources
 */
kxStatusMessageDialogImpl::~kxStatusMessageDialogImpl()
{
    // no need to delete child widgets, Qt does it all for us
}

void kxStatusMessageDialogImpl::hide()
{
  ENGINE->CONTACT->setIgnoreAway(uin,dontShow->isChecked());
  debug("Close/Hide !!");
  QDialog::hide();
  if (!modalDialog) delete this;
}  
void kxStatusMessageDialogImpl::SlotOkButton()
{
  if (ok) accept();
  else
  {
    MAINWINDOW->updateStatusMessage(status,message->text());
    hide();
  }  
}
void kxStatusMessageDialogImpl::SlotCancelButton()
{
  if (ok) reject();
  else hide();
}
