#include <kxinfodialogimpl.h>
#include <kwin.h>
#include <qtextbrowser.h>
#include "kxsendmessagesimpl.h"
#include "kxcontact.h"
#include "kxengine.h"
#include <qlabel.h>
#include <qobject.h>
#include <qmultilineedit.h>
#include <kxudp.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qdialog.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <kaccel.h>
#include <klocale.h>
#include <kxmainwindow.h>
#include <kxmessage.h>
#include <v2_codes.h>
#include <kxtextbrowser.h>
#include <kprocess.h>
#include <kcolordialog.h>

/* 
 *  Constructs a kxSendMessagesImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
kxSendMessagesImpl::kxSendMessagesImpl( UIN _uin, bool _first,QWidget* parent,  const char* name, bool modal, WFlags fl )
    : kxSendMessages( parent, name, modal, fl )
{
  uin=_uin;
  showFirst=_first;
  init();
}
kxSendMessagesImpl::kxSendMessagesImpl( UIN _uin, bool _first,QString _txt, QWidget* parent,  const char* name, bool modal, WFlags fl )
    : kxSendMessages( parent, name, modal, fl )
{

  uin=_uin;
  showFirst=_first;
  init();
 
  messageInput->append(_txt);
}
kxSendMessagesImpl::kxSendMessagesImpl( UIN _uin, QWidget* parent,  const char* name, bool modal, WFlags fl )
    : kxSendMessages( parent, name, modal, fl )
{

  uin=_uin;
  showFirst=FALSE;
  init();
}
void kxSendMessagesImpl::init()
{
// FIXME
  autoPopup->hide();
  KWin::setIcons(winId(),MAINWINDOW->kxIcons.message,MAINWINDOW->kxIcons.message);

  fgColor=ENGINE->CONTACT->getFGColor(uin);
	bgColor=ENGINE->CONTACT->getBGColor(uin);	
  useColor=FALSE;

  alert=FALSE;
  showAlert=FALSE;
  QObject::connect(&alertTimer, SIGNAL(timeout()), this, SLOT(SlotAlertTimeout()));
  ENGINE->CONTACT->setSendWidget(uin,this);
  historyView=NULL;

  QStringList list;
  QString tmp;
  for (int t=1; t<=50; t++)
  {
    tmp.sprintf("kde/%04d",t);
    list.append(tmp);
  }

  sendAnim=new KAnimWidget(list, 22, animLabel, "anim");
  sendAnim->resize(25,25);

  doSend=FALSE;
  sendSeq=0;
  send=NULL;
  clean=TRUE;
  QString tmpStr;
  tmpStr.sprintf("%d",uin);  
  uinLabel->setText(tmpStr.latin1());
  nickLabel->setText(ENGINE->CONTACT->getContact(uin).nick); 
  nick=ENGINE->CONTACT->getContact(uin).nick;
  makeCaption(ENGINE->CONTACT->getContact(uin).status);  

  QObject::connect(fgColorButton, SIGNAL(clicked()), this, SLOT(SlotFGColor()));
  QObject::connect(bgColorButton, SIGNAL(clicked()), this, SLOT(SlotBGColor()));
  QObject::connect(infoButton, SIGNAL(clicked()), this, SLOT(SlotInfoButton()));  
  QObject::connect(stayOnTop, SIGNAL(toggled(bool)), this, SLOT(SlotStayOnTop(bool)));  
  QObject::connect((QObject *)cancelButton, SIGNAL(clicked()), this, SLOT(SlotCancelButton()));
  QObject::connect((QObject *)sendButton, SIGNAL(clicked()), this, SLOT(SlotSendButton()));
  QObject::connect(messageInput,SIGNAL(textChanged()), this, SLOT(SlotTextChanged()));
  QObject::connect(ENGINE, SIGNAL(SignalContactStatusChange(UIN , Q_UINT16, Q_UINT16 )), this,SLOT(SlotContactStatusChange(UIN , Q_UINT16, Q_UINT16 )));
                                                                                                     
  QObject::connect(MAINWINDOW, SIGNAL(SignalNewMessage(UIN, kxMessageStruct)), this, SLOT(SlotNewMessage(UIN, kxMessageStruct)));
  QObject::connect(ENGINE->MESSAGE, SIGNAL(SignalMessagePosSend(UIN, int)), this, SLOT(SlotMessagePos(UIN, int)));
  QObject::connect((QObject *)historyButton, SIGNAL(clicked()), this, SLOT(SlotHistoryButton()));  
  
  throughServer->setChecked(ENGINE->CONTACT->getContact(uin).alwaysServer);  
                   
  KAccel *a = new KAccel(this);
  a->insertItem(i18n("Send"), "Send",Key_S + ALT);
  a->connectItem("Send",this,SLOT(SlotSendButton()));
  a->insertItem(i18n("Send2"), "Send2",Key_Enter + CTRL);
  a->connectItem("Send2",this,SLOT(SlotSendButton()));
  a->insertItem(i18n("Send3"), "Send3",Key_Return + CTRL);
  a->connectItem("Send3",this,SLOT(SlotSendButton()));
 
  if (showFirst)
  {
    int pos=0;
    
    pos=ENGINE->MESSAGE->giveFirstUnreadMessage(uin);
    while(pos>0)
    {
      kxMessageStruct message;
      message=ENGINE->MESSAGE->getMessage(pos);
      SlotNewMessage(uin,message);
      ENGINE->MESSAGE->setRead(pos,TRUE);
      pos=ENGINE->MESSAGE->giveFirstUnreadMessage(uin);
    }
  }
  
  sendButton->setEnabled(FALSE);

  QPalette pal = messageInput->palette();
  QColor c=fgColor;
  #if QT_VERSION >= 210
    pal.setColor(QPalette::Active, QColorGroup::Text, c);
    pal.setColor(QPalette::Inactive, QColorGroup::Text, c);
  #else
    pal.setColor(QPalette::Active, QColorGroup::Text, c);
    pal.setColor(QPalette::Normal, QColorGroup::Text, c);
  #endif
  c=bgColor;
  #if QT_VERSION >= 210
    pal.setColor(QPalette::Active, QColorGroup::Base, c);
    pal.setColor(QPalette::Inactive, QColorGroup::Base, c);
  #else
    pal.setColor(QPalette::Active, QColorGroup::Base, c);
    pal.setColor(QPalette::Normal, QColorGroup::Base, c);
  #endif		

	messageInput->setPalette(pal);

  textOutput->setNotifyClick(TRUE);
  QObject::connect(textOutput, SIGNAL(mailClick(const QString &, const QString &)), SLOT(slotEMailClick(const QString &, const QString &)));
	QObject::connect(textOutput, SIGNAL(urlClick(const QString &)), SLOT(slotURLClick(const QString &)));
  messageInput->setFocus();
}

void kxSendMessagesImpl::hide()
{
  debug("Close/Hide !!");
  QDialog::hide();
  ENGINE->CONTACT->setSendWidget(uin);
  if (send) delete send;
  delete this;
}  

void kxSendMessagesImpl::SlotCancelButton()
{
  if (doSend)
  {
    sendAnim->stop();
    doSend=FALSE;
    sendButton->setEnabled(TRUE);
    messageInput->setEnabled(TRUE);  
    messageInput->setFocus();  
    if (send) { delete send; send=NULL; }
  }
  else
    close();
}
void kxSendMessagesImpl::SlotSendButton()
{
  if (messageInput->text().length()>0)
  {
    QString sendMsg=messageInput->text();
    sendMsg.replace(QRegExp("\n"),"\r\n");

    send=ENGINE->sendMessage(uin,sendMsg ,throughServer->isChecked(), fgColor, bgColor, useColor);
    if (send==NULL) return;
    doSend=TRUE;
    sendSeq=send->sendSeq;
    sendButton->setEnabled(FALSE);
    messageInput->setEnabled(FALSE);
    sendAnim->start();
    
    QObject::connect(send, SIGNAL(SignalSendToClientOk(int)), this, SLOT(SlotSendToClientOk(int)));
    QObject::connect(send, SIGNAL(SignalSendToClientError(int)), this, SLOT(SlotSendToClientError(int)));  
    QObject::connect(send, SIGNAL(SignalSendToServerOk(int)), this, SLOT(SlotSendToServerOk(int)));
    QObject::connect(send, SIGNAL(SignalSendToServerError(int)), this, SLOT(SlotSendToServerError(int)));  

    QString _tmp;
    messageToSend="";
    if (useColor)
    {
    	messageToSend="<font color=\""+fgColor.name()+"\">";
    }
    messageToSend+=messageInput->text();
    if (useColor)
    {
    	messageToSend+="</font>";
    }
    messageToSend.replace(QRegExp("\n"),"<br>");
    messageToSend.replace(QRegExp("\r"),"");
    debug("MessageToSend: [%s]",messageToSend.latin1());
    if (send->send) SlotSendToServerOk(sendSeq);
  }
}
void kxSendMessagesImpl::SlotNewMessage(UIN _uin, kxMessageStruct _message)
{
  if (uin==_uin)
  {
    QString _tmp;

		QString message=_message.message;
   	message.replace(QRegExp(">"),"&gt;");
   	message.replace(QRegExp("<"),"&lt;");
    parseHTMLtoHRef(message);
    message.replace(QRegExp("\n"),"<br>");
    message.replace(QRegExp("\r"),"");

    _tmp="<B>"+QString(ENGINE->CONTACT->getContact(_uin).nick)+"</B>: ";
    debug("Color: %s",_message.foreground.name().latin1());
    if (MAINWINDOW->kxConfig.useColor && _message.useColor)
    {
    	_tmp+="<font color=\""+_message.foreground.name()+"\">";
    	if ( _message.background!=QColor(255,255,255) && _message.foreground!=QColor(0,0,0))
    	{
  	    QPalette pal = textOutput->palette();
        QColor c=_message.background;
        #if QT_VERSION >= 210
          pal.setColor(QPalette::Active, QColorGroup::Base, c);
          pal.setColor(QPalette::Inactive, QColorGroup::Base, c);
        #else
          pal.setColor(QPalette::Active, QColorGroup::Base, c);
          pal.setColor(QPalette::Normal, QColorGroup::Base, c);
        #endif

  		  textOutput->setPalette(pal);     	
  		}
    }
    _tmp+=message;
    if  (MAINWINDOW->kxConfig.useColor && _message.useColor) _tmp+="</font>";
    debug("Message: [%s]",_tmp.latin1());
    //messageInput->clear();
    if (clean) 
      textOutput->setText(_tmp);
    else
      textOutput->append(_tmp);
    clean=FALSE;
    if (autoRaise->isChecked())
    {
      QDialog::raise();
      show();
      setFocus();
    }    
    if (!hasFocus())
    {
      alert=TRUE;
      showAlert=TRUE;
      alertTimer.start(1000);
    }    
    // scroll to the new text
    textOutput->ensureVisible(0, textOutput->contentsHeight());
    // This should not be a hard coded value like this!!!
    textOutput->repaintContents(0,0, 10000, 20000, true);
  }
}
void kxSendMessagesImpl::SlotMessagePos(UIN _uin,int _pos)
{
  if (uin==_uin)
    ENGINE->MESSAGE->setRead(_pos,TRUE);
}
void kxSendMessagesImpl::SlotTextChanged()
{
  stopAlert();
  int len=messageInput->text().length();
  if (len>0)
    sendButton->setEnabled(TRUE);
  else
    sendButton->setEnabled(FALSE);
  chars->setText(QString("%1").arg(len));
}
void kxSendMessagesImpl::SlotSendToClientError(int _s)
{
  throughServer->setChecked(TRUE);  
  ENGINE->CONTACT->setAlwaysServer(uin,TRUE,FALSE);
  send->sendToServer();
}
void kxSendMessagesImpl::SlotSendToClientOk(int _s)
{
  if (_s==sendSeq)
  {
    QString _tmp;
    parseHTMLtoHRef(messageToSend);
    debug("MessageToSend3 : [%s]",messageToSend.latin1());
    _tmp="<I><B>"+MAINWINDOW->kxConfig.nick+"</B>: "+messageToSend+"</I>";
    messageInput->clear();
    if (clean) 
      textOutput->setText(_tmp);
    else
      textOutput->append(_tmp);
    clean=FALSE;
  
    sendAnim->stop();
    doSend=FALSE;
    sendButton->setEnabled(FALSE);
    messageInput->setEnabled(TRUE);
    messageInput->setFocus();
      
    // scroll to the new text
    textOutput->ensureVisible(0, textOutput->contentsHeight());
    // This should not be a hard coded value like this!!!
    textOutput->repaintContents(0,0, 10000, 20000, true);

    if (send) { delete send; send=NULL; }
  }
}
void kxSendMessagesImpl::SlotSendToServerError(int _s)
{
  if (send) { delete send; send=NULL; }
}
void kxSendMessagesImpl::SlotSendToServerOk(int _s)
{
  if (_s==sendSeq)
  {
    QString _tmp;
    parseHTMLtoHRef(messageToSend);
    debug("MessageToSend2 : [%s]",messageToSend.latin1());
    _tmp="<I><B>"+MAINWINDOW->kxConfig.nick+"</B>: "+messageToSend+"</I>";
    messageInput->clear();
    if (clean) 
      textOutput->setText(_tmp);
    else
      textOutput->append(_tmp);
    clean=FALSE;

    sendAnim->stop();
    doSend=FALSE;
    sendButton->setEnabled(FALSE);
    messageInput->setEnabled(TRUE);    
    messageInput->setFocus();
    // scroll to the new text
    textOutput->ensureVisible(0, textOutput->contentsHeight());
    // This should not be a hard coded value like this!!!
    textOutput->repaintContents(0,0, 10000, 20000, true);

    if (send) { delete send; send=NULL; }
  }
}
void kxSendMessagesImpl::makeCaption(int _st)
{
  if (showAlert)
    setCaption("   "+nick+"  "+ENGINE->CONTACT->status2str(_st)+"   ");
  else
    setCaption("[[ "+nick+" ("+ENGINE->CONTACT->status2str(_st)+")]]");
}
void kxSendMessagesImpl::SlotContactStatusChange(UIN _u, Q_UINT16 _s, Q_UINT16 )
{
  if (_u==uin)
  {
    makeCaption(_s);
  }
}
void kxSendMessagesImpl::SlotHistoryButton()
{
  if (historyView!=NULL)
  {
    delete vbox_2;
    delete historyView;
    historyWidget->setMinimumSize(0,0);
    //vbox->activate();
    resize(width(),height()-100);    
    updateGeometry();    
    historyView=NULL;
    historyButton->setDown(FALSE);    
  }
  else
  {
    debug("show hist! ");
    vbox_2 = new QVBoxLayout( historyWidget );
    vbox_2->setSpacing( 0 );
    vbox_2->setMargin( 0 );   
    historyView = new kxHistoryWidget(uin, historyWidget, "historyView" );
//    historyView->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)4, historyView->sizePolicy().hasHeightForWidth() ) );
    historyView->setFocusPolicy( QListView::NoFocus );
    historyView->show();    
    vbox_2->addWidget( historyView,1 );        
    vbox_2->activate();
    historyWidget->setMinimumSize(0,10);
    historyWidget->setMaximumHeight(100);    
    historyWidget->resize(10,100);    
    
    //vbox->activate();
    resize(width(),height()+100);
    updateGeometry();
    historyButton->setDown(TRUE);
  }
}
void kxSendMessagesImpl::SlotStayOnTop(bool)
{
  if (stayOnTop->isChecked())
  {
    KWin::setState(this->winId(),NET::StaysOnTop);
  }
  else
  {
    KWin::clearState(this->winId(),NET::StaysOnTop);    
  }
}
void kxSendMessagesImpl::SlotInfoButton()
{
  kxInfoDialogImpl *dialog=new kxInfoDialogImpl(uin,0L,"info");
  dialog->show();
}
void kxSendMessagesImpl::SlotAlertTimeout()
{
  showAlert=!showAlert;
  makeCaption(ENGINE->CONTACT->getContact(uin).status);  
  alertTimer.start(1000);
}
void kxSendMessagesImpl::enterEvent(QEvent *e)
{
  stopAlert();
  QWidget::enterEvent(e);
}
void kxSendMessagesImpl::focusInEvent(QFocusEvent *e)     
{
  stopAlert();
  QWidget::focusInEvent(e);
}
void kxSendMessagesImpl::mousePressEvent(QMouseEvent *e)
{
  stopAlert();
  QWidget::mousePressEvent(e);
}
void kxSendMessagesImpl::keyPressEvent(QKeyEvent *e)
{
  stopAlert();
  QWidget::keyPressEvent(e);
}
void kxSendMessagesImpl::stopAlert()
{
  if (alert)
  {
    alert=FALSE;
    showAlert=FALSE;
    alertTimer.stop();
    makeCaption(ENGINE->CONTACT->getContact(uin).status);  
  }
}
/** there is clicked on a URL in the output widget, now we must handle the URL
start Konq. for example */
void kxSendMessagesImpl::slotURLClick(const QString &s)
{
	debug("URL: %s",s.latin1());
  QString cmdLine="kfmclient exec %s";
  QString url=s;

  // replace "%s" with the clipboard contents
  // replace \%s to %s
  // currently, only the first %s will be replaced... fix this?
  int pos = cmdLine.find("%s");
  if ( pos >= 0 ) {
      bool doReplace = true;
      if ( pos > 0 && cmdLine.at( pos -1 ) == '\\' ) {
          cmdLine.remove( pos -1, 1 ); // \%s -> %s
          doReplace = false;
      }

      if ( doReplace )
          cmdLine.replace( pos, 2, url );
  }

  // escape $ to avoid it being expanded by the shell
  cmdLine.replace( QRegExp( "\\$" ), "\\$" );
  if ( cmdLine.isEmpty() )
      return;

  KShellProcess proc;
  proc << cmdLine.simplifyWhiteSpace().stripWhiteSpace();

  if ( !proc.start(KProcess::DontCare, KProcess::NoCommunication ))
      debug("Couldn't start process! %s", cmdLine.latin1());	
	
}
/** There has been clicked on a Email referenct,
lets start eg kmail  */
void kxSendMessagesImpl::slotEMailClick(const QString &s, const QString &e)
{
	debug("EMAIL: %s <%s>",s.latin1(), e.latin1());
}

void parseHTMLtoHRef(QString &message)
{
   QRegExp url;
   QString link;
   int len = 0, start = 0, end = 0, endanchor = 0;
   int starthttp = 0, startwww = 0, startanchor = 0, skipto = 0;
   int lenhttp = 0, lenwww = 0;
   bool http;
   url.setCaseSensitive(FALSE);
   //qDebug("message %s\n", message.latin1());
    // search for URL's and make HTML of it, taken from the KAIM code.
    // just fix http://www.kxicq.nl to become http://http://www.kxicq.org !
    while(start != -1){
            //first we search for any already-inserted anchors, that would be here
            //from "Insert->Link" so as not to process them and leave them alone.
            url.setPattern("<a href");
            startanchor = url.match(message, end);
            if(startanchor != -1){
                    url.setPattern("</a>");
                    endanchor = url.match(message, startanchor, &len);
                    skipto = endanchor + len;
                    //qDebug("skipto %d end %d\n", skipto, end);
            }

            url.setPattern( "http://[a-zA-Z0-9][^ ^\n^\r^\t]*" );
            starthttp = url.match(message, end, &lenhttp);
            url.setPattern( "www\\.[a-zA-Z0-9][^ ^\n^\r^\t]*" );
            startwww = url.match(message, end, &lenwww);

            //qDebug("startanchor %d startwww %d starthttp %d\n", startanchor, startwww, starthttp);
            //qDebug("lenwww %d lenhttp %d\n", lenwww, lenhttp);

            if( (startanchor != -1)
                    && (startanchor < (starthttp > -1 ? starthttp : startanchor+1) )
                    && (startanchor < (startwww > -1 ? startwww : startanchor+1) ) ){
                    end = skipto;
                    //qDebug("SKIP skipto: %d\n", skipto);
                    goto SKIP;
            }

            if( (starthttp == -1) && (startwww == -1) ) //neither found
                    break;
            else if(starthttp == -1){ //http not found
                  start = startwww;
                    end = startwww + lenwww;
                    http = FALSE;
            }else if(startwww == -1){ //www not found
                    start = starthttp;
                    end = starthttp + lenhttp;
                    http = TRUE;
            } else { //both found. use the first one!
                    start = starthttp; // (starthttp < startwww) ? starthttp : startwww;
                    end = starthttp+lenhttp; //(starthttp < lenwww) ? starthttp + lenhttp : startwww + lenwww;
                    http = TRUE; //(starthttp < lenwww) ? TRUE : FALSE;
            }

            //url.setPattern( QString("[ \n\r\t]") );  //e.g, any whitespace
            //end = url.match(message, start+len, 0, TRUE);

            //this happens when the damn end of the url is at the end of message
            if(end == -1)
                    end = message.length();

            //insert this first, makes it easier.
            message.insert(end, "</a>");

            if(http)
                    link = "<a href=\"" + message.mid(start, end-start) + "\">";
            else //need the leading "http://"
                    link = "<a href=\"http://" + message.mid(start, end-start) + "\">";

            message.insert(start, link );
            end += link.length() + 4; // </a> == 4

            SKIP:
             ; //pacifying g++

    }
}
void kxSendMessagesImpl::SlotFGColor()
{
  QColor myColor;
  int result = KColorDialog::getColor( myColor );
  if ( result == KColorDialog::Accepted )	
  {
  	useColor=TRUE;
  	fgColor=myColor;
	  QPalette pal = messageInput->palette();
    QColor c=myColor;
    #if QT_VERSION >= 210
      pal.setColor(QPalette::Active, QColorGroup::Text, c);
      pal.setColor(QPalette::Inactive, QColorGroup::Text, c);
    #else
      pal.setColor(QPalette::Active, QColorGroup::Text, c);
      pal.setColor(QPalette::Normal, QColorGroup::Text, c);
    #endif
    ENGINE->CONTACT->setColor(uin, fgColor, bgColor);
		messageInput->setPalette(pal);		
  }
}
void kxSendMessagesImpl::SlotBGColor()
{
  QColor myColor;
  int result = KColorDialog::getColor( myColor );
  if ( result == KColorDialog::Accepted )	
  {
  	useColor=TRUE;
  	bgColor=myColor;
	  QPalette pal = messageInput->palette();
    QColor c=myColor;
    #if QT_VERSION >= 210
      pal.setColor(QPalette::Active, QColorGroup::Base, c);
      pal.setColor(QPalette::Inactive, QColorGroup::Base, c);
    #else
      pal.setColor(QPalette::Active, QColorGroup::Base, c);
      pal.setColor(QPalette::Normal, QColorGroup::Base, c);
    #endif
    ENGINE->CONTACT->setColor(uin, fgColor, bgColor);
		messageInput->setPalette(pal);  	
  	
  }
}
