#include <kxinfodialogimpl.h>
#include <qcheckbox.h>
#include <kxmainwindow.h>
#include "kxsearchdialogimpl.h"
#include <kaccel.h>
#include <qlabel.h>
#include <kxcontact.h>
#include <qstring.h>
#include <klineedit.h>
#include <klocale.h>
#include <kxengine.h>
#include <qpushbutton.h>
#include <klistview.h>
#include <qtabwidget.h>
#include <qlistview.h>
             
/* 
 *  Constructs a kxSeachDialogImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
kxSearchDialogImpl::kxSearchDialogImpl( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : kxSearchDialog( parent, name, modal, fl )
{
  searchView->setEnabled(FALSE);
  searchView->setSelectionModeExt(KListView::Single);
  searchView->setAllColumnsShowFocus(TRUE);

  search=FALSE;
  searchSeq=0;
  count=0;
  addButton->setEnabled(FALSE);
  infoButton->setEnabled(FALSE);

  KAccel *a = new KAccel(this);
  a->insertItem(i18n("Search"), "Search",Key_Enter);
  a->connectItem("Search",this,SLOT(SlotSearchButton()));

  inform->setChecked(MAINWINDOW->kxConfig.notifyContactOnAdding);

  QObject::connect(startButton, SIGNAL(clicked()), this, SLOT(SlotSearchButton()));
  QObject::connect(addButton, SIGNAL(clicked()), this, SLOT(SlotAddButton()));
  QObject::connect(cancelButton, SIGNAL(clicked()), this, SLOT(SlotCancelButton()));  
  QObject::connect(infoButton, SIGNAL(clicked()), this, SLOT(SlotInfoButton()));  
  QObject::connect(searchView, SIGNAL(clicked(QListViewItem *)) , this, SLOT(SlotClicked(QListViewItem *)));

  QObject::connect(ENGINE, SIGNAL(SignalSearchFound(Q_UINT16, UIN, QString, QString,QString,QString, Q_UINT8,Q_UINT8, bool)),
                   this, SLOT(SlotSearchFound(Q_UINT16, UIN, QString,QString,QString,QString, Q_UINT8,Q_UINT8, bool)));
  QObject::connect(ENGINE, SIGNAL(SignalSearchFailed(Q_UINT16)), this, SLOT(SlotSearchFailed(Q_UINT16)));
  
}

/*  
 *  Destroys the object and frees any allocated resources
 */
kxSearchDialogImpl::~kxSearchDialogImpl()
{
    // no need to delete child widgets, Qt does it all for us
}

void kxSearchDialogImpl::SlotCancelButton()
{
  delete this;
}
void kxSearchDialogImpl::SlotInfoButton()
{
  QListViewItem *i;
  if (searchView->selectedItem()) i=searchView->selectedItem();
  else return;  
  if (i->text(1).toUInt()>0)
  {
    kxInfoDialogImpl *dialog=new kxInfoDialogImpl(i->text(1).toUInt(),0L,"info");
    dialog->show();
  }
}
void kxSearchDialogImpl::SlotSearchButton()
{
  if (search)
  {
    startButton->setText(i18n("Start Search"));
    statusLabel->setText(i18n("Search stopped"));
    search=FALSE;   
    searchSeq=0;
  }
  else
  {
    if (!ENGINE->loggedOn())
    {
      statusLabel->setText(i18n("Sorry, you are not connected."));      
      return;
    }
    switch(tabWidget->currentPageIndex())
    {
      case 0:
              if (uinInput->text().toUInt()>0)
              {
                searchSeq=ENGINE->searchForUin(uinInput->text().toUInt());
                statusLabel->setText(i18n("Start searching for a UIN..."));
                search=TRUE;
                count=0;
              }
              else
                statusLabel->setText(i18n("You must provide a UIN."));
              break;
      case 1:
              if (nickInput->text().length()>0 || firstNameInput->text().length()>0 || lastNameInput->text().length()>0)
              {
                searchSeq=ENGINE->searchForExtra(nickInput->text().latin1(),
                                                 firstNameInput->text().latin1(),
                                                 lastNameInput->text().latin1() );
                statusLabel->setText(i18n("Start searching for a name..."));
                search=TRUE;
                count=0;
              }
              else
                statusLabel->setText(i18n("You must provide a Name or Nick."));              
              break;
      case 2:     
              if (emailInput->text().length()>0)
              {
                searchSeq=ENGINE->searchForEmail(emailInput->text().latin1());
                statusLabel->setText(i18n("Start searching for a E-Mail..."));
                search=TRUE;
                count=0;
              }      
             else
                statusLabel->setText(i18n("You must provide a E-Mail adress"));
              break;
    }
    if (search) 
    {
      startButton->setText(i18n("Stop Search"));  
      searchView->clear();
      addButton->setEnabled(FALSE);
      infoButton->setEnabled(FALSE);      
    }
  }
}
void kxSearchDialogImpl::SlotSearchFound(Q_UINT16 _s, UIN _u, QString _n, QString _f, QString _l, QString _e, Q_UINT8 _a,Q_UINT8 _st, bool _last)
{
  if (_s==searchSeq)
  {
    QString stmp;
    QString authTmp, uin;

    if (count==0)
      searchView->setEnabled(TRUE);

    count++;
    uin.sprintf("%d",_u);    
    
    if (!_a) authTmp=i18n("Authorize");
    else authTmp=i18n("None");
    
    QListViewItem *l=new QListViewItem(searchView, "",uin, _n, _f, _l, _e, authTmp);
    switch(_st)
    {
    	case 0:    	
		    l->setPixmap(0,MAINWINDOW->kxIcons.offline);
		    break;
    	case 1:    	
		    l->setPixmap(0,MAINWINDOW->kxIcons.online);
		    break;
    	case 2:    	
		    l->setPixmap(0,MAINWINDOW->kxIcons.invisible);
		    break;
		}		
    
    if (_last)
    {
      search=FALSE;
      searchSeq=0;      
      stmp=i18n("Search done. ");    
      startButton->setText(i18n("Start Search"));  
    }
    else
    {
      stmp.sprintf(i18n("Found: %d ."), count);
    }
    if (count>=39)
      stmp+=i18n(" Maximum of 40 reached.");
    statusLabel->setText(stmp);
  }
}
void kxSearchDialogImpl::SlotSearchFailed(Q_UINT16 _s)
{
  if (_s==searchSeq)
  {
    debug("Found: error");
    search=FALSE;
    searchSeq=0;
    startButton->setText(i18n("Start Search")); 
    statusLabel->setText(i18n("Search failed, try again."));    
  }
}
void kxSearchDialogImpl::SlotClicked(QListViewItem *i)
{
  if (i)  
    if (ENGINE->CONTACT->getContact(i->text(1).toUInt()).uin==0)
    {
     addButton->setEnabled(TRUE);

    }
  infoButton->setEnabled(TRUE);
}
void kxSearchDialogImpl::SlotAddButton()
{
  QListViewItem *i;
  if (searchView->selectedItem()) i=searchView->selectedItem();
  else return;  
  if (ENGINE->CONTACT->getContact(i->text(1).toUInt()).uin==0)
  {  
    addButton->setEnabled(FALSE);
    ENGINE->addContact2List(i->text(1).toUInt(), i->text(6)=="None" ? FALSE : TRUE, inform->isChecked(),
    																						 i->text(2),
    																						 // now our info
																								 MAINWINDOW->kxConfig.nick,
                                                 MAINWINDOW->kxConfig.lastName,
                                                 MAINWINDOW->kxConfig.firstName,
                                                 MAINWINDOW->kxConfig.email, MAINWINDOW->kxConfig.authorize, FALSE
			);
  }  
}
