#include "kxrequestformimpl.h"
#include <kanimwidget.h>
#include <kxengine.h>
#include <kxcontact.h>
#include <klocale.h>
#include <qlabel.h>
/* 
 *  Constructs a kxRequestFormImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
kxRequestWidgetImpl::kxRequestWidgetImpl( Q_UINT16 _seq, Q_UINT32 _uin, QWidget* parent,  const char* name, bool modal, WFlags fl )
    : kxRequestWidget( parent, name, modal, fl )
{
  QStringList list;
  QString tmp;
  for (int t=1; t<=50; t++)
  {
    tmp.sprintf("kde/%04d",t);
    list.append(tmp);
  }

  sendAnim=new KAnimWidget(list, 22, animLabel, "anim");
  sendAnim->resize(25,25);
  uin=_uin;
  seq=_seq;
  sendAnim->start();
  QString n=ENGINE->CONTACT->getContact(uin).nick;
  if (n.length()>0)
	  requestLabel->setText(i18n("For ")+ENGINE->CONTACT->getContact(uin).nick);
	else
		requestLabel->setText(i18n("For a contact"));		

  QObject::connect(ENGINE, SIGNAL(SignalSearchFound(Q_UINT16, UIN, QString, QString,QString,QString, Q_UINT8,Q_UINT8, bool)),
                   this, SLOT(SlotSearchFound(Q_UINT16, UIN, QString,QString,QString,QString, Q_UINT8,Q_UINT8, bool)));
  QObject::connect(ENGINE, SIGNAL(SignalReceivedMainHomeInfo(Q_UINT16, QString,QString,QString,QString,QString,QString,QString,QString,QString,QString,QString,Q_UINT16, Q_UINT8, Q_UINT8)), this, SLOT(SlotReceivedMainHomeInfo(Q_UINT16, QString,QString,QString,QString,QString,QString,QString,QString,QString,QString,QString,Q_UINT16, Q_UINT8, Q_UINT8)));
  QObject::connect(ENGINE, SIGNAL(SignalSearchEnd(Q_UINT16)), this, SLOT(SlotSearchEnd(Q_UINT16)));
  QObject::connect(ENGINE, SIGNAL(SignalReceivedEmailInfo(Q_UINT16, QStringList)), this, SLOT(SlotEmailInfo(Q_UINT16, QStringList)));
	QObject::connect(ENGINE, SIGNAL(SignalSearchFailed(Q_UINT16)), this, SLOT(SlotSearchFailed(Q_UINT16)));
}

/*  
 *  Destroys the object and frees any allocated resources
 */
kxRequestWidgetImpl::~kxRequestWidgetImpl()
{
    // no need to delete child widgets, Qt does it all for us
}

void kxRequestWidgetImpl::SlotReceivedMainHomeInfo(Q_UINT16 s, QString,QString,QString,QString,QString,QString,QString,QString,QString,QString _gsm,QString,Q_UINT16, Q_UINT8, Q_UINT8)
{
  if (seq==s)
  {
  	if (_gsm.length()>0)
  	{
  		ENGINE->CONTACT->setGSM(uin, _gsm);
  	}
  }
}
void kxRequestWidgetImpl::SlotEmailInfo(Q_UINT16 s, QStringList)
{
  if (seq==s)
  {
  }
}
void kxRequestWidgetImpl::SlotSearchEnd(Q_UINT16 s)
{
	debug("Search End: %d- %d",seq, s);
  if (seq==s)
  {
  	accept();
  }
}
void kxRequestWidgetImpl::SlotSearchFailed(Q_UINT16 s)
{
  if (seq==s)
  {
  	reject();
  }
}
void kxRequestWidgetImpl::SlotSearchFound(Q_UINT16 s, UIN _u, QString _n, QString _f, QString _l, QString _e, Q_UINT8 _a,Q_UINT8 _st, bool _last)
{
  if (seq==s)
  {
  	if (_a) ENGINE->CONTACT->setNeedAuth(_u, TRUE);
  	else ENGINE->CONTACT->setNeedAuth(_u, FALSE);
  	ENGINE->CONTACT->rename(_u,_n);
 	}
}
