#include <kprocess.h>
#include "kxinfodialogimpl.h"
#include "kxfiledialogimpl.h"
#include <kxtcp.h>
#include "kxmainwindow.h"
#include <qcheckbox.h>
#include "kxreceivedmessage.h"
#include "kxreceivedmessageimpl.h"
#include "kxSendMessageImpl.h"
#include <qpushbutton.h>
#include <qlabel.h>
#include <kxengine.h>
#include <kxmessage.h>
#include <klocale.h>
#include <qmultilineedit.h>
#include <kxcontact.h>
#include <qlayout.h>
#include <qbuttongroup.h>
#include <qstring.h>
#include <kxsendmessagesimpl.h>
#include <kwin.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

kxReceivedMessageImpl::kxReceivedMessageImpl(UIN _uin,int _seq, QString _msg, QString _fn, int _size, QWidget* parent , const char* name  ) 
    : kxReceivedMessage( parent, name)
{
  debug("Show This Message");
  uin=_uin;
  seq=_seq;
  fileMessage=_msg;
  fileName=_fn;
  size=_size;
  type=FILE_TYPE;
  showPos=-1;
  messageStr=_msg;
  init();
}

kxReceivedMessageImpl::kxReceivedMessageImpl( UIN _uin,QWidget* parent,  const char* name )
    : kxReceivedMessage( parent, name)
{
  debug("Show a New Message from a UIN");
  type=0;
  uin=_uin;
  showPos=-1;
  init();
}
kxReceivedMessageImpl::kxReceivedMessageImpl( bool, int _pos,QWidget* parent,  const char* name )
    : kxReceivedMessage( parent, name)
{
  debug("Show 1 message on _pos");
  type=0;
  showPos=_pos;
  uin=0;
  uin=ENGINE->MESSAGE->getMessage(_pos).uin;
  init();
}
kxReceivedMessageImpl::kxReceivedMessageImpl( QWidget* parent,  const char* name )
    : kxReceivedMessage( parent, name)
{
  debug("Show a New Message");
  uin=0;
  type=1;
  showPos=-1;
  init();  
}
  
void kxReceivedMessageImpl::init()
{
  oldUin=0;
  messageString=NULL;
  urlString=NULL; 
  urlLabel=NULL;
  urlLayout=NULL;
  boxLayout=NULL;
  historyView=NULL;
  urlButton=NULL;
  contactView=NULL;
  KWin::setIcons(winId(),MAINWINDOW->kxIcons.message,MAINWINDOW->kxIcons.message);
	
  prevFrame=0;
  QObject::connect(readNextButton, SIGNAL(clicked()), this, SLOT(SlotNextButton()));
  QObject::connect(closeButton, SIGNAL(clicked()), this, SLOT(SlotCancelButton()));
  QObject::connect(replyButton, SIGNAL(clicked()), this, SLOT(SlotReplyButton()));
  QObject::connect(forwardButton, SIGNAL(clicked()), this, SLOT(SlotForwardButton()));
  QObject::connect(addUserButton, SIGNAL(clicked()), this, SLOT(SlotAddButton()));
  QObject::connect(historyButton, SIGNAL(clicked()), this, SLOT(SlotHistoryButton()));
  QObject::connect(infoButton, SIGNAL(clicked()), this, SLOT(SlotInfoButton()));  
  QObject::connect(ENGINE->CONTACT, SIGNAL(recountMessages(UIN)), this, SLOT(SlotRecountMessages(UIN)));
  readNextButton->setEnabled(FALSE);
  showEvent();
}

kxReceivedMessageImpl::~kxReceivedMessageImpl()
{
}
void kxReceivedMessageImpl::showEvent()
{
	bool useColor=FALSE;
	KWin::setIcons(winId(),MAINWINDOW->kxIcons.message,MAINWINDOW->kxIcons.message);
  if (type==FILE_TYPE)
  {
    setupMessageFrame(type);    
//    historyView->setEnabled(FALSE);
    readNextButton->setEnabled(FALSE);
    historyButton->setEnabled(FALSE);
    addUserButton->setEnabled(FALSE);
    QToolTip::add(  replyButton, i18n( "Accept file" ) );
    QWhatsThis::add(  replyButton, i18n( "Accept file" ) );
    QToolTip::add(  forwardButton, i18n( "Reject file" ) );
    QWhatsThis::add(  forwardButton, i18n( "Reject file" ) );
    replyButton->setText(i18n("Accept"));
    forwardButton->setText(i18n("Reject"));
    parseHTMLtoHRef(fileMessage);

    messageString->setText(fileMessage);

    urlString->setText(fileName+i18n(" Size: ")+QString().setNum(size));
    if (ENGINE->CONTACT->getContact(uin).uin>0)
    {
      addUserButton->setEnabled(FALSE);
      nickLabel->setText(ENGINE->CONTACT->getContact(uin).nick);
    }
    else
    {
      addUserButton->setEnabled(TRUE);
      if (nick.length()>0) nickLabel->setText(nick);
      else nickLabel->setText(i18n("<Unknown: ")+QString().setNum(uin)+">");
    }        
  }
  else
  {
    int pos=0;
    if (showPos>=0)
    {
      pos=showPos;
      showPos=0;
    }
    else
    {
      if (type==0) pos=ENGINE->MESSAGE->giveFirstUnread(uin);
      else pos=ENGINE->MESSAGE->giveFirstAllUnread();
    }
    debug("Pos = %d",pos);
    kxMessageStruct message;
    message=ENGINE->MESSAGE->getMessage(pos);
    setupMessageFrame(message.type);
    ruin=message.uin;
    msgType=message.type;
    if (message.type==REJECT_TYPE || message.type==AUTH_TYPE)
    {
    	messageStr=message.message;
    	message.message.replace(QRegExp(">"),"&gt;");
    	message.message.replace(QRegExp("<"),"&lt;");    	   	
    	parseHTMLtoHRef(message.message);
      message.message.replace(QRegExp("\n"),"<BR>");
      message.message.replace(QRegExp("\r"),"");
      QString _tmp="<B></B>";
      if (message.type==REJECT_TYPE)
      {
      	if (message.message.length()>0)
      		_tmp+=i18n(ENGINE->CONTACT->getContact(message.uin).nick+" has <b>rejected</b> you with the folling reason:<p>")+message.message;
      	else
      		_tmp+=i18n(ENGINE->CONTACT->getContact(message.uin).nick+" has <b>rejected</b> your request without a reason.");
      }
      else
      {
      	_tmp+=i18n(ENGINE->CONTACT->getContact(message.uin).nick+" has <b>authorized</b> you!");
      }
      debug("Message :[%s]",_tmp.latin1());
      messageString->setText(_tmp);
      ENGINE->CONTACT->setAuthorized(message.uin,message.type==REJECT_TYPE?FALSE:TRUE);
      ENGINE->CONTACT->setWaitAuth(message.uin,FALSE);
      debug("Auth updates");
      MAINWINDOW->SlotContactStatusChange(message.uin, ENGINE->CONTACT->getContact(message.uin).status,0);  	
    }
    if (message.type==MESSAGE_TYPE || message.type==URL_TYPE )
    {
    	if (message.type==URL_TYPE) KWin::setIcons(winId(),MAINWINDOW->kxIcons.url,MAINWINDOW->kxIcons.url);
    	messageStr=message.message;
    	message.message.replace(QRegExp(">"),"&gt;");
    	message.message.replace(QRegExp("<"),"&lt;");    	   	
    	parseHTMLtoHRef(message.message);
      message.message.replace(QRegExp("\n"),"<BR>");
      message.message.replace(QRegExp("\r"),"");
      QString _tmp="<B></B>";
      //messageInput->clear();

      if (MAINWINDOW->kxConfig.useColor && message.useColor)
      {
      	_tmp+="<font color=\""+message.foreground.name()+"\">";
      	useColor=TRUE;
      	messageString->setBackgroundMode(QWidget::PaletteBackground);

  		  QPalette pal = palette();
        QColor c=message.background;
        #if QT_VERSION >= 210
          pal.setColor(QPalette::Active, QColorGroup::Base, c);
          pal.setColor(QPalette::Inactive, QColorGroup::Base, c);
        #else
          pal.setColor(QPalette::Active, QColorGroup::Base, c);
          pal.setColor(QPalette::Normal, QColorGroup::Base, c);
        #endif

  			messageString->setPalette(pal);
  			
	  		int r,g,b;
	  		message.background.rgb(&r, &g, &b);
	  		debug("RGB: %X-%X-%X",r,g,b);
      }
      _tmp+=message.message;
      if (MAINWINDOW->kxConfig.useColor && message.useColor) _tmp+="</font>";

      debug("Message :[%s]",_tmp.latin1());
      messageString->setText(_tmp);
      messageString->setNotifyClick(TRUE);
		  QObject::connect(messageString, SIGNAL(mailClick(const QString &, const QString &)), SLOT(slotEMailClick(const QString &, const QString &)));
			QObject::connect(messageString, SIGNAL(urlClick(const QString &)), SLOT(slotURLClick(const QString &)));

// FIXME backgroundcolor !!
     // messageString->setText(_tmp);
    }
    if (message.type==REQUEST_TYPE) 
    {
    	message.message.replace(QRegExp(">"),"&gt;");
    	message.message.replace(QRegExp("<"),"&lt;");
    	parseHTMLtoHRef(message.message);    	
      message.message.replace(QRegExp("\n"),"<BR>");
      message.message.replace(QRegExp("\r"),"");

      messageString->setText(message.nick+i18n(" has asked for <B>Authorization</B>:<P>Nick: ")+message.nick+
                             i18n("<BR>Name: ")+message.firstName+" "+message.lastName+"<BR>"+i18n("E-Mail: ")+
                             message.email+i18n("<P>He/She has the following request:<BR>")+message.message
       );
    }
    if (message.type==SMS_TYPE)
    {
      replyButton->setEnabled(FALSE);
      addUserButton->setEnabled(FALSE);
      forwardButton->setEnabled(FALSE);
		  replyButton->setText(i18n("Reply"));
		  forwardButton->setText(i18n("Forward"));
    	QString idStr;
    	QString deliv;
    	QString error;
    	QString dest;
    	QString delivTime;
    	QString destUIN;
    	QString text;
    	QString sender;
  		QDomDocument d;
  		d.setContent(message.message);
  		QDomNode n = d.firstChild();
  		while( !n.isNull() )
  		{
  			QDomNodeList l=n.childNodes();
  			for (Q_UINT16 t=0; t<=l.length(); t++)
  			{
  				if (l.item(t).toElement().tagName()=="destination_UIN") destUIN=l.item(t).toElement().text();
  				if (l.item(t).toElement().tagName()=="text") text=l.item(t).toElement().text();  				
  				if (l.item(t).toElement().tagName()=="sender") sender=l.item(t).toElement().text();  				
  				if (l.item(t).toElement().tagName()=="message_id") idStr=l.item(t).toElement().text();
  				if (l.item(t).toElement().tagName()=="deliverable") deliv=l.item(t).toElement().text();
  				if (l.item(t).toElement().tagName()=="delivered") deliv=l.item(t).toElement().text();
					if (l.item(t).toElement().tagName()=="destination") dest="+"+l.item(t).toElement().text();
					if (l.item(t).toElement().tagName()=="param") error=l.item(t).toElement().text();
					if (l.item(t).toElement().tagName()=="delivery_time") delivTime=l.item(t).toElement().text();
					
  			}		
  			n=n.nextSibling();
  		}			
  		if (destUIN.length()>0)
  		{
  	  	text.replace(QRegExp(">"),"&gt;");
		   	text.replace(QRegExp("<"),"&lt;");

  			messageString->setText(i18n("You received a SMS from ")+sender+i18n(": \n")+text);
  		}
  		else
  		{
	  		if (deliv=="Yes")  		
		    	messageString->setText(i18n("The SMS to ")+dest+i18n(" was deliverd on ")+delivTime);
		    else
		    {
		    	error.replace(QRegExp(">"),"&gt;");
		    	error.replace(QRegExp("<"),"&lt;");
		    	messageString->setText(i18n("The SMS to ")+dest+i18n(" was <B>not</b> received.\nThe error was: ")+error);	
		    }
		  }
    }
    if (message.type==ADDED_TYPE)
      messageString->setText(message.nick+i18n(" has <B>added</B> you:<P>")+
                             i18n("<BR>Name: ")+message.firstName+" "+message.lastName+"<BR>"+i18n("E-Mail: ")+
                             message.email
       );
      
    if (message.type==URL_TYPE) 
      urlString->setText(message.url);

    if (message.type==CONTACTS_TYPE)
    {		

      contactView->setSelectionModeExt(KListView::Single);
		  contactView->setAllColumnsShowFocus(TRUE);

    	message=ENGINE->MESSAGE->getMessage(pos,FALSE); // get list now
    	addUserButton->setEnabled(FALSE);
	    replyButton->setText(i18n("Info"));
	    replyButton->setEnabled(FALSE);
	    forwardButton->setEnabled(FALSE);
	    debug("Count: %d",message.list.count());
    	for (Q_UINT16 t=0; t<message.list.count(); t++)
  		{
  			debug("Add: %d, %d",t, message.list.at(t)->uin);
  			QString uin;
  			uin.sprintf("%d",message.list.at(t)->uin);
    		(void)new QListViewItem(contactView, "",uin, message.list.at(t)->nick,"", "", "", i18n("unknown"));
//    		QListViewItem *l=
    	}
    	message.list.setAutoDelete(TRUE);
    }
    nick=message.nick;
    needAuth=message.auth_request;  
      
    if (ENGINE->CONTACT->getContact(message.uin).uin>0)
    {
      addUserButton->setEnabled(FALSE);
      nickLabel->setText(ENGINE->CONTACT->getContact(message.uin).nick);
    }
    else
    {
      if (message.uin>0) addUserButton->setEnabled(TRUE);
      if (nick.length()>0) nickLabel->setText(nick);
      else nickLabel->setText(i18n("<Unknown: ")+QString().setNum(message.uin)+">");
    }    
       
    QString dateTime;
    dateTime.sprintf("%02d-%02d-%04d %02d:%02d",message.dateTime.date().day()
                                               ,message.dateTime.date().month()
                                               ,message.dateTime.date().year()
                                               ,message.dateTime.time().hour()
                                               ,message.dateTime.time().minute() );
    dateLabel->setText(dateTime); 
    debug("Pos is here %d",pos);
    ENGINE->MESSAGE->setRead(pos,TRUE);
    if (historyView!=NULL)
    {
      if (oldUin!=0)
      {
        if (oldUin!=message.uin)
        {
          historyView->changeUin(message.uin);
        }
      }
    }
    oldUin=message.uin;
  }
  if (messageString)
  {
    // scroll to the new text
    messageString->ensureVisible(0, messageString->contentsHeight());
    // This should not be a hard coded value like this!!!
    messageString->repaintContents(0,0, 10000, 20000, true);
  }
  if (!useColor && messageString)
  {
	  messageString->setBackgroundMode(QWidget::PaletteBackground );
//  	messageString->setBackgroundColor(this->palette().normal().background());
//  	messageString->setForegroundColor(this->palette().normal().foreground());  	
  }
}     

void kxReceivedMessageImpl::setupMessageFrame(int _type)
{
  if (messageString!=NULL) { delete messageString;  messageString=NULL; }
  if (urlString!=NULL)     { delete urlString;      urlString=NULL;     }
  if (urlLabel!=NULL)      { delete urlLabel;       urlLabel=NULL;      }
  if (urlLayout!=NULL)     { delete urlLayout;      urlLayout=NULL;     }
  if (boxLayout!=NULL)     { delete boxLayout;      boxLayout=NULL;     }  
  if (urlButton!=NULL)     { delete urlButton;      urlButton=NULL;     }
  if (contactView!=NULL)	 { delete contactView;		contactView=NULL;   }
  
  messageGroup->setColumnLayout(0, Qt::Vertical );
  messageGroup->layout()->setSpacing( 0 );
  messageGroup->layout()->setMargin( 0 );    

  boxLayout = new QVBoxLayout( messageGroup->layout() );
  boxLayout->setAlignment( Qt::AlignTop );
  boxLayout->setSpacing( 3 );
  boxLayout->setMargin( 5 );

  insertCheck->setEnabled(FALSE);
  replyButton->setText(i18n("Reply"));
  forwardButton->setText(i18n("Forward"));
  if (_type==REQUEST_TYPE) 
  {
    replyButton->setText(i18n("Authorize"));
    forwardButton->setText(i18n("Reject"));
    QToolTip::add(  replyButton, i18n( "Send authorization" ) );
    QWhatsThis::add(  replyButton, i18n( "Send authorization" ) );
    QToolTip::add(  forwardButton, i18n( "Reject the authorization request" ) );
    QWhatsThis::add(  forwardButton, i18n( "Reject the authorization request" ) );
  }
  if (_type==REJECT_TYPE || _type==AUTH_TYPE)
  {
		replyButton->setEnabled(FALSE);
		forwardButton->setEnabled(FALSE);
		insertCheck->setEnabled(FALSE);  	
  }
    
  if (_type==MESSAGE_TYPE || _type==REQUEST_TYPE || _type==ADDED_TYPE || _type==AUTH_TYPE || _type==REJECT_TYPE || _type==SMS_TYPE)
  {   
    messageString = new kxTextBrowser( (QWidget *)messageGroup, "messageString" );
//    messageString->setReadOnly( TRUE );
    messageString->setFocusPolicy( QMultiLineEdit::ClickFocus );
//    messageString->setWordWrap( QMultiLineEdit::WidgetWidth );
    boxLayout->addWidget( messageString ); 
    prevFrame=_type;
    messageString->show();
  }
  if (_type==MESSAGE_TYPE)
  {
  	insertCheck->setEnabled(TRUE);
	}
  if (_type==URL_TYPE)
  {
  	insertCheck->setEnabled(TRUE);
    urlLayout = new QHBoxLayout;
    urlLayout->setSpacing( 0 );
    urlLayout->setMargin( 0 );
 
    urlLabel = new QLabel( (QWidget *)messageGroup, "TextLabel1" );
    urlLabel->setText( i18n( "URL:"  ) );
    urlLayout->addWidget( (QWidget *) urlLabel );
 
    urlString = new QMultiLineEdit( (QWidget *)messageGroup, "MultiLineEdit3" );
    urlString->setMinimumSize( QSize( 0, 22 ) );
    urlString->setMaximumSize( QSize( 32767, 22 ) );
    urlString->setReadOnly( TRUE );
    urlLayout->addWidget( (QWidget *)urlString );
    urlButton = new QPushButton ( i18n("open"), (QWidget *)messageGroup, "urlbutton" );
    QObject::connect(urlButton, SIGNAL(clicked()), this, SLOT(SlotUrlButton()));
    urlLayout->addWidget( (QWidget *)urlButton ); 
    
    boxLayout->addLayout( urlLayout );   
 
    messageString = new kxTextBrowser( (QWidget *)messageGroup, "MultiLineEdit2" );
//    messageString->setReadOnly( TRUE );
    messageString->setFocusPolicy( QMultiLineEdit::ClickFocus );
//    messageString->setWordWrap( QMultiLineEdit::WidgetWidth );

    boxLayout->addWidget( (QWidget *)messageString );   
    messageString->show();
    urlLabel->show();
    urlString->show();
    urlLayout->activate();
    prevFrame=_type;
  }  
  if (_type==FILE_TYPE)
  {
    urlLayout = new QHBoxLayout;
    urlLayout->setSpacing( 0 );
    urlLayout->setMargin( 0 );
 
    urlLabel = new QLabel( (QWidget *)messageGroup, "TextLabel1" );
    urlLabel->setText( i18n( "File:"  ) );
    urlLayout->addWidget( (QWidget *) urlLabel );
 
    urlString = new QMultiLineEdit( (QWidget *)messageGroup, "MultiLineEdit3" );
    urlString->setMinimumSize( QSize( 0, 22 ) );
    urlString->setMaximumSize( QSize( 32767, 22 ) );
    urlString->setReadOnly( TRUE );
    urlLayout->addWidget( (QWidget *)urlString );
    boxLayout->addLayout( urlLayout );
 
    messageString = new kxTextBrowser( (QWidget *)messageGroup, "MultiLineEdit2" );
//    messageString->setReadOnly( TRUE );
    messageString->setFocusPolicy( QMultiLineEdit::ClickFocus );

    boxLayout->addWidget( (QWidget *)messageString );   
    messageString->show();
    urlLabel->show();
    urlString->show();
    urlLayout->activate();
    prevFrame=_type;
  }
  if (_type==CONTACTS_TYPE)
  {
    contactView = new KListView( (QWidget *)messageGroup, "contactView" );
    contactView->addColumn( QString::null );
    contactView->addColumn( i18n( "UIN" ) );
    contactView->addColumn( i18n( "Nick" ) );
    contactView->addColumn( i18n( "First name" ) );
    contactView->addColumn( i18n( "Last name" ) );
    contactView->addColumn( i18n( "E-Mail" ) );
    contactView->addColumn( i18n( "Authorize" ) );
    boxLayout->addWidget( (QWidget *)contactView );
		QObject::connect(contactView, SIGNAL(clicked(QListViewItem *)) , this, SLOT(SlotClicked(QListViewItem *)));
  }
  
  boxLayout->activate();
}
void kxReceivedMessageImpl::SlotHistoryButton()
{
  if (historyView!=NULL)
  {
    delete vbox_2;
    delete historyView;
    historyFrame->setMinimumSize(0,0);
    //vbox->activate();
    resize(width(),height()-75);    
    updateGeometry();    
    historyView=NULL;
    historyButton->setDown(FALSE);
  }
  else
  {
    debug("show hist! ");
    vbox_2 = new QVBoxLayout( historyFrame );
    vbox_2->setSpacing( 0 );
    vbox_2->setMargin( 0 );   
    historyView = new kxHistoryWidget(ruin, historyFrame, "historyView" );
    historyView->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)4, historyView->sizePolicy().hasHeightForWidth() ) );
    historyView->setFocusPolicy( QListView::NoFocus );
    historyView->show();    
    vbox_2->addWidget( historyView );        
    vbox_2->activate();
    historyFrame->setMinimumSize(0,75);
    historyFrame->resize(10,75);    
    //vbox->activate();
    resize(width(),height()+75);
    updateGeometry();
    historyButton->setDown(TRUE);
  }
}

void kxReceivedMessageImpl::SlotNextButton()
{
  showEvent();
}
void kxReceivedMessageImpl::SlotForwardButton()
{
  if (msgType==REQUEST_TYPE)
  {
    kxSendMessageImpl *dialog=new kxSendMessageImpl(ruin,REJECT_TYPE,0L,"SendMessage");
    dialog->resize(200,300);
    dialog->show();
    ENGINE->CONTACT->setSendWidget(uin,dialog);
    delete this;
  }  
  else
  {
    kxSendMessageImpl *dialog=new kxSendMessageImpl(ruin,QString(i18n("-- Forwarded Message: --\n"))+messageStr+QString("\n----"),1,0L,"SendMessage");
    dialog->resize(200,300);
    dialog->show();
    dialog->SlotMoreButton();    
    delete this;  
  }
}
void kxReceivedMessageImpl::SlotAddButton()
{
	if (msgType==CONTACTS_TYPE)
	{
	  QListViewItem *i;
    if (contactView->selectedItem()) i=contactView->selectedItem();
    else return;
    if (ENGINE->CONTACT->getContact(i->text(1).toUInt()).uin==0)
    {
      ENGINE->addContact2List(i->text(1).toUInt(), FALSE, MAINWINDOW->kxConfig.notifyContactOnAdding,
      																						 i->text(2),
      																						 // now our info
  																								 MAINWINDOW->kxConfig.nick,
                                                   MAINWINDOW->kxConfig.lastName,
                                                   MAINWINDOW->kxConfig.firstName,
                                                   MAINWINDOW->kxConfig.email, MAINWINDOW->kxConfig.authorize
  			);
    }
  }
  else
	if (msgType!=REQUEST_TYPE)
	{
//	  ENGINE->CONTACT->add(nick,ruin, FALSE);
  	ENGINE->addContact2List(ruin, FALSE, MAINWINDOW->kxConfig.notifyContactOnAdding,nick,
																								 MAINWINDOW->kxConfig.nick,
                                                 MAINWINDOW->kxConfig.lastName,
                                                 MAINWINDOW->kxConfig.firstName,
                                                 MAINWINDOW->kxConfig.email,
                                                 MAINWINDOW->kxConfig.authorize
			);
	}
	else
	{
	  	ENGINE->addContact2List(ruin, FALSE, MAINWINDOW->kxConfig.notifyContactOnAdding,nick,
																								 MAINWINDOW->kxConfig.nick,
                                                 MAINWINDOW->kxConfig.lastName,
                                                 MAINWINDOW->kxConfig.firstName,
                                                 MAINWINDOW->kxConfig.email,
                                                 MAINWINDOW->kxConfig.authorize
			);
//		ENGINE->CONTACT->add(nick,ruin, needAuth);
	}
		

//  notifyContactOnAdding

//todo  ENGINE->addContact2List(ruin);
//  if (MAINWINDOW->kxConfig.notifyContactOnAdding && !msgType==REQUEST_TYPE)
//    ENGINE->notifyContact(ruin, MAINWINDOW->kxConfig.nick,
//                                                 MAINWINDOW->kxConfig.lastName,
//                                                 MAINWINDOW->kxConfig.firstName,
//                                                 MAINWINDOW->kxConfig.email);
  addUserButton->setEnabled(FALSE);
}

void kxReceivedMessageImpl::SlotCancelButton()
{
  close();
}
void kxReceivedMessageImpl::hide()
{
  delete this;
}
void kxReceivedMessageImpl::SlotInfoButton()
{
  kxInfoDialogImpl *dialog=new kxInfoDialogImpl(ruin,0L,"info");
  dialog->show();
}
void kxReceivedMessageImpl::SlotUrlButton()
{
  QString url=urlString->text();
  if (url.find("http://")<0) url="http://"+url;
  slotURLClick(url);
}
void kxReceivedMessageImpl::SlotReplyButton()
{
	if (msgType==CONTACTS_TYPE)
	{
	  QListViewItem *i;
    if (contactView->selectedItem()) i=contactView->selectedItem();
    else return;
    if (i->text(1).toUInt()>0)
    {
      kxInfoDialogImpl *dialog=new kxInfoDialogImpl(i->text(1).toUInt(),0L,"info");
      dialog->show();
    }		
	}
	else
  if (msgType==FILE_TYPE)
  {                 
    KServerSocket *sock=ENGINE->TCP->getNextFreePort();
    if (sock)
    {
     kxFileDialogImpl *dialog=new kxFileDialogImpl(uin, sock, fileName, size,0,0L, "file", seq);    
     dialog->show();
    }
    else
    {
      debug("No Free Port !!!");
    }
    hide();   
  } 
  else 
  if (msgType==REQUEST_TYPE)
  {
    ENGINE->sendAuthorization(ruin);
    //SlotAddButton();
    delete this;
  }
  else
  {
    //debug("reply: %s",messageString->text().latin1());
    kxSendMessageImpl *dialog;
    if (insertCheck->isChecked())
    {
    	dialog=new kxSendMessageImpl(ruin,messageStr,1,0L,"SendMessage");
    }
    else
    {
    	dialog=new kxSendMessageImpl(ruin,1,0L,"SendMessage");
    }
    dialog->resize(200,300);
    dialog->show();
    delete this;
  }
}
void kxReceivedMessageImpl::SlotRecountMessages(UIN _uin)
{
  if (type==FILE_TYPE) return;
  bool show=FALSE;
  if (type==0 && _uin==uin) show=TRUE;
  if (type==1) show=TRUE;
  debug("Recount: %d",show);
  if (show)
  {
    QString txt;
    int toGo=0;
    if (type==0) toGo=ENGINE->MESSAGE->countUnreadMessages (uin);
    else toGo=ENGINE->MESSAGE->countAllUnread();
    if (toGo<1)
    {
      readNextButton->setText(i18n("Read Next"));
      readNextButton->setEnabled(FALSE);
    }
    else
    {
      readNextButton->setEnabled(TRUE);
      if (toGo==1)
      {
        readNextButton->setText(i18n("Read Next"));
      }
      else
      {
        txt.sprintf("Read Next (%d)",toGo);
        readNextButton->setText(txt);
      }
    }  
  }
}
void kxReceivedMessageImpl::SlotClicked(QListViewItem *i)
{
  if (i)
    if (ENGINE->CONTACT->getContact(i->text(1).toUInt()).uin==0)
    {
     addUserButton->setEnabled(TRUE);

    }
  replyButton->setEnabled(TRUE);
}
/** there is clicked on a URL in the output widget, now we must handle the URL
start Konq. for example */
void kxReceivedMessageImpl::slotURLClick(const QString &s)
{
	debug("URL: %s",s.latin1());
  QString cmdLine="kfmclient exec %s";
  QString url=s;

  // replace "%s" with the clipboard contents
  // replace \%s to %s
  // currently, only the first %s will be replaced... fix this?
  int pos = cmdLine.find("%s");
  if ( pos >= 0 ) {
      bool doReplace = true;
      if ( pos > 0 && cmdLine.at( pos -1 ) == '\\' ) {
          cmdLine.remove( pos -1, 1 ); // \%s -> %s
          doReplace = false;
      }

      if ( doReplace )
          cmdLine.replace( pos, 2, url );
  }

  // escape $ to avoid it being expanded by the shell
  cmdLine.replace( QRegExp( "\\$" ), "\\$" );
  if ( cmdLine.isEmpty() )
      return;

  KShellProcess proc;
  proc << cmdLine.simplifyWhiteSpace().stripWhiteSpace();

  if ( !proc.start(KProcess::DontCare, KProcess::NoCommunication ))
      debug("Couldn't start process! %s", cmdLine.latin1());	
	
}
/** There has been clicked on a Email referenct,
lets start eg kmail  */
void kxReceivedMessageImpl::slotEMailClick(const QString &s, const QString &e)
{
	debug("EMAIL: %s <%s>",s.latin1(), e.latin1());
}
