#include "kxrandomsearchimpl.h"
#include <kxengine.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <kxtcp.h>
#include <kxudp.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qmultilinedit.h>
#include <qlineedit.h>
#include <qbuttongroup.h>
#include <klocale.h>
#include <kxcontact.h>
#include <qcheckbox.h>
#include <kxmainwindow.h>
#include <kxinfodialogimpl.h>
#include <kxsendmessagesimpl.h>

#define SEARCHES 4

/* 
 *  Constructs a kxRandomSearchImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
kxRandomSearchImpl::kxRandomSearchImpl( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : kxrandomsearch( parent, name, modal, fl )
{
// QObject::connect(ENGINE->UDP,SIGNAL(receivedGenInfo(Q_UINT16, const char *,const char *,const char *,const char *,const char *,const char *,const char *,const char *,const char *,const char *,const char *,const char *,Q_UINT32, Q_UINT16, Q_UINT8)),
//                    this, SLOT(SlotGenInfo(Q_UINT16, const char *,const char *,const char *,const char *,const char *,const char *,const char *,const char *,const char *,const char *,const char *,const char *,Q_UINT32, Q_UINT16, Q_UINT8)));
//  QObject::connect(ENGINE->UDP,SIGNAL(receivedMoreInfo(Q_UINT16, Q_UINT16, Q_UINT8, const char *, Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8)),
//                    this,SLOT(SlotMoreInfo(Q_UINT16, Q_UINT16, Q_UINT8, const char *, Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8)));
//	QObject::connect(ENGINE->UDP,SIGNAL(receivedAboutInfo(Q_UINT16, const char *)),
//	                  this,SLOT(SlotAboutInfo(Q_UINT16, const char *)));
//  QObject::connect(ENGINE->UDP,SIGNAL(receivedWorkInfo(Q_UINT16, const char *, const char *,const char *, const char *,const char *, Q_UINT32, Q_UINT16, const char *, const char *,const char *, Q_UINT16, const char *)),
//                    this,SLOT(SlotWorkInfo(Q_UINT16, const char *, const char *,const char *, const char *,const char *, Q_UINT32, Q_UINT16, const char *, const char *,const char *, Q_UINT16, const char *)));

  foundUin=0;
  received=1;
  doSearch=FALSE;

  QObject::connect( searchButton, SIGNAL(clicked()), this, SLOT(SlotSearch()) );
  QObject::connect( infoButton, SIGNAL(clicked()), this, SLOT(SlotMoreInfo()) );
  QObject::connect( sendButton, SIGNAL(clicked()), this, SLOT(SlotSend()) );
  QObject::connect( addButton, SIGNAL(clicked()), this, SLOT(SlotAddContact()) );
  QObject::connect( closeButton, SIGNAL(clicked()), this, SLOT(SlotOk()) );

  QStringList list;
  QString tmp;
  for (int t=1; t<=50; t++)
  {
    tmp.sprintf("kde/%04d",t);
    list.append(tmp);
  }

  sendAnim=new KAnimWidget(list, 22, animLabel, "anim");
  sendAnim->resize(25,25);

  inform->setChecked(MAINWINDOW->kxConfig.notifyContactOnAdding);
}

/*  
 *  Destroys the object and frees any allocated resources
 */
kxRandomSearchImpl::~kxRandomSearchImpl()
{
    // no need to delete child widgets, Qt does it all for us
}
void kxRandomSearchImpl::SlotSearch()
{
  if (!doSearch)
  {
//    QObject::connect(ENGINE->UDP,SIGNAL(receivedRandomUser(UIN, Q_UINT32, Q_UINT32, Q_UINT32, Q_UINT8, Q_UINT16)), this
//                                , SLOT(SlotRequestUin(UIN, Q_UINT32, Q_UINT32, Q_UINT32, Q_UINT8, Q_UINT16)));
    foundUin=0;
    foundNick="";
    int t;
    t=category->currentItem()+1;
    if (t>4) t++;
    if (t==12) t=51;
//todo    ENGINE->UDP->sendRandomChatRequest(t);
    searchButton->setText(i18n("Stop search"));
//    status->setText(i18n("Status: Start search."));
    doSearch=TRUE;
    received=1;
   	nick->setText("");
  	uin->setText("");
  	firstName->setText("");
  	lastName->setText("");
  	country->setText("");
  	gender->setText("");
  	url->setText("");
//  	info->clear();
  	age->setText("");

   	chatButton->setEnabled(FALSE);
  	sendButton->setEnabled(FALSE);
  	addButton->setEnabled(FALSE);
  	infoButton->setEnabled(FALSE);
  	inform->setEnabled(FALSE);
  	sendAnim->start();

  }
  else
  {
    searchButton->setText(i18n("Search"));
//    status->setText(i18n("Status: "));
    doSearch=FALSE;
//    QObject::disconnect(ENGINE->UDP,SIGNAL(receivedRandomUser(UIN, Q_UINT32, Q_UINT32, Q_UINT32, Q_UINT8, Q_UINT16)), this
//                                , SLOT(SlotRequestUin(UIN, Q_UINT32, Q_UINT32, Q_UINT32, Q_UINT8, Q_UINT16)));
  	if (foundUin>0)
  	{
   // 	chatButton->setEnabled(TRUE);
    	sendButton->setEnabled(TRUE);
    	addButton->setEnabled(TRUE);
    	infoButton->setEnabled(TRUE);
  	  	inform->setEnabled(TRUE);
    }
    sendAnim->stop();
  }
}
void kxRandomSearchImpl::SlotRequestUin(UIN u, Q_UINT32 i, Q_UINT32 p, Q_UINT32 s, Q_UINT8 t, Q_UINT16 v)
{
  debug("UIN %d, IP %d, port %d, status %d(%s), type %d, version %d",u,i,p,s,contacts->status2str(s),t,v);
 	kxContactStruct cs;
// 	bool haveUser=FALSE;
  foundUin=u;
  QString tmp;
  tmp.sprintf("%d",u);
  uin->setText(tmp.data());
  seq=ENGINE->sendRequestInfo(u);
/* 	
 	for (int t=0; t<ENGINE->CONTACT->count(); t++)
 	{
 		cs=ENGINE->CONTACT->getContact(t);
 		if (cs.uin==u)
 		{
 			haveUser=TRUE; 			
 		}
 	}
 	if (!haveUser)
 	{
// 		kxicq->SlotAddUser(u,"","","","",0);
 		ENGINE->CONTACT->add("", u, 0,FALSE);
 	}
// 	status->setText(i18n("Status: Got random user, requesting more info."));
 	contacts->updateStatus(u, s, i, p);
 	int sock=ENGINE->TCP->connect((UIN)u);
 	if (sock<=0)  return;
    if (contacts->getContact(foundUin).handshakeStatus==kxTCP::RECEIVED)
    {
    	SlotSendRequest(foundUin);
    }
    else
    {
  	  debug("Send Hansshake.. wait for Ack");
  	  QObject::connect(ENGINE->TCP, SIGNAL(receivedHandshakeAck(UIN)), SLOT(SlotSendRequest(UIN)));
    } 	*/
}
/*
void kxRandomSearchImpl::SlotSendRequest(UIN _uin)
{
	if (foundUin==_uin)
	{
      QObject::connect(ENGINE->TCP, SIGNAL(receivedRandomAck(UIN, char *)), this, SLOT(SlotRandomAck(UIN, char *)));
 	  ENGINE->TCP->sendRandomInfoRequest(foundUin);	
	}
}
           */
void kxRandomSearchImpl::SlotGenInfo(Q_UINT16 s,const char *_n,const char *_f,const char *_l,const char *_e,const char *_s,const char *_o,const char *_c,const char *_st,const char *_p,const char *_fa,const char *_ste,const char *_ce,Q_UINT32 _zip, Q_UINT16 _country, Q_UINT8 _gmt)
{
 if (seq==s)
 {
  contacts->rename(foundUin, _n);
  foundNick=_n;
  nick->setText(_n);
  firstName->setText(_f);
  lastName->setText(_l);
  country->setText(contacts->getCountry(_country).data());
  received++;
  if (received>SEARCHES) SlotSearch();
 }
}
void kxRandomSearchImpl::SlotMoreInfo(Q_UINT16 s, Q_UINT16 _age, Q_UINT8 _sex, const char *_homepage, Q_UINT8 j,Q_UINT8 d,Q_UINT8 m,Q_UINT8 l1,Q_UINT8 l2,Q_UINT8 l3)
{
 if (seq==s)
 {
  QString tmp;
  tmp.sprintf("%d",_age);
  age->setText(tmp.data());
  if (_sex==1)
    tmp=i18n("Female");
  else if (_sex==2)
    tmp=i18n("Male");
    else
      tmp=i18n("Not specified");
  gender->setText(tmp.data());
  url->setText(_homepage);
  received++;
  if (received>SEARCHES) SlotSearch();
 }
}
void kxRandomSearchImpl::SlotAboutInfo(Q_UINT16 s, const char *_about)
{
 if (seq==s)
 {
  received++;
  if (received>SEARCHES) SlotSearch();
 }

}
void kxRandomSearchImpl::SlotWorkInfo(Q_UINT16 s,const char *_c, const char *_s,const char *_p, const char *_f,const char *_st, Q_UINT32 _zip, Q_UINT16 _co, const char *_n, const char *_dep,const char *_pos, Q_UINT16 _un, const char *_hp)
{
 if (s==seq)
 {
  received++;
  if (received>SEARCHES) SlotSearch();
 }
}

/*void kxRandomSearchImpl::SlotRemoveContact(UIN u)
{
  if (foundUin>0)
  {
    if (foundUin==u)
    {
      chat->setEnabled(FALSE);
      add->setEnabled(TRUE);
    }
  }
} */
void kxRandomSearchImpl::SlotChat()
{
//  kxChat2 *c=new kxChat2(foundUin,CHAT_DO_REQUEST, 0);
//  c->show();
}
void kxRandomSearchImpl::SlotSend()
{
  kxSendMessagesImpl *c=new kxSendMessagesImpl(foundUin,NULL,"send message");
  c->show();
}
void kxRandomSearchImpl::SlotAddContact()
{
//  kxicq->SlotAddUser(foundUin, foundNick.data(), "","","",inform->isChecked());
//todo  ENGINE->CONTACT->add(foundNick,foundUin, FALSE);
//  ENGINE->addContact2List(foundUin);
//  if (inform->isChecked())
//      ENGINE->notifyContact(foundUin, MAINWINDOW->kxConfig.nick,
//                                                 MAINWINDOW->kxConfig.lastName,
//                                                 MAINWINDOW->kxConfig.firstName,
//                                                 MAINWINDOW->kxConfig.email);

  addButton->setEnabled(FALSE);
//  chat->setEnabled(FALSE);
}
void kxRandomSearchImpl::SlotMoreInfo()
{
  kxInfoDialogImpl *c=new kxInfoDialogImpl(foundUin);
  c->show();
}
void kxRandomSearchImpl::SlotOk()
{
  hide();
}
void kxRandomSearchImpl::hide()
{
  QDialog::hide();
  delete this;
}

