#include "kxreceivedmessageimpl.h"
#include <klocale.h>
#include <qbrush.h>
#include <qcolor.h>
#include <qpainter.h>
#include "kxhistorywidget.h"
#include <kxcontact.h>
#include <kxengine.h>
#include <kxmessage.h>

kxHistoryWidgetItem::kxHistoryWidgetItem(int _pos,bool _showUin, QListView *_p) : QListViewItem(_p)
{
  pos=_pos;
  message="";
  showUin=_showUin;
}
void kxHistoryWidgetItem::paintCell(QPainter *_p, const QColorGroup &_cg, int _c, int _w, int)
{
  bool _resize=FALSE;
  if (isSelected() )
  {
    _p->fillRect(0,0,_w, height(),_cg.brush(QColorGroup::Highlight ) );
    _p->setPen(_cg.highlightedText());
  }
  else
  {
    _p->fillRect(0,0,_w, height(),_cg.brush(QColorGroup::Base ) );  
    _p->setPen(_cg.text()); 
  }  

//  if (message.length()<=0)
  {
    kxMessageStruct m;
    m=ENGINE->MESSAGE->getMessage(pos);
    if (m.uin>0)
    {
      date.sprintf("%02d/%02d/%04d %02d:%02d",m.dateTime.date().day()
                                           ,m.dateTime.date().month()
                                           ,m.dateTime.date().year()
                                           ,m.dateTime.time().hour()
                                           ,m.dateTime.time().minute()
       );
      sDate.sprintf("%04d/%02d/%02d %02d:%02d",m.dateTime.date().year()
                                           ,m.dateTime.date().month()
                                           ,m.dateTime.date().day()
                                           ,m.dateTime.time().hour()
                                           ,m.dateTime.time().minute()
       );

      send=m.send;
      m.message.replace(QRegExp("\r"),"");
      m.message.replace(QRegExp("\n")," ");
      message="";
      if (showUin)
        message.sprintf("(%d)",m.uin);        
      if (send) message+=">> ";
      else message+="<< ";

      if (m.nick.length()<=0)
      {
      	m.nick=ENGINE->CONTACT->getContact(m.uin).nick;
      	if (m.nick.length()<=0)
      		m.nick.sprintf("%d",m.uin);
      }      	

      switch(m.type)
      {
        case MESSAGE_TYPE: 
                    message+=m.message;
                    break;
        case URL_TYPE: 
                    message+=m.message+i18n(" ( URL: ")+m.url+" )";
                    break;
        case REQUEST_TYPE: 
                    message+=i18n("Authorization Request from ")+m.nick;
                    break;
        case ADDED_TYPE:
                    message+=i18n("Added by ")+m.nick;
                    break;
        case CONTACTS_TYPE:
        						message+=i18n("Contacts send by ")+m.nick;
        						break;
       	case REJECT_TYPE:
       							message+=i18n("Rejected by ")+m.nick;
       							break;
       	case AUTH_TYPE:
       							message+=i18n("Authorizedd by ")+m.nick;
       							break;
       	case SMS_TYPE:
       							message+=i18n("SMS Reply");
       							break;       							
      }
      _resize=TRUE;      
    }
  }
  if (send)
    _p->setPen(QColor(red));

  if (_c==1) 
  {
    _p->drawText(0,0,_w,height(),Qt::AlignLeft,message);
  }
  else
  {
    _p->drawText(0,0,_w,height(),Qt::AlignLeft,date);
  }    
  if (_resize)
  {
    widthChanged(1);
    widthChanged(0);
  }
}
int kxHistoryWidgetItem::width(const QFontMetrics &_fm, const QListView* _lv, int _c) const
{
  int w;
  QString tmp=text(_c);
  w=_fm.width(tmp)+_lv->itemMargin()*2;
  return QMAX(w,QApplication::globalStrut().width())+10;
}
QString kxHistoryWidgetItem::text(int _c) const
{
  if (_c==1)
  {
    return(message);
  }
  else
  {
    return(date);
  }
  return QString();
}
QString kxHistoryWidgetItem::key(int _c, bool) const
{
  return QString(QString("%1").arg(65000-pos,5));   
}
/* ***************************************************************************** */
kxHistoryWidget::kxHistoryWidget(UIN _uin,QWidget *_p, const char *_n) : QListView(_p, _n)
{
  addColumn("Date");
  addColumn("Message");  
  setMultiSelection(FALSE);
  setAllColumnsShowFocus(TRUE);
  setSelectionMode( QListView::Single);
  setHScrollBarMode(QScrollView::AlwaysOn);
  setSorting(0);
  uin=_uin;
  type=2;
  init(_uin);
  repaint();
  QObject::connect(ENGINE->MESSAGE, SIGNAL(SignalMessagePos(UIN,int)), this, SLOT(newMessage(UIN,int)));
}
kxHistoryWidget::kxHistoryWidget(UIN _uin,int _type,QWidget *_p, const char *_n) : QListView(_p, _n)
{
  addColumn("Date");
  addColumn("Message");  
  setMultiSelection(FALSE);
  setAllColumnsShowFocus(TRUE);
  setSelectionMode( QListView::Single);
  setHScrollBarMode(QScrollView::AlwaysOn);
  setSorting(0);
  uin=_uin;
  type=_type;
  init(_uin);
  repaint();
  QObject::connect(ENGINE->MESSAGE, SIGNAL(SignalMessagePos(UIN,int)), this, SLOT(newMessage(UIN,int)));
}

void kxHistoryWidget::init(UIN _uin)
{
  UIN t;
  for (t=0; t<ENGINE->MESSAGE->messageList.count(); t++)
  {
    if (_uin==0)
    {
      if (ENGINE->CONTACT->getContact(ENGINE->MESSAGE->messageList.at(t)->uin).uin==0)
      {
        bool show=TRUE;
        if (type==1 && ENGINE->MESSAGE->messageList.at(t)->send) show=FALSE;
        if (type==0 && !ENGINE->MESSAGE->messageList.at(t)->send) show=FALSE;      
        
        if (show) (void)new kxHistoryWidgetItem(t,TRUE,this);        
      }      
    }
    else
    {
      if (ENGINE->MESSAGE->messageList.at(t)->uin==_uin)
      {
        bool show=TRUE;
        if (type==1 && ENGINE->MESSAGE->messageList.at(t)->send) show=FALSE;
        if (type==0 && !ENGINE->MESSAGE->messageList.at(t)->send) show=FALSE;      

        if (show) (void)new kxHistoryWidgetItem(t,FALSE,this);
      }    
    }
  }
  sort();
  clearSelection();
  setSelected(firstChild(),TRUE);
  QObject::connect(this, SIGNAL(doubleClicked(QListViewItem *)), this, SLOT(SlotClicked(QListViewItem *)));
  repaint();
}
void kxHistoryWidget::newMessage(UIN _uin,int _p)
{
  if (uin==0)
  {
    if (ENGINE->CONTACT->getContact(_uin).uin==0)
    {
      bool show=TRUE;
      if (type==1 && ENGINE->MESSAGE->messageList.at(_p)->send) show=FALSE;
      if (type==0 && !ENGINE->MESSAGE->messageList.at(_p)->send) show=FALSE;      

      if (show) (void)new kxHistoryWidgetItem(_p,TRUE,this);
    }
  }
  if (_uin==uin)
  {
        bool show=TRUE;
        if (type==1 && ENGINE->MESSAGE->messageList.at(_p)->send) show=FALSE;
        if (type==0 && !ENGINE->MESSAGE->messageList.at(_p)->send) show=FALSE;      

        if (show) (void)new kxHistoryWidgetItem(_p,FALSE,this);
  }    
}
void kxHistoryWidget::changeUin(UIN _uin)
{
  clear();
  init(_uin);
}
void kxHistoryWidget::SlotClicked(QListViewItem *_i)
{
  kxHistoryWidgetItem *i;
  if (_i)
  {
    i=(kxHistoryWidgetItem*)_i;
    debug("Clicked: %d",i->pos);
    if (i)
    {
      kxReceivedMessageImpl *dialog=new kxReceivedMessageImpl(TRUE,i->pos,0L,"HistoryReview");
      dialog->show();  
    } 
  }
  else
  {
    debug("Non selected");
  }
}

