#ifndef KXFILEDIALOGIMPL2_H
#define KXFILEDIALOGIMPL2_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kanimwidget.h>
#include <v2_codes.h>
#include "kxfiledialog.h"
#include <ksock.h>
#include <kxfile.h>
#include <qstring.h>
#include <qobject.h>
#include <qwidget.h>

class kxFileDialogImpl : public kxFileDialog
{
  Q_OBJECT
public:
  kxFileDialogImpl(UIN,KServerSocket *, QString, int,int, QWidget* parent,
    const char* name = 0, int _seq=0);
  
  ~kxFileDialogImpl() {};

  kxFile *fileEngine;
  int port;
  int type;
  KServerSocket *sock;
  QString fileName;
  int size;
  UIN uin;
  int totalBatch;
  int current;
  KAnimWidget *sendAnim;
  
public slots:
  void SlotConnectError();  
  void SlotProcessInit(int, int); // batch len, total file size
  void SlotSaveFile(QString, int, int, int);  // fileName, file num, size, speed  
  void SlotServerInfo(int, int, QString, QString);    
  void SlotSizeUpdate(int);
  void SlotCanNotConnect();
  void SlotGotConnection();
  void SlotFileComplete();
  void SlotAllDone();
  void SlotSendOk();
  void hide();
  void SlotCancelButton();
};

#endif
