#ifndef KXCONTACTLIST_H
#define KXCONTACTLIST_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qdragobject.h>
#include <qlistview.h>
#include <krootpixmap.h>
#include <kxcontact.h>
#include <qwidget.h>

enum ItemType
{
	SEP_ONLINE=1,
	SEP_OFFLINE=3, SEP_WAITAUTH=7, SEP_UNKNOWN=9, SEP_NONICQ=5 };

class kxContactListItem : public QListViewItem
{
public:	

	kxContactListItem(Q_UINT32 , QListView *parent);
	kxContactListItem(Q_UINT32 , Q_UINT16, QListViewItem *parent);
	kxContactListItem(Q_UINT16 , QListView *parent);
	kxContactListItem(ItemType , QListView *parent);
	
	Q_UINT32 uin;
	Q_UINT16 groupID;
	Q_UINT16 type;
	bool group;
	
	bool focus;
	KRootPixmap *rootxpm;
	int prevColor;
	
	virtual QString key(int, bool) const;
	void setup();
	void paintCell(QPainter *,const QColorGroup & cg, int column, int width, int align ) ;
	void paintFocus(QPainter *,const QColorGroup & cg, const QRect &r);
	
	void doPaint(QPainter *,const QColorGroup & cg);
	
};

class kxContactList : public QListView
{
	Q_OBJECT
public:
	kxContactList(QWidget* parent=0, const char* name=0);
	
	bool showGroups;
	QPoint pressedPoint;
	Q_UINT32 uin;
	Q_UINT16 groupID;

	void init();	
	void addContact(Q_UINT32);
	void removeContact(Q_UINT32);
	void changeContact(Q_UINT32, Q_UINT16);
	Q_UINT16 countContactType(Q_UINT16);	
	void removeType(Q_UINT16);
	bool typeExists(Q_UINT16);
	void removeGroup(Q_UINT16);
	bool groupExists(Q_UINT16);
	bool userExists(Q_UINT32);
	
	bool isAuth(Q_UINT32);
	
	void countMessageOnline(Q_UINT16, bool *, Q_UINT16 *);
	
	void popupMenu(Q_UINT16, Q_UINT16, Q_UINT32, QPoint);
	
protected:
  void resizeEvent(QResizeEvent *);
	void viewportMousePressEvent(QMouseEvent *);
  void viewportMouseReleaseEvent(QMouseEvent *);
  void viewportMouseMoveEvent(QMouseEvent *);

  virtual void viewportDragEnterEvent(QDragEnterEvent*);
  virtual void viewportDropEvent(QDropEvent*);

public slots:
  void repaintContact(UIN);
  void slotAddGroup();
  void slotRemoveGroup();
  void slotRenameGroup();
  void SlotContactAdded(UIN, QString);

  void SlotSendMessage();
  void SlotSendMessages();
  void SlotSendUrl();
  void SlotInfo();
  void SlotRemove();
  void SlotUpdateNick();
  void SlotRenameNick();
  void SlotHistory();
  void SlotAskStatusMessage();
  void SlotSendFile();
  void SlotSendContacts();
  void SlotSetInvisible();
  void SlotSetOnlineNotify();
  void SlotSetVisible();
  void SlotSetAlwaysServer();
  void SlotSetIgnore();
  void SlotSetIntIP();
  void SlotReRequestAuth();
  void SlotSendSMS();
  void SlotChangeSMS();
    	
};

#endif

