#include "kxchangenickdialogimpl.h"
#include <kxengine.h>
#include <kxcontact.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <klocale.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qvalidator.h>
#include <qcombobox.h>
#include <kxcountry.h>
#include <qlayout.h>

kxAddPhoneDialog::kxAddPhoneDialog( QWidget* parent,  const char* name, bool mod) :
  kxChangeNickDialog(parent,name, mod)
{
	setSms=TRUE;
	setNick=TRUE;
  setCaption(i18n("Add Non ICQ contact"));
  groupName->setTitle(i18n("Non ICQ contact"));	
	init();
}
kxAddPhoneDialog::kxAddPhoneDialog( bool _sms,QWidget* parent,  const char* name, bool mod) :
  kxChangeNickDialog(parent,name, mod)
{
	setNick=FALSE;
	setSms=_sms;
  setCaption(i18n("Phone Number"));
  groupName->setTitle(i18n("Phone Number"));	
	init();
}
void kxAddPhoneDialog::init()
{
  QObject::connect(cancel, SIGNAL(clicked()), SLOT(SlotCancelButton()));
  QObject::connect(okButton, SIGNAL(clicked()), SLOT(SlotOkButton()));

  textLabel->hide();
	nick->hide();
  kxCountry c;
  c.init();

  QGridLayout *hbox=NULL;
  QVBoxLayout *Form1Layout=NULL;

  if (setNick)
  {
    Form1Layout = new QVBoxLayout( groupName->layout() );
    Form1Layout->setSpacing( 6 );
    Form1Layout->setMargin( 11 );

    QHBoxLayout *Layout2 = new QHBoxLayout;
    Layout2->setSpacing( 6 );
    Layout2->setMargin( 0 );

    QLabel *TextLabel2 = new QLabel( this, "TextLabel2" );
    TextLabel2->setText( tr( "Nick:" ) );
    Layout2->addWidget( TextLabel2 );

    nickString = new QLineEdit( this, "LineEdit1" );
    Layout2->addWidget( nickString );
    Form1Layout->addLayout( Layout2 );

    hbox = new QGridLayout;
	  hbox->setSpacing( 3 );
	  hbox->setMargin( 5 );
  }
  else
  {
	  hbox = new QGridLayout( groupName->layout());
	  hbox->setAlignment( Qt::AlignTop );
	  hbox->setSpacing( 3 );
	  hbox->setMargin( 5 );
	}
  QLabel *TextLabel2 = new QLabel( groupName, "TextLabel2" );
  TextLabel2->setText( i18n( "Country:"  ) );
  hbox->addWidget( TextLabel2, 0,0 );
  countryList = new QComboBox( FALSE, groupName, "urlString" );
  countryList->setMaximumSize( QSize( 200, 32767 ) );

  QDictIterator<char> it( c.countryDict ); // iterator for dict

  while ( it.current() ) {
      sl << it.current() ;
      ++it;
  }
  sl.sort();
  countryList->insertStringList(sl);


  hbox->addWidget( countryList, 1,0 );
  TextLabel2 = new QLabel( groupName, "TextLabel2" );
  TextLabel2->setText( i18n( "Prefix:"  ) );
  hbox->addWidget( TextLabel2,0,1 );

  prefixString = new QLineEdit( groupName, "urlString" );
  prefixString->setMaximumWidth(50);
  QIntValidator *val=new QIntValidator(0,9999, prefixString);
  prefixString->setValidator(val);
  hbox->addWidget( prefixString, 1,1 );

  TextLabel2 = new QLabel( groupName, "TextLabel2" );
  TextLabel2->setText( tr( "Number:"  ) );
  hbox->addWidget( TextLabel2,0,2 );

  numberString = new QLineEdit( groupName, "urlString" );
  QIntValidator *valn=new QIntValidator(0,9999, numberString);
  numberString->setValidator(valn);
  hbox->addWidget( numberString, 1,2 );

  if (setSms)
  {
  	sms= new QCheckBox(i18n("SMS capable"),groupName, "sms");
	  hbox->addWidget(sms, 2,0);
	}
	else
		sms=NULL;
		
	if (setNick)
	{
		Form1Layout->addLayout( hbox );
		resize(400,150);
		nickString->setFocus();		
	}
	else
		countryList->setFocus();	
}
void kxAddPhoneDialog::setPhone(QString _gsm, bool _sms=FALSE)
{
	if (_gsm.find("SMS")!=-1 && sms) sms->setChecked(TRUE);

  QStringList gsm=QStringList::split(' ',_gsm);
  kxCountry c;
  c.init();
  debug("%s - %s - %s - %s", (*gsm.at(0)).latin1(), (*gsm.at(1)).latin1(),(*gsm.at(2)).latin1(),(*gsm.at(3)).latin1());

  QString country;
  QString prefix;
  QString number;

  QString n1=(*gsm.at(0));
  QString n2=(*gsm.at(1));
  QString n3=(*gsm.at(2));

  if (n1[0]=='+') country=n1;
  else if (n1[0]=='(') prefix=n1;
  else number+=n1;
  if (n2[0]=='(') prefix=n2;
  else number=n2;
  number+=n3;

  country.replace(QRegExp("[()+]"),"");
  prefix.replace(QRegExp("[()+]"),"");
  number.replace(QRegExp("[()+]"),"");
  debug("SMS: %s - %s - %s",country.latin1(), prefix.latin1(), number.latin1());
  	
  QString look=c.getCountry(country);
  Q_UINT16 num=0;
  Q_UINT8 found=0;
  QStringList::Iterator it;
  it = sl.begin();
  do
  {      	
  	if ((*it).latin1()==look)
  	{      		
  		it=sl.end();
  		found=1;
  	}
  	else num++;
  	++it;
  }
  while(it != sl.end() && found==0 );
  	
  countryList->setCurrentItem( num );
  if (prefix.length()>0)
	  prefixString->setText("0"+prefix);
  numberString->setText(number);
}
QString kxAddPhoneDialog::getNumber()
{
	kxCountry c;
			QString num="+"+c.getCode( countryList->currentText() );
			if (num=="+0") num="";
    	QString prefix=prefixString->text();
    	QString number=numberString->text();    	
    	if (prefix[0]=='0')  prefix=prefix.right(prefix.length()-1);    	
    	QString gsmNum;
    	if (prefix.length()>0) gsmNum=num+" ("+prefix+") "+number;
    	else	gsmNum=num+" "+number;
			return gsmNum;
}
bool kxAddPhoneDialog::getSMS()
{
	if (sms) return sms->isChecked();
	return FALSE;
}
void kxAddPhoneDialog::SlotOkButton()
{
	accept();
}
void kxAddPhoneDialog::SlotCancelButton()
{
  reject();
}
void kxAddPhoneDialog::setNickString(QString _n)
{
	nickString->setText(_n);
}
QString kxAddPhoneDialog::getNick()
{
	return nickString->text();
}


//--



kxAddGroupDialog::kxAddGroupDialog( QWidget* parent,  const char* name, bool mod) :
  kxChangeNickDialog(parent,name, mod)
{
  QObject::connect(cancel, SIGNAL(clicked()), SLOT(SlotCancelButton()));
  QObject::connect(okButton, SIGNAL(clicked()), SLOT(SlotOkButton()));
  nick->setFocus();
  setCaption(i18n("Add Group"));
  groupName->setTitle(i18n("Group name"));
  textLabel->setText(i18n("Name:"));
  groupID=1000;
}
kxAddGroupDialog::kxAddGroupDialog( Q_UINT16 _id,QWidget* parent,  const char* name, bool mod) :
  kxChangeNickDialog(parent,name, mod)
{
	groupID=_id;
  QObject::connect(cancel, SIGNAL(clicked()), SLOT(SlotCancelButton()));
  QObject::connect(okButton, SIGNAL(clicked()), SLOT(SlotOkButton()));
  nick->setFocus();
  setCaption(i18n("Rename Group"));
  groupName->setTitle(i18n("Group name"));
  textLabel->setText(i18n("Name:"));
  nick->setText(ENGINE->CONTACT->getGroupName(_id));
}

QString kxAddGroupDialog::getText()
{
	return nick->text();
}
void kxAddGroupDialog::SlotOkButton()
{
	if (groupID==1000)
		ENGINE->CONTACT->addGroup(nick->text());
	accept();
}
void kxAddGroupDialog::SlotCancelButton()
{
  reject();
}

//--


kxChangeNickDialogImpl::kxChangeNickDialogImpl(UIN _uin, QWidget* parent,  const char* name) :
  kxChangeNickDialog(parent,name)
{
  uin=_uin;
  nick->setText(ENGINE->CONTACT->getContact(uin).nick);
  QObject::connect(cancel, SIGNAL(clicked()), SLOT(SlotCancelButton()));
  QObject::connect(okButton, SIGNAL(clicked()), SLOT(SlotOkButton()));
  nick->setFocus();
}
void kxChangeNickDialogImpl::SlotOkButton()
{
  ENGINE->CONTACT->rename(uin,nick->text());
  ENGINE->SlotContactChange(uin);
  hide();  
}
void kxChangeNickDialogImpl::SlotCancelButton()
{
  hide();
}
void kxChangeNickDialogImpl::hide()
{
  debug("Close RenameNickDialog");
  delete this;
}
