#ifndef KXSENDMESSAGEIMPL_H
#define KXSENDMESSAGEIMPL_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qgroupbox.h>
#include <qmultilineedit.h>
#include <qlayout.h>
#include <kxhistorywidget.h>
#include <kanimwidget.h>
#include <kxsend.h>
#include "kxSendMessage.h"
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qtimer.h>
#include <checklistbox.h>
#include <qlist.h>
#include <qcombobox.h>

struct sendContactStruct
{
  UIN uin;
  bool checked;
};

struct sendMoreStruct
{
  UIN uin;
  kxSend *send;
  int sendSeq;
};

class kxSendMessageImpl : public kxSendMessage
{
  Q_OBJECT
public:

  kxSendMessageImpl( Q_UINT32,int, QWidget *, const char *);
  kxSendMessageImpl( Q_UINT32,QString,int, QWidget *, const char *);
  kxSendMessageImpl( Q_UINT32,int, QString,QWidget *, const char *);
  void init();
  ~kxSendMessageImpl();
  

  bool sendMultiple;
  QList<struct sendMoreStruct> sendMoreList;
  QList<struct sendContactStruct> sendContactList;
  Q_UINT32 uin;
  int type;
  QTimer fileTimer;  
  bool doSend;
  int sendSeq;
  kxSend *send;
  QString file;
  KAnimWidget *sendAnim;
  QPushButton *fileButton;
  kxHistoryWidget *historyView;
  QGroupBox *moreView;
  QVBoxLayout* vbox_2;
  QHBoxLayout* moreLayout;
  QMultiLineEdit *messageString;
  CheckListBox *listBox;
 
  QLineEdit *urlString;

  QLineEdit  *prefixString, *numberString;
  QComboBox  *countryList;
  bool useColor;
  QColor fgColor;
  QColor bgColor;

public slots:
  virtual void hide();
  void SlotCancelButton();  
  void SlotSendButton();
  void SlotMoreButton();  
  void SlotHistoryButton();
  void SlotTextChanged();
  
  void SlotSendToClientError(int);
  void SlotSendToClientOk(int);
  void SlotSendToServerError(int);
  void SlotSendToServerOk(int);
  void SlotSelect();
  void SlotFileTimeout();
  void SlotFGColor();
	void SlotBGColor();
  
  void SlotChatAck(int,int,UIN,Q_UINT16, char*);
	void SlotSendToClient(UIN _uin);
	void SlotReceivedSMSAck(Q_UINT16, QString, QString);
};

#endif

