#include <checklistbox.h>
#include <kmessagebox.h>
#include <kxfiledialogimpl.h>
#include <kxtcp.h>
#include <kfiledialog.h>
#include <qtooltip.h>
#include <stdlib.h>
#include "kxSendMessageImpl.h"
#include "kxcontact.h"
#include "kxengine.h"
#include <qlabel.h>
#include <qobject.h>
#include <qmultilineedit.h>
#include <kxudp.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qdialog.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <kaccel.h>
#include <klocale.h>
#include <kanimwidget.h>
#include <qstringlist.h>
#include <kcolordialog.h>
#include <kwin.h>
#include <kxmainwindow.h>
#include <qdom.h>
#include <kxcountry.h>
#include <qvalidator.h>

kxSendMessageImpl::kxSendMessageImpl(Q_UINT32 _uin,int _type,QString _file,QWidget *_parent, const char *_name): kxSendMessage( _parent,_name)
{
  file=_file;
  uin=_uin;
  type=_type;
  init();
}
kxSendMessageImpl::kxSendMessageImpl(Q_UINT32 _uin,QString _txt,int _type,QWidget *_parent, const char *_name): kxSendMessage( _parent,_name)
{
//  file=_file;
  uin=_uin;
  type=_type;
  init();
  messageString->append(_txt);
  messageString->append(QString("\n"));
  messageString->setCursorPosition(messageString->numLines() ,1, FALSE);
}
kxSendMessageImpl::kxSendMessageImpl(Q_UINT32 _uin,int _type,QWidget *_parent, const char *_name) : kxSendMessage( _parent,_name)
{
  uin=_uin;
  type=_type;
  init();
}

void kxSendMessageImpl::init()
{
  QObject::connect(&fileTimer, SIGNAL(timeout()), SLOT(SlotFileTimeout()));
  if (type==URL_TYPE)
  	KWin::setIcons(winId(),MAINWINDOW->kxIcons.url,MAINWINDOW->kxIcons.url);
  else
  	KWin::setIcons(winId(),MAINWINDOW->kxIcons.message,MAINWINDOW->kxIcons.message);

  fgColor=ENGINE->CONTACT->getFGColor(uin);
	bgColor=ENGINE->CONTACT->getBGColor(uin);	
  useColor=TRUE;

  QObject::connect(fgColorButton, SIGNAL(clicked()), this, SLOT(SlotFGColor()));
  QObject::connect(bgColorButton, SIGNAL(clicked()), this, SLOT(SlotBGColor()));
  ENGINE->CONTACT->setSendWidget(uin,this);
  historyView=NULL;
  moreView=NULL;
  listBox=NULL;
  doSend=FALSE;
  sendSeq=0;
  send=NULL;
  sendMultiple=FALSE;
  sendMoreList.setAutoDelete(TRUE);
  sendContactList.setAutoDelete(TRUE);

  QStringList list;
  QString tmp;
  for (int t=1; t<=50; t++)
  {
    tmp.sprintf("kde/%04d",t);
    list.append(tmp);
  }

  sendAnim=new KAnimWidget(list, 22, animLabel, "anim");
  sendAnim->resize(25,25);
  
  QString tmpStr;
  messageBox->setColumnLayout(0, Qt::Vertical );
  messageBox->layout()->setSpacing( 0 );
  messageBox->layout()->setMargin( 0 );   

  if (type==REQUEST_TYPE)
  {
  	ENGINE->CONTACT->setWaitAuth(uin, TRUE);
  }

  if (type==URL_TYPE)
  {
    historyWidget->setGeometry(0,0,0,0);

    QHBoxLayout *hbox = new QHBoxLayout;
    hbox->setSpacing( 6 );
    hbox->setMargin( 0 );
   
    QLabel *TextLabel2 = new QLabel( messageBox, "TextLabel2" );
    TextLabel2->setText( tr( "URL:"  ) );
    hbox->insertWidget( 0,TextLabel2 );
   
    urlString = new QLineEdit( messageBox, "urlString" );
    hbox->addWidget( urlString );
       
    QVBoxLayout *vbox_2 = new QVBoxLayout(messageBox->layout()); 
    vbox_2->setAlignment( Qt::AlignTop );
    vbox_2->setSpacing( 6 );
    vbox_2->setMargin( 11 );
    
    messageString = new QMultiLineEdit( messageBox, "messageString" );
    messageString->setWordWrap( QMultiLineEdit::WidgetWidth );
    QToolTip::add(  messageString, tr( "Enter Message" ) );

    vbox_2->addLayout(hbox);
    vbox_2->addWidget(messageString);    
    
    setTabOrder( urlString, messageString);  
    setTabOrder( messageString, sendButton );
    setTabOrder( sendButton, throughServer );
    setTabOrder( throughServer, cancelButton );
    setTabOrder( cancelButton, showHistory );
    setTabOrder( showHistory, sendToMore );  
 
    urlString->setFocus();    
  }
  if (type==SMS_TYPE)
  {
    historyWidget->setGeometry(0,0,0,0);

    QGridLayout *hbox = new QGridLayout;
    hbox->setSpacing( 6 );
    hbox->setMargin( 0 );

    QLabel *TextLabel2 = new QLabel( messageBox, "TextLabel2" );
    TextLabel2->setText( i18n( "Country:"  ) );
    hbox->addWidget( TextLabel2, 0,0 );

    countryList = new QComboBox( FALSE, messageBox, "urlString" );
    countryList->setMaximumSize( QSize( 225, 32767 ) );

    throughServer->setEnabled(FALSE);
    sendToMore->setEnabled(FALSE);
    bgColorButton->setEnabled(FALSE);
		fgColorButton->setEnabled(FALSE);

    kxCountry c;
    c.init();

    QDictIterator<char> it( c.countryDict ); // iterator for dict
    QStringList sl;
    while ( it.current() ) {
        sl << it.current() ;
        ++it;
    }
    sl.sort();
    countryList->insertStringList(sl);

    hbox->addWidget( countryList, 1,0 );

    TextLabel2 = new QLabel( messageBox, "TextLabel2" );
    TextLabel2->setText( i18n( "Prefix:"  ) );
    hbox->addWidget( TextLabel2,0,1 );

    prefixString = new QLineEdit( messageBox, "urlString" );
    prefixString->setMaximumWidth(50);
    QIntValidator *val=new QIntValidator(0,9999, prefixString);
    prefixString->setValidator(val);
    hbox->addWidget( prefixString, 1,1 );

    TextLabel2 = new QLabel( messageBox, "TextLabel2" );
    TextLabel2->setText( i18n( "Number:"  ) );
    hbox->addWidget( TextLabel2,0,2 );

    numberString = new QLineEdit( messageBox, "urlString" );
    QIntValidator *valn=new QIntValidator(0,9999, numberString);
    numberString->setValidator(valn);
    hbox->addWidget( numberString, 1,2 );

    QStringList gsm=QStringList::split(' ',ENGINE->CONTACT->getContact(uin).gsm);
    debug("%s - %s - %s - %s", (*gsm.at(0)).latin1(), (*gsm.at(1)).latin1(),(*gsm.at(2)).latin1(),(*gsm.at(3)).latin1());
    if ((*gsm.at(3))=="SMS")
    {
	    QString country=(*gsm.at(0));
			QString prefix=(*gsm.at(1));
			QString number=(*gsm.at(2));
	    country.replace(QRegExp("[()+]"),"");
	    prefix.replace(QRegExp("[()+]"),"");
	    number.replace(QRegExp("[()+]"),"");
	    debug("SMS: %s - %s - %s",country.latin1(), prefix.latin1(), number.latin1());
	
	    QString look=c.getCountry(country);
			Q_UINT16 num=0;
      Q_UINT8 found=0;
      QStringList::Iterator it;
      it = sl.begin();
      do
      {      	
      	if ((*it).latin1()==look)
      	{      		
      		it=sl.end();
      		found=1;
      	}
      	else num++;
      	++it;
      }
      while(it != sl.end() && found==0 );
	
	    countryList->setCurrentItem( num );
	    prefixString->setText("0"+prefix);
	    numberString->setText(number);
	  }
	  else debug("No SMS %s", ENGINE->CONTACT->getContact(uin).gsm.latin1());

    QVBoxLayout *vbox_2 = new QVBoxLayout(messageBox->layout());
    vbox_2->setAlignment( Qt::AlignTop );
    vbox_2->setSpacing( 6 );
    vbox_2->setMargin( 11 );

    messageString = new QMultiLineEdit( messageBox, "messageString" );
    messageString->setWordWrap( QMultiLineEdit::WidgetWidth );
    QToolTip::add(  messageString, tr( "Enter Message" ) );

    messageString->setMaxLength(160);

    vbox_2->addLayout(hbox);
    vbox_2->addWidget(messageString);

    setTabOrder( countryList, prefixString);
    setTabOrder( prefixString, numberString);
    setTabOrder( numberString, messageString);
    setTabOrder( messageString, sendButton );
    setTabOrder( sendButton, throughServer );
    setTabOrder( throughServer, cancelButton );
    setTabOrder( cancelButton, showHistory );
    setTabOrder( showHistory, sendToMore );
    messageString->setFocus();
  }
  else
  {
    if (type==MESSAGE_TYPE || type==REJECT_TYPE || type==REQUEST_TYPE)
    {
      historyWidget->setGeometry(0,0,0,0);
      QVBoxLayout *vbox_2 = new QVBoxLayout( messageBox->layout() );
      vbox_2->setAlignment( Qt::AlignTop );
      vbox_2->setSpacing( 6 );
      vbox_2->setMargin( 11 );
      messageString = new QMultiLineEdit( messageBox, "messageString" );
      messageString->setWordWrap( QMultiLineEdit::WidgetWidth );
      QToolTip::add(  messageString, tr( "Enter Message" ) );
      
      vbox_2->addWidget( messageString );
      vbox_2->activate();
  
      setTabOrder( messageString, sendButton );
      setTabOrder( sendButton, throughServer );
      setTabOrder( throughServer, cancelButton );
      setTabOrder( cancelButton, showHistory );
      setTabOrder( showHistory, sendToMore );  
      messageString->setFocus();
    }
    else
    {
      if (type==FILE_TYPE)
      {
        historyWidget->setGeometry(0,0,0,0);
    
        QHBoxLayout *hbox = new QHBoxLayout;
        hbox->setSpacing( 6 );
        hbox->setMargin( 0 );
       
        QLabel *TextLabel2 = new QLabel( messageBox, "TextLabel2" );
        TextLabel2->setText( tr( "File:"  ) );
        hbox->insertWidget( 0,TextLabel2 );
       
        urlString = new QLineEdit( messageBox, "urlString" );
        hbox->addWidget( urlString );
        
        fileButton = new QPushButton(messageBox, "fileButton");
        QObject::connect(fileButton,SIGNAL(clicked()),this, SLOT(SlotSelect()));
        fileButton->setText(i18n("Select"));
        hbox->addWidget(fileButton);
           
        QVBoxLayout *vbox_2 = new QVBoxLayout(messageBox->layout()); 
        vbox_2->setAlignment( Qt::AlignTop );
        vbox_2->setSpacing( 6 );
        vbox_2->setMargin( 11 );
        
        messageString = new QMultiLineEdit( messageBox, "messageString" );
        messageString->setWordWrap( QMultiLineEdit::WidgetWidth );
        QToolTip::add(  messageString, tr( "Enter Message" ) );
    
        vbox_2->addLayout(hbox);
        vbox_2->addWidget(messageString);            
        
        setTabOrder( messageString, fileButton);
        setTabOrder( fileButton,sendButton );
        setTabOrder( sendButton, throughServer );
        setTabOrder( throughServer, cancelButton );
        setTabOrder( cancelButton, showHistory );
        setTabOrder( showHistory, sendToMore );  
     
        messageString->setFocus();    
        setCaption("Send File");
        showHistory->setEnabled(FALSE);
        sendToMore->setEnabled(FALSE);
        throughServer->setEnabled(FALSE);
        if (file.length()<=0) SlotSelect();
        else  urlString->setText(file);
//        show();
      }
    }
  }
    
  if (type==REJECT_TYPE)
  {
    setCaption(i18n("Reject Message"));
    throughServer->setEnabled(FALSE);
  }
  else
  {
		if (type==REQUEST_TYPE)
  	{
  		setCaption(i18n("Ask Authorization"));
  		throughServer->setEnabled(FALSE);
	    sendToMore->setEnabled(FALSE);
	    bgColorButton->setEnabled(FALSE);
			fgColorButton->setEnabled(FALSE);
			resize(200,200);						 		
  				
  	}
  	else
	    throughServer->setChecked(ENGINE->CONTACT->getContact(uin).alwaysServer);
	}
  
  tmpStr.sprintf("%d",uin);  
  uinLabel->setText(tmpStr.latin1());
  if (strlen(ENGINE->CONTACT->getContact(uin).nick)>0)
    nickLabel->setText(ENGINE->CONTACT->getContact(uin).nick); 
  else
    nickLabel->setText(i18n("<Unknown> ")+QString().setNum(uin));

  QObject::connect((QObject *)cancelButton, SIGNAL(clicked()), this, SLOT(SlotCancelButton()));
  QObject::connect((QObject *)sendButton, SIGNAL(clicked()), this, SLOT(SlotSendButton()));
  QObject::connect((QObject *)sendToMore, SIGNAL(clicked()), this, SLOT(SlotMoreButton()));
  QObject::connect(messageString,SIGNAL(textChanged()), this, SLOT(SlotTextChanged()));  
  QObject::connect((QObject *)showHistory, SIGNAL(clicked()), this, SLOT(SlotHistoryButton()));  
  
  sendButton->setEnabled(FALSE);
  
  KAccel *a = new KAccel(this);
  a->insertItem(i18n("Send"), "Send",Key_S + ALT);
  a->connectItem("Send",this,SLOT(SlotSendButton()));
  a->insertItem(i18n("Send2"), "Send2",Key_Enter + CTRL);
  a->connectItem("Send2",this,SLOT(SlotSendButton()));
  a->insertItem(i18n("Send3"), "Send3",Key_Return + CTRL);
  a->connectItem("Send3",this,SLOT(SlotSendButton()));
  if (messageString)
  {
 	  QPalette pal = messageString->palette();
    QColor c=fgColor;
    #if QT_VERSION >= 210
      pal.setColor(QPalette::Active, QColorGroup::Text, c);
      pal.setColor(QPalette::Inactive, QColorGroup::Text, c);
    #else
      pal.setColor(QPalette::Active, QColorGroup::Text, c);
      pal.setColor(QPalette::Normal, QColorGroup::Text, c);
    #endif
    c=bgColor;
    #if QT_VERSION >= 210
      pal.setColor(QPalette::Active, QColorGroup::Base, c);
      pal.setColor(QPalette::Inactive, QColorGroup::Base, c);
    #else
      pal.setColor(QPalette::Active, QColorGroup::Base, c);
      pal.setColor(QPalette::Normal, QColorGroup::Base, c);
    #endif		

		messageString->setPalette(pal);
	}
}
kxSendMessageImpl::~kxSendMessageImpl()
{
  debug("~close");
}

void kxSendMessageImpl::SlotCancelButton()
{
  if (doSend)
  {
    if (sendMultiple)
    {
      for (Q_UINT16 t=0; t<sendMoreList.count(); t++)
      {
        sendMoreList.remove(t);
        t=0;
      }
      close();
      return;
    }
    sendAnim->stop();
    doSend=FALSE;
    sendButton->setEnabled(TRUE);
    messageString->setEnabled(TRUE);    
    messageString->setFocus();
  }
  else
    close();
}
void kxSendMessageImpl::SlotMoreButton()
{
  if (listBox!=NULL)
  {
  	delete listBox;
    delete moreLayout;
//    moreWidget->setMinimumSize(0,0);
//    moreWidget->resize(0,height());
		listBox=NULL;
    moreView=NULL;
    sendToMore->setDown(FALSE);    
    sendToMore->setText(">>");    
    QString tmpStr;
    tmpStr.sprintf("%d",uin);  
    uinLabel->setText(tmpStr.latin1());
    if (strlen(ENGINE->CONTACT->getContact(uin).nick)>0)
      nickLabel->setText(ENGINE->CONTACT->getContact(uin).nick); 
    else
      nickLabel->setText(i18n("<Unknown> ")+QString().setNum(uin));
    sendMultiple=FALSE;
    resize(width()-100,height());
    updateGeometry();

  }
  else
  {
    debug("show hist! ");
    moreLayout = new QHBoxLayout( moreWidget );
    moreLayout->setSpacing( 0 );
    moreLayout->setMargin( 0 );    

    listBox=new CheckListBox(moreWidget,"list");
    listBox->showHeader(FALSE);
    listBox->allowEditing(FALSE);
    listBox->allowActions(FALSE);
    listBox->allowIconShow(FALSE);
    listBox->show();

    moreLayout->addWidget( listBox );
    moreLayout->activate();

    sendToMore->setDown(TRUE);
    sendToMore->setText("<<");
    for (Q_UINT16 t=0; t<ENGINE->CONTACT->count(); t++)
    {
      bool c=FALSE;
      if (uin==ENGINE->CONTACT->getContact((int)t).uin) c=TRUE;
      listBox->insertItem(ENGINE->CONTACT->getContact((int)t).nick, c);      
    }  
    nickLabel->setText(i18n("<Multiple>"));
    uinLabel->setText(i18n("<Multiple>"));    
    sendMultiple=TRUE;

    resize(width()+100,height());
    updateGeometry();
  }
}
void kxSendMessageImpl::SlotHistoryButton()
{
  if (historyView!=NULL)
  {
    delete vbox_2;
    delete historyView;
    historyWidget->setMinimumSize(0,0);
    resize(width(),height()-75);
    updateGeometry();    
    historyView=NULL;
    showHistory->setDown(FALSE);    
  }
  else
  {
    debug("show hist! ");
    vbox_2 = new QVBoxLayout( historyWidget );
    vbox_2->setSpacing( 0 );
    vbox_2->setMargin( 0 );   
    historyView = new kxHistoryWidget(uin, historyWidget, "historyView" );
    historyView->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)4, historyView->sizePolicy().hasHeightForWidth() ) );
    historyView->setFocusPolicy( QListView::NoFocus );
    historyView->show();    
    vbox_2->addWidget( historyView );        
    vbox_2->activate();
    historyWidget->setMinimumSize(0,75);
    historyWidget->resize(10,75);    
    resize(width(),height()+75);
    updateGeometry();
    showHistory->setDown(TRUE);
  }
}
void kxSendMessageImpl::SlotSendButton()
{
	if (!ENGINE->loggedOn())
		return;

  if (messageString->text().length()>0)
  {
  	if (type==REQUEST_TYPE)
  	{
      QString sendMsg=messageString->text();
      sendMsg.replace(QRegExp("\n"),"\r\n");  	
  		ENGINE->sendAuthRequest(uin,sendMsg);
  		close();
  		return;
  	}
    if (type==FILE_TYPE)
    {
      int sock;
      sock=ENGINE->TCP->connect(uin);
      if (sock>0)
      {
	      QObject::connect(ENGINE->TCP, SIGNAL(receivedHandshakeAck(UIN)), SLOT(SlotSendToClient(UIN)));
      }
      else
      {
        KMessageBox::sorry(this, i18n("Cannot connect to the contact..."),i18n("File transfer connection error"));
        hide();
      }     

      return;
    }
    if (type==SMS_TYPE)
    {
    	kxCountry c;
    	
    	QString num="+"+c.getCode( countryList->currentText() );
    	QString prefix=prefixString->text();
    	QString number=numberString->text();    	
    	if (prefix[0]=='0')  prefix=prefix.right(prefix.length()-1);
    	QString gsmNum=num+" ("+prefix+") "+number+" SMS";
    	num+=prefix+number;
    	
    	debug("SMS %s, send: %s",gsmNum.latin1(), num.latin1());
//    	if (ENGINE->CONTACT->getContact(uin).gsm.length()<=0)
      ENGINE->CONTACT->setGSM(uin, gsmNum);
    	
	    QString sendMsg=messageString->text();
      sendMsg.replace(QRegExp("\n"),"\r\n");
      QObject::connect(ENGINE, SIGNAL(SignalReceivedSMSAck(Q_UINT16, QString, QString)), this,
      												SLOT(SlotReceivedSMSAck(Q_UINT16, QString, QString)));
      sendSeq=ENGINE->sendSMS(num, sendMsg, MAINWINDOW->kxConfig.nick);
      sendAnim->start();
      sendButton->setEnabled(FALSE);
      messageString->setEnabled(FALSE);
      prefixString->setEnabled(FALSE);
      numberString->setEnabled(FALSE);
      countryList->setEnabled(FALSE);
      //;
    }
    else
    if (type==MESSAGE_TYPE || type==URL_TYPE)
    {   
      QString sendMsg=messageString->text();
      sendMsg.replace(QRegExp("\n"),"\r\n");             
      if (sendMultiple)
      {
        doSend=FALSE;        
        for (Q_UINT16 t=0; t<listBox->count(); t++)
        {
          if (listBox->item(t)->isChecked())
          {
            struct sendContactStruct *_scl;
            _scl=new sendContactStruct;
            _scl->checked=TRUE;          
            UIN _uin=0;
            QString _nick=listBox->item(t)->text();
            for (Q_UINT16 ct=0; ct<ENGINE->CONTACT->count(); ct++)
            {              
              if (_nick==ENGINE->CONTACT->getContact((int)ct).nick)
              {
                _uin=ENGINE->CONTACT->getContact((int)ct).uin;
                ct=ENGINE->CONTACT->count()+1;
              }
            }                        
            _scl->uin=_uin;
            sendContactList.append(_scl);
          }         
        }
        listBox->clear();        
        for (Q_UINT16 t=0; t<sendContactList.count(); t++)
        {
          if (sendContactList.at(t)->checked)
          {
            UIN _uin=sendContactList.at(t)->uin;
            struct sendMoreStruct *snd;
            snd=new sendMoreStruct;
            snd->uin=_uin;
            listBox->insertItem(ENGINE->CONTACT->getContact(_uin).nick,FALSE);
            if (type==MESSAGE_TYPE)
              snd->send=ENGINE->sendMessage(_uin, sendMsg,throughServer->isChecked(),  fgColor, bgColor, useColor);
            else  
              snd->send=ENGINE->sendUrl(_uin, sendMsg,urlString->text(),throughServer->isChecked(), fgColor, bgColor, useColor);
            if (snd->send==NULL) return;
            snd->sendSeq=snd->send->sendSeq; // needed voor auto deletion of send !
            QObject::connect(snd->send, SIGNAL(SignalSendToClientOk(int)), this, SLOT(SlotSendToClientOk(int)));
            QObject::connect(snd->send, SIGNAL(SignalSendToClientError(int)), this, SLOT(SlotSendToClientError(int)));  
            QObject::connect(snd->send, SIGNAL(SignalSendToServerOk(int)), this, SLOT(SlotSendToServerOk(int)));
            QObject::connect(snd->send, SIGNAL(SignalSendToServerError(int)), this, SLOT(SlotSendToServerError(int))); 
            
            sendMoreList.append(snd);
            if (!doSend)
            {
              sendButton->setEnabled(FALSE);
              messageString->setEnabled(FALSE);
              sendAnim->start();             
               
              doSend=TRUE;            
            }
            if (snd->send->send) SlotSendToServerOk(snd->sendSeq);
          }
        }
      }
      else
      {    
  
        if (type==MESSAGE_TYPE)
          send=ENGINE->sendMessage(uin, sendMsg,throughServer->isChecked(), fgColor, bgColor, useColor);
        else  
          send=ENGINE->sendUrl(uin, sendMsg,urlString->text(),throughServer->isChecked(), fgColor, bgColor, useColor);
				if (send==NULL) return;
        doSend=TRUE;
        sendSeq=send->sendSeq;
        sendButton->setEnabled(FALSE);
        messageString->setEnabled(FALSE);
        sendAnim->start();
        
        QObject::connect(send, SIGNAL(SignalSendToClientOk(int)), this, SLOT(SlotSendToClientOk(int)));
        QObject::connect(send, SIGNAL(SignalSendToClientError(int)), this, SLOT(SlotSendToClientError(int)));  
        QObject::connect(send, SIGNAL(SignalSendToServerOk(int)), this, SLOT(SlotSendToServerOk(int)));
        QObject::connect(send, SIGNAL(SignalSendToServerError(int)), this, SLOT(SlotSendToServerError(int)));
        if (send->send) SlotSendToServerOk(sendSeq);
      }
    }
    else
    {
      ENGINE->rejectContact(uin, messageString->text());
      close();
    }
  }
}
void kxSendMessageImpl::SlotSendToClient(UIN _uin)
{
	if (_uin==uin)
	{
        QFile f(file);
        Q_UINT32 size=f.size();
        debug("File size is now: (%s) %d, %d",file.latin1(),size, f.exists());
        int c=0;
        QString newFile;
        for (Q_UINT16 t=0; t<file.length(); t++)
        {
          if (file[t]=='/' || file[t]=='\\')
            c=t;
        }
        for (Q_UINT16 t=c+1; t<file.length(); t++)
        {
          newFile+=file[t];
        }
        sendAnim->start();
        sendButton->setEnabled(FALSE);
        messageString->setEnabled(FALSE);
        fileButton->setEnabled(FALSE);
        QObject::connect(ENGINE->TCP, SIGNAL(receivedChatAck(int,int,UIN,Q_UINT16, char*)), this,
          SLOT(SlotChatAck(int,int,UIN,Q_UINT16, char*)));
        sendSeq=ENGINE->TCP->sendFileRequest(uin,messageString->text().latin1(),newFile.latin1(),size);
        fileTimer.start(30000);
	}
}
void kxSendMessageImpl::hide()
{
  debug("Close/Hide !!");
  QDialog::hide();
  ENGINE->CONTACT->setSendWidget(uin);
  if (send) delete send;
  delete this;
}  
void kxSendMessageImpl::SlotTextChanged()
{
	if (!ENGINE->loggedOn())
	{
		sendButton->setEnabled(FALSE);
		return;
	}
  if (messageString->text().length()>0)
    sendButton->setEnabled(TRUE);
  else
    sendButton->setEnabled(FALSE);
}
void kxSendMessageImpl::SlotSendToClientError(int _s)
{
  if (sendMultiple)
  {
    for (Q_UINT16 t=0; t<sendMoreList.count(); t++)
    {
      struct sendMoreStruct *_snd;
      _snd=sendMoreList.at(t);
      if (_s==_snd->sendSeq)
        _snd->send->sendToServer();
    }
  }
  else
  {
    throughServer->setChecked(TRUE);
    ENGINE->CONTACT->setAlwaysServer(uin,TRUE,FALSE);
    send->sendToServer();
  }
}
void kxSendMessageImpl::SlotSendToClientOk(int _s)
{
  if (sendMultiple)
  {
    for (Q_UINT16 t=0; t<sendMoreList.count(); t++)
    {
      struct sendMoreStruct *_snd;
      _snd=sendMoreList.at(t);
      if (_s==_snd->sendSeq)
      {
        sendMoreList.remove(t);
        if (sendMoreList.count()<=0)
        {
          close();
          return;
        }
        else
        {
          t=0;
        }
      }
    }
  }
  else
  {
    if (_s==sendSeq)
      close();
  }
}
void kxSendMessageImpl::SlotSendToServerError(int _s)
{

}
void kxSendMessageImpl::SlotSendToServerOk(int _s)
{
  if (sendMultiple)
  {
    for (Q_UINT16 t=0; t<sendMoreList.count(); t++)
    { 
      struct sendMoreStruct *_snd;
      _snd=sendMoreList.at(t);
      if (_s==_snd->sendSeq)
      {
        debug("Send !! %d",sendMoreList.count());
        sendMoreList.remove(t);
        debug("Send !! %d",sendMoreList.count());        
        if (sendMoreList.count()<=0)
        {
          close();
          return;
        }
        else
        {
          t=0;
        }
      }  
    }
  }
  else
  {
    if (_s==sendSeq)
      close();
  }
}
void kxSendMessageImpl::SlotSelect()
{
        QString f(KFileDialog::getOpenFileName(QString::null,"All files (*.*)",this));
        if (!f.isEmpty())
        {
          file=f;
          urlString->setText(f);
        }      
}
void kxSendMessageImpl::SlotChatAck(int _seq,int _status,UIN _uin,Q_UINT16 _port, char*_msg)
{
  if (_seq==sendSeq && _uin==uin && !_status && _port!=0)
  {
    QFile f(file);
    int size=f.size();
    kxFileDialogImpl *dialog=new kxFileDialogImpl(uin, 0L, file, size,_port,0L, "file");
    dialog->show();
    hide();
  }
  else
  {
    debug("rejected !!!!");
    QString msg=_msg;
    if (msg.length()<=0) msg=i18n("No reason given...");
    KMessageBox::sorry(this,i18n("The Filefransfer has been rejected with the following reason:\n\n"+msg), i18n("Filetransfer rejected"));
    hide();
  }
}
void kxSendMessageImpl::SlotFileTimeout()
{
  KMessageBox::sorry(this, i18n("Cannot connect to the contact..."),i18n("File transfer connection error"));
  hide();
}

void kxSendMessageImpl::SlotFGColor()
{
  QColor myColor;
  int result = KColorDialog::getColor( myColor );
  if ( result == KColorDialog::Accepted )	
  {
  	useColor=TRUE;
  	fgColor=myColor;
	  QPalette pal = messageString->palette();
    QColor c=myColor;
    #if QT_VERSION >= 210
      pal.setColor(QPalette::Active, QColorGroup::Text, c);
      pal.setColor(QPalette::Inactive, QColorGroup::Text, c);
    #else
      pal.setColor(QPalette::Active, QColorGroup::Text, c);
      pal.setColor(QPalette::Normal, QColorGroup::Text, c);
    #endif
		ENGINE->CONTACT->setColor(uin, fgColor, bgColor);
		messageString->setPalette(pal);		
  }
}
void kxSendMessageImpl::SlotBGColor()
{
  QColor myColor;
  int result = KColorDialog::getColor( myColor );
  if ( result == KColorDialog::Accepted )	
  {
  	useColor=TRUE;
  	bgColor=myColor;
	  QPalette pal = messageString->palette();
    QColor c=myColor;
    #if QT_VERSION >= 210
      pal.setColor(QPalette::Active, QColorGroup::Base, c);
      pal.setColor(QPalette::Inactive, QColorGroup::Base, c);
    #else
      pal.setColor(QPalette::Active, QColorGroup::Base, c);
      pal.setColor(QPalette::Normal, QColorGroup::Base, c);
    #endif

		messageString->setPalette(pal);  	
		ENGINE->CONTACT->setColor(uin, fgColor, bgColor); 	
  }
}
void kxSendMessageImpl::SlotReceivedSMSAck(Q_UINT16 seq, QString uin, QString str)
{
	if (sendSeq==seq)
	{
		QString source;
		QString network;
		QString  deliverable;
	
		QDomDocument d;
		d.setContent(str);
		QDomNode n = d.firstChild();
		while( !n.isNull() )
		{
			QDomNodeList l=n.childNodes();
			for (Q_UINT16 t=0; t<=l.length(); t++)
			{
				if (l.item(t).toElement().tagName()=="source") source=l.item(t).toElement().text();
				if (l.item(t).toElement().tagName()=="network") network=l.item(t).toElement().text();
				if (l.item(t).toElement().tagName()=="deliverable") deliverable=l.item(t).toElement().text();								
			}		
			n=n.nextSibling();
		}			
		debug("SMS: source: %s, network: %s, deli: %s",source.latin1(), network.latin1(), deliverable.latin1());
		if ( deliverable=="Yes")
			KMessageBox::information(this, i18n("The SMS has been delivered to ")+source+i18n("\nIt will be send via ")+network, i18n("SMS"));
		else
		 	KMessageBox::information(this, i18n("The SMS has NOT been delivered"), i18n("SMS"));
		SlotSendToServerOk(sendSeq);
	}
}
