#include "kxinfo_homeimpl.h"
#include <qmultilineedit.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <kxcountry.h>
/*

 *  Constructs a kxInfoHomeImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
kxInfoHomeImpl::kxInfoHomeImpl( QWidget*_p,QWidget* parent,  const char* name, WFlags fl )
    : kxInfo_Home( parent, name, fl )
{
	dialog=(kxExtInfoDialog *)_p;
}

/*  
 *  Destroys the object and frees any allocated resources
 */
kxInfoHomeImpl::~kxInfoHomeImpl()
{
    // no need to delete child widgets, Qt does it all for us
}

void kxInfoHomeImpl::apply()
{
	kxCountry c;
	Q_UINT16 con;
	Q_UINT8 gm;
	con=c.getCode( countryBox->currentText()).toInt();	
	gm=c.getGMTCode( offsetBox->currentText()).toInt();
	dialog->setHome(streetLabel->text(),cityLabel->text(),stateLabel->text(),zipLabel->text(),con, gm);
}
void kxInfoHomeImpl::init()
{
    kxCountry c;
    c.init();

    QDictIterator<char> it( c.countryDict ); // iterator for dict

    while ( it.current() ) {
        sl << it.current() ;
        ++it;
    }
    sl.sort();
    countryBox->insertStringList(sl);
    c.gmtInit();

    QDictIterator<char> git( c.gmtDict ); // iterator for dict

    while ( git.current() ) {
        gmtsl << git.current() ;
        ++git;
    }
    gmtsl.sort();
    offsetBox->insertStringList(gmtsl);
}
void kxInfoHomeImpl::disableAll()
{
	streetLabel->setEnabled(FALSE);
	zipLabel->setEnabled(FALSE);
	stateLabel->setEnabled(FALSE);
	cityLabel->setEnabled(FALSE);
	countryBox->setEnabled(FALSE);
	offsetBox->setEnabled(FALSE);
}
void kxInfoHomeImpl::enableAll()
{
	streetLabel->setEnabled(TRUE);
	zipLabel->setEnabled(TRUE);
	stateLabel->setEnabled(TRUE);
	cityLabel->setEnabled(TRUE);
	countryBox->setEnabled(TRUE);
	offsetBox->setEnabled(TRUE);
}
void kxInfoHomeImpl::SlotReceivedMainHomeInfo( QString _n,QString _f,QString _l,QString _e,QString _c,QString _st,QString _p,QString _fa,QString _ste,QString _ce,QString _zip,Q_UINT16 _con, Q_UINT8 _gmt, Q_UINT8 _pubEmail)
{
		kxCountry c;
		QString tmp;
		tmp.sprintf("%d",_con);
    QString look=c.getCountry(tmp);
		Q_UINT16 num=0;
     Q_UINT8 found=0;
     QStringList::Iterator it;
     it = sl.begin();
     do
     {      	
     	if ((*it).latin1()==look)
     	{      		
     		it=sl.end();
     		found=1;
     	}
     	else num++;
     	++it;
     }
     while(it != sl.end() && found==0 );
    countryBox->setCurrentItem( num );	
		num=0;
    found=0;
    char newGmt=_gmt;
		tmp.sprintf("%d",newGmt);
		debug("Look for: %d",newGmt);
    look=c.getGMT(tmp);
    QStringList::Iterator git;
    git = gmtsl.begin();
    do
     {      	
     	if ((*git).latin1()==look)
     	{      		
     		git=gmtsl.end();
     		found=1;
     	}
     	else num++;
     	++git;
     }
     while(it != gmtsl.end() && found==0 );

    offsetBox->setCurrentItem( num );		
    	
  	stateLabel->setText(_st);
  	zipLabel->setText(_zip);	
  	streetLabel->setText(_ste);
  	cityLabel->setText(_c);
  		
}

