#include "kxinfo_basicimpl.h"
#include <qlistview.h>
#include <qmultilineedit.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qcheckbox.h>
#include <qlistview.h>
#include <qbutton.h>
#include <kxemaildialogimpl.h>
#include <kxengine.h>
#include <qgroupbox.h>
/* 
 *  Constructs a kxInfoBasicImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
kxInfoBasicImpl::kxInfoBasicImpl(QWidget*_p, QWidget* parent,  const char* name, WFlags fl )
    : kxInfoBasic( parent, name, fl )
{
	dialog=(kxExtInfoDialog *)_p;
	
	uinLabel->setText(QString("%1").arg(ENGINE->ourUin));
	
	networkGroup->hide();
	
	QObject::connect(emailView, SIGNAL(pressed(QListViewItem *)), SLOT(slotClicked(QListViewItem *)));
	QObject::connect(setPrimaryButton, SIGNAL(clicked()), SLOT(slotSetPrimaryButton()));
	QObject::connect(addButton, SIGNAL(clicked()), SLOT(slotAddButton()));
	QObject::connect(deleteButton, SIGNAL(clicked()), SLOT(slotDeleteButton()));
	QObject::connect(changeButton, SIGNAL(clicked()), SLOT(slotChangeButton()));
}

/*  
 *  Destroys the object and frees any allocated resources
 */
kxInfoBasicImpl::~kxInfoBasicImpl()
{
    // no need to delete child widgets, Qt does it all for us
}

void kxInfoBasicImpl::apply()
{
	if (dialog)	
	{		
		dialog->setMain(nickLabel->text(), firstNameLabel->text(),lastNameLabel->text(), primaryLabel->text(), publishBox->isOn());	
		QCheckListItem * myChild = (QCheckListItem *)emailView->firstChild();
		QStringList lst;
	  while( myChild )
	  {
	  	if (myChild->text() != primaryLabel->text())
	  	{
		  	lst << myChild->text();
		  	lst << (myChild->isOn()?"Y":"N");
		 	}
	    myChild = (QCheckListItem *)myChild->nextSibling();	
  	}			
  	dialog->setEmailList(lst);
	}
	else
		debug("Huh ?");
}
void kxInfoBasicImpl::init()
{
}
void kxInfoBasicImpl::disableAll()
{
	nickLabel->setEnabled(FALSE);
	firstNameLabel->setEnabled(FALSE);	
	lastNameLabel->setEnabled(FALSE);
	ipLabel->setEnabled(FALSE);	
	portLabel->setEnabled(FALSE);
	publishBox->setEnabled(FALSE);
	addButton->setEnabled(TRUE);
}
void kxInfoBasicImpl::enableAll()
{
	nickLabel->setEnabled(TRUE);
	firstNameLabel->setEnabled(TRUE);	
	lastNameLabel->setEnabled(TRUE);
	ipLabel->setEnabled(TRUE);	
	portLabel->setEnabled(TRUE);
//	publishBox->setEnabled(TRUE);	
	addButton->setEnabled(TRUE);
}
void kxInfoBasicImpl::SlotReceivedMainHomeInfo( QString _n,QString _f,QString _l,QString _e,QString _c,QString _st,QString _p,QString _fa,QString _ste,QString _ce,QString _zip,Q_UINT16 _con, Q_UINT8 _gmt, Q_UINT8 _pubEmail)
{
  	nickLabel->setText(_n);
  	firstNameLabel->setText(_f);
  	lastNameLabel->setText(_l);
  	if (_e.length()>0)
  	{
			QCheckListItem *i= new QCheckListItem(emailView, _e, QCheckListItem::CheckBox);
			i->setOn(	_pubEmail );		
			primaryLabel->setText(_e);
			publishBox->setChecked(_pubEmail);
		}
//		publishBox->setEnabled(TRUE);
}
void kxInfoBasicImpl::slotClicked(QListViewItem *i)
{
	if (i)
	{
		deleteButton->setEnabled(TRUE);
		changeButton->setEnabled(TRUE);	
		setPrimaryButton->setEnabled(TRUE);		
		
		if (i->text(0)==primaryLabel->text())
		{
			QCheckListItem *j=(QCheckListItem *)i;
			publishBox->setChecked(j->isOn());
		}
	}
}
void kxInfoBasicImpl::slotAddButton()
{
	kxEmailDialogImpl *dialog=new kxEmailDialogImpl(this, "email",TRUE);
	if (dialog->exec()==QDialog::Accepted)
	{
		QCheckListItem * myChild = (QCheckListItem *)emailView->firstChild();
		QStringList lst;
	  while( myChild )
	  {
	  	if (myChild->text()==dialog->getEmail()) return;
	    myChild = (QCheckListItem *)myChild->nextSibling();	
  	}		
		QCheckListItem *i;
		i=new QCheckListItem(emailView, dialog->getEmail(), QCheckListItem::CheckBox);	
		i->setOn(dialog->getPublish());
	}
}
void kxInfoBasicImpl::slotDeleteButton()
{
	QCheckListItem *i;
	i=(QCheckListItem *)emailView->selectedItem();
	delete i;
	if (emailView->childCount()<=0)
	{
		deleteButton->setEnabled(FALSE);			
		changeButton->setEnabled(FALSE);	
		setPrimaryButton->setEnabled(FALSE);	
		publishBox->setChecked(FALSE);
		primaryLabel->setText("");
	}		
}
void kxInfoBasicImpl::slotChangeButton()
{
	QCheckListItem *i;
	i=(QCheckListItem *)emailView->selectedItem();
	
	bool changePrim=FALSE;
	if(i->text()==primaryLabel->text())
		changePrim=TRUE;
	
	kxEmailDialogImpl *dialog=new kxEmailDialogImpl(this, "email",TRUE);
	dialog->setInfo( i->text(), i->isOn());
	if (dialog->exec()==QDialog::Accepted)
	{
		i->setText(0,dialog->getEmail());
		i->setOn(dialog->getPublish());
		if (changePrim)
		{
			primaryLabel->setText(dialog->getEmail());
			publishBox->setChecked(dialog->getPublish());
		}
	}
}
void kxInfoBasicImpl::slotSetPrimaryButton()
{
	QCheckListItem *i;
	i=(QCheckListItem *)emailView->selectedItem();
	publishBox->setChecked(i->isOn());
	primaryLabel->setText(i->text());
}
void kxInfoBasicImpl::addEmail(QString email, bool pub)
{
		QCheckListItem *i;
		i=new QCheckListItem(emailView, email, QCheckListItem::CheckBox);	
		i->setOn(pub);
}
