#ifndef KXINFODIALOG_H
#define KXINFODIALOG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kdialogbase.h>
#include <qwidget.h>
#include <kanimwidget.h>

class kxInfoHomeImpl;
class kxInfoBasicImpl;
class kxInfoWorkImpl;
class kxInfoPhoneImpl;
class kxInfoExtraImpl;
class kxInfoAboutImpl;

class kxInfoFrame : public QWidget
{
  Q_OBJECT
public:
  kxInfoFrame(QWidget *parent=0,  const char* name=0) : QWidget(parent,name) {};
  virtual ~kxInfoFrame() {};
  
  virtual void apply() {};
  virtual void init()  {};
  virtual void disableAll() {};
	virtual void enableAll() {};

};

class kxExtInfoDialog : public KDialogBase {
  Q_OBJECT
  
public:
	friend KDialogBase;
	
	QStringList lst;
	
  kxExtInfoDialog(QWidget *parent=0, const char *name=0);
  void setMain(QString, QString, QString, QString, bool);
  void setHome(QString, QString, QString, QString, Q_UINT16, Q_UINT8);
  void setWork(QString, QString,QString, QString,QString, QString,QString, QString, Q_UINT16, Q_UINT16);
  void setEmailList(const QStringList &lst);
  void setWorkPhone(QString, QString);
  void setHomePhone(QString, QString, QString);
  void setAbout(QString);
  void setExtra(Q_UINT16, Q_UINT8, QString , Q_UINT16,Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8);

protected:  
  QList<QWidget> widgets;
  kxInfoHomeImpl *homeInfo;
	kxInfoBasicImpl *basicInfo;
  kxInfoWorkImpl *workInfo;
	kxInfoPhoneImpl *phoneInfo;
	kxInfoAboutImpl *aboutInfo;
	kxInfoExtraImpl *extraInfo;
	
	Q_UINT32 uin;	
	QString nick;
	QString first, last, street, city, state,  primEmail, phone, fax, gsm, zip;
	Q_UINT16 country;
	Q_UINT8 gmt, pubEmail;
	QString wStreet, wName, wPos, wDiv, wZip, wCity, wState, wUrl;
	Q_UINT16 wOccu, wCountry;
	QString wPhone, wFax;
	QString about;
	QString homepage;
	Q_UINT16 age, year;
	Q_UINT8 sex, day, month, lang1, lang2, lang3;

	QString onick;
	QString ofirst, olast, ostreet, ocity, ostate,  oprimEmail, ophone, ofax, ogsm, ozip;
	Q_UINT16 ocountry;
	Q_UINT8 ogmt, opubEmail;
	QString owStreet, owName, owPos, owDiv, owZip, owCity, owState, owUrl;
	Q_UINT16 owOccu, owCountry;
	QString owPhone, owFax;
	QString oabout;
	QString ohomepage;
	Q_UINT16 oage, oyear;
	Q_UINT8 osex, oday, omonth, olang1, olang2, olang3;		
		
	Q_UINT16 seq;
	
	KAnimWidget *sendAnim;
  virtual void slotOk();
  virtual void slotApply();

public slots:
  void SlotReceivedMainHomeInfo(Q_UINT16, QString,QString,QString,QString,QString,QString,QString,QString,QString,QString,QString,Q_UINT16, Q_UINT8, Q_UINT8);
	void SlotMoreInfo(Q_UINT16, Q_UINT16, Q_UINT8, QString , Q_UINT16,Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8,Q_UINT8);
	void SlotAboutInfo(Q_UINT16, QString);
	void SlotWorkInfo(Q_UINT16, QString, QString,QString,QString,QString,QString,QString,QString,QString,QString,Q_UINT16,Q_UINT16);
	void SlotEmailInfo(Q_UINT16, QStringList);	
	void SlotSearchEnd(Q_UINT16);
	void SlotSearchFailed(Q_UINT16);

};

#endif

