#include "kxemaildialogimpl.h"
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qcheckbox.h>

/* 
 *  Constructs a kxEmailDialogImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
kxEmailDialogImpl::kxEmailDialogImpl( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : kxEmailDialog( parent, name, modal, fl )
{
	QObject::connect(okButton, SIGNAL(clicked()), SLOT(slotOkButton()));
	QObject::connect(cancelButton, SIGNAL(clicked()), SLOT(slotCancelButton()));

}

/*  
 *  Destroys the object and frees any allocated resources
 */
kxEmailDialogImpl::~kxEmailDialogImpl()
{
    // no need to delete child widgets, Qt does it all for us
}

QString kxEmailDialogImpl::getEmail()
{
	return email->text();
}
void kxEmailDialogImpl::setInfo(QString i, bool p)
{
	email->setText(i);
	publish->setChecked(!p);
}
bool kxEmailDialogImpl::getPublish()
{
	return !publish->isOn();
}
void kxEmailDialogImpl::slotOkButton()
{
	accept();
}
void kxEmailDialogImpl::slotCancelButton()
{
	reject();
}
