#include "kxsettings_securityimpl.h"
#include <kconfig.h>
#include <kglobal.h>
#include <qcheckbox.h>
#include <kxengine.h>
#include <kxmainwindow.h>


/* 
 *  Constructs a kxSettings_ContactList_OptionsImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
kxSettings_SecurityImpl::kxSettings_SecurityImpl( QWidget* parent,  const char* name, WFlags fl )
    : kxSettings_Security( parent, name, fl )
{
}

/*  
 *  Destroys the object and frees any allocated resources
 */
kxSettings_SecurityImpl::~kxSettings_SecurityImpl()
{
    // no need to delete child widgets, Qt does it all for us
}

void kxSettings_SecurityImpl::apply()
{
  KConfig *config=KGlobal::config();
  config->reparseConfiguration();
	config->setGroup("Security Settings");
  
  config->writeEntry("Web Status",webAware->isChecked());
  config->writeEntry("Hide IP",hideIp->isChecked());
  config->writeEntry("Reject Message",acceptMessage->isChecked());
  config->writeEntry("Reject URL",acceptURL->isChecked());
  config->writeEntry("Reject Rest",acceptRest->isChecked());

  config->sync();

}
void kxSettings_SecurityImpl::init()
{
  KConfig *config=KGlobal::config();
  config->reparseConfiguration();
	config->setGroup("Security Settings");
  
  webAware->setChecked(config->readBoolEntry("Web Status",TRUE));
  hideIp->setChecked(config->readBoolEntry("Hide IP",FALSE));
  acceptMessage->setChecked(config->readBoolEntry("Reject Message",FALSE));
  acceptURL->setChecked(config->readBoolEntry("Reject URL",FALSE));
  acceptRest->setChecked(config->readBoolEntry("Reject Rest",FALSE));

}
