#include <qmessagebox.h>
#include "kxsettings_general_startupimpl.h"
#include <qspinbox.h>
#include <kxmainwindow.h>
#include <qlineedit.h>
#include <qstringlist.h>
#include <kconfig.h>
#include <kglobal.h>
#include <qcheckbox.h>
#include <kcharsets.h>
#include <qcombobox.h>
#include <klocale.h>

/* 
 *  Constructs a kxSettings_General_StartupImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
kxSettings_General_StartupImpl::kxSettings_General_StartupImpl( QWidget* parent,  const char* name, WFlags fl )
    : kxSettings_General_Startup( parent, name, fl )
{
  QObject::connect(kicker,SIGNAL(released()), this, SLOT(SlotToggle()));
  QObject::connect(wMaker,SIGNAL(released()), this, SLOT(SlotToggle()));
}

/*  
 *  Destroys the object and frees any allocated resources
 */
kxSettings_General_StartupImpl::~kxSettings_General_StartupImpl()
{
    // no need to delete child widgets, Qt does it all for us
}
void kxSettings_General_StartupImpl::apply() 
{
  KConfig *config=KGlobal::config();
  config->reparseConfiguration();
  config->setGroup("Startup");
  
  config->writeEntry("Auto Connect",autoConnect->isChecked());
  config->writeEntry("Stay on Top",stayOnTop->isChecked());
  config->writeEntry("Sticky",sticky->isChecked());
  config->writeEntry("Debug output",Debug->isChecked());
  config->setGroup("Docking");
  config->writeEntry("WindowMaker Dock",wMaker->isChecked());
  config->writeEntry("KDE Dock",kicker->isChecked());
  config->setGroup("Status");
  config->writeEntry("Save Status",saveStatus->isChecked());
	config->setGroup("Contact List");
	config->writeEntry("Save Geometry",saveGeometry->isChecked());
	config->setGroup("Encoding");
	config->writeEntry("Language",lang->currentText());
  config->sync();

}
void kxSettings_General_StartupImpl::init()
{
  KConfig *config=KGlobal::config();
  config->reparseConfiguration();
  config->setGroup("Startup");
  
  autoConnect->setChecked(config->readBoolEntry("Auto Connect",TRUE));
  stayOnTop->setChecked(config->readBoolEntry("Stay on Top",TRUE));  
  sticky->setChecked(config->readBoolEntry("Sticky",FALSE));
  Debug->setChecked(config->readBoolEntry("Debug output",FALSE));
  startupStatus->setEnabled(FALSE);
  config->setGroup("Docking");
  wMaker->setChecked(config->readBoolEntry("WindowMaker Dock",FALSE));
  kicker->setChecked(config->readBoolEntry("KDE Dock",TRUE));
	config->setGroup("Contact List");
	saveGeometry->setChecked(config->readBoolEntry("Save Geometry",TRUE));
	config->setGroup("Status");
  saveStatus->setChecked(config->readBoolEntry("Save Status",TRUE));

	config->setGroup("Encoding");
  lang->insertItem("KDE Default");
  lang->insertStringList(KGlobal::charsets()->descriptiveEncodingNames ());
  QString lng=config->readEntry("Language");

  for (Q_UINT16 t=0; t<lang->count(); t++)
  {
  	if (lng==lang->text(t))
  	{
  		lang->setCurrentItem(t);
  		return;
  	}
  }
}

void kxSettings_General_StartupImpl::SlotToggle()
{
  QMessageBox::warning(this,tr("Settings Changed"),tr("You need te restart KXicq2 to activate this option."));
}
